/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketUpdateSearchItem {
    private final ResourceLocation itemId;

    public PacketUpdateSearchItem(Item item) {
        this.itemId = item.getRegistryName();
    }

    public PacketUpdateSearchItem(PacketBuffer buffer) {
        this.itemId = buffer.func_192575_l();
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_192572_a(this.itemId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player);
            if (handler.upgradeUsable(ArmorUpgradeRegistry.getInstance().searchHandler, true)) {
                ItemStack helmetStack = player.func_184582_a(EquipmentSlotType.HEAD);
                Item searchedItem = (Item)ForgeRegistries.ITEMS.getValue(this.itemId);
                if (searchedItem != null && searchedItem != Items.field_190931_a) {
                    ItemPneumaticArmor.setSearchedItem(helmetStack, searchedItem);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

