/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.tubes.ModuleLogistics;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateLogisticsModule
extends LocationIntPacket {
    private final int side;
    private final int colorIndex;
    private final int status;

    public PacketUpdateLogisticsModule(ModuleLogistics logisticsModule, int action) {
        super(logisticsModule.getTube().func_174877_v());
        this.side = logisticsModule.getDirection().ordinal();
        this.colorIndex = logisticsModule.getColorChannel();
        this.status = action > 0 ? 1 + action : (logisticsModule.hasPower() ? 1 : 0);
    }

    public PacketUpdateLogisticsModule(PacketBuffer buffer) {
        super(buffer);
        this.side = buffer.readByte();
        this.colorIndex = buffer.readByte();
        this.status = buffer.readByte();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeByte(this.side);
        buf.writeByte(this.colorIndex);
        buf.writeByte(this.status);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketUtil.getTE((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), this.pos, TileEntityPressureTube.class).ifPresent(te -> {
            TubeModule module = te.getModule(Direction.func_82600_a((int)this.side));
            if (module instanceof ModuleLogistics) {
                ((ModuleLogistics)module).onUpdatePacket(this.status, this.colorIndex);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

