/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateArmorExtraData {
    private static final List<Map<String, Integer>> VALID_KEYS = new ArrayList<Map<String, Integer>>();
    private final ResourceLocation upgradeID;
    private final EquipmentSlotType slot;
    private final CompoundNBT data;

    private static void addKey(EquipmentSlotType slot, String key, int nbtType) {
        VALID_KEYS.get(slot.func_188454_b()).put(key, nbtType);
    }

    public PacketUpdateArmorExtraData(EquipmentSlotType slot, CompoundNBT data, ResourceLocation upgradeID) {
        this.slot = slot;
        this.data = data;
        this.upgradeID = upgradeID;
    }

    PacketUpdateArmorExtraData(PacketBuffer buffer) {
        this.slot = EquipmentSlotType.values()[buffer.readByte()];
        this.data = buffer.func_150793_b();
        this.upgradeID = buffer.func_192575_l();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeByte(this.slot.ordinal());
        buf.func_150786_a(this.data);
        buf.func_192572_a(this.upgradeID);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack stack = player.func_184582_a(this.slot);
            if (stack.func_77973_b() instanceof ItemPneumaticArmor) {
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player);
                NBTUtils.initNBTTagCompound(stack);
                for (String key : this.data.func_150296_c()) {
                    INBT dataTag;
                    if (!PacketUpdateArmorExtraData.isKeyOKForSlot(key, this.slot, (dataTag = this.data.func_74781_a(key)).func_74732_a())) continue;
                    stack.func_77978_p().func_218657_a(key, dataTag);
                    IArmorUpgradeHandler<?> upgradeHandler = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(this.upgradeID);
                    if (upgradeHandler == null) continue;
                    upgradeHandler.onDataFieldUpdated(handler, key, dataTag);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static boolean isKeyOKForSlot(String key, EquipmentSlotType slot, int nbtType) {
        return VALID_KEYS.get(slot.func_188454_b()).get(key) == nbtType;
    }

    static {
        Arrays.stream(ArmorUpgradeRegistry.ARMOR_SLOTS).map(slot -> new HashMap()).forEach(VALID_KEYS::add);
        PacketUpdateArmorExtraData.addKey(EquipmentSlotType.HEAD, "entityFilter", 8);
        PacketUpdateArmorExtraData.addKey(EquipmentSlotType.HEAD, "CoordTracker", 10);
        PacketUpdateArmorExtraData.addKey(EquipmentSlotType.LEGS, "speedBoost", 3);
        PacketUpdateArmorExtraData.addKey(EquipmentSlotType.LEGS, "jumpBoost", 3);
        PacketUpdateArmorExtraData.addKey(EquipmentSlotType.FEET, "JetBootsBuilderMode", 1);
        PacketUpdateArmorExtraData.addKey(EquipmentSlotType.FEET, "JetBootsPower", 3);
        PacketUpdateArmorExtraData.addKey(EquipmentSlotType.FEET, "JetBootsStabilizers", 1);
        PacketUpdateArmorExtraData.addKey(EquipmentSlotType.FEET, "SmartHover", 1);
    }
}

