/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSyncHackSimulationUpdate
extends LocationIntPacket {
    private final List<HackSimulation.ConnectionEntry> playerConns;
    private final List<HackSimulation.ConnectionEntry> aiConns;
    private final List<Pair<Integer, Integer>> fortification;
    private final boolean aiAwake;
    private final boolean aiStopWormed;
    private final boolean aiWon;
    private final boolean playerWon;

    public PacketSyncHackSimulationUpdate(TileEntitySecurityStation te) {
        super(te.func_174877_v());
        HackSimulation aiSim = te.getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
        HackSimulation playerSim = te.getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        this.playerConns = te.getSimulationController().getSimulation((ISimulationController.HackingSide)ISimulationController.HackingSide.PLAYER).allConnections;
        this.aiConns = aiSim.allConnections;
        this.fortification = new ArrayList<Pair<Integer, Integer>>();
        for (int i = 0; i < 35; ++i) {
            if (aiSim.getNodeAt(i) == null || aiSim.getNodeAt(i).getFortification() <= 0) continue;
            this.fortification.add((Pair<Integer, Integer>)Pair.of((Object)i, (Object)aiSim.getNodeAt(i).getFortification()));
        }
        this.aiAwake = aiSim.isAwake();
        this.aiStopWormed = aiSim.isStopWormed();
        this.aiWon = aiSim.isHackComplete();
        this.playerWon = playerSim.isHackComplete();
    }

    public PacketSyncHackSimulationUpdate(PacketBuffer buffer) {
        super(buffer);
        this.playerConns = new ArrayList<HackSimulation.ConnectionEntry>();
        int np = buffer.func_150792_a();
        for (int i = 0; i < np; ++i) {
            this.playerConns.add(HackSimulation.ConnectionEntry.readFromNetwork(buffer));
        }
        this.aiConns = new ArrayList<HackSimulation.ConnectionEntry>();
        int na = buffer.func_150792_a();
        for (int i = 0; i < na; ++i) {
            this.aiConns.add(HackSimulation.ConnectionEntry.readFromNetwork(buffer));
        }
        this.fortification = new ArrayList<Pair<Integer, Integer>>();
        int nf = buffer.func_150792_a();
        for (int i = 0; i < nf; ++i) {
            this.fortification.add((Pair<Integer, Integer>)Pair.of((Object)buffer.func_150792_a(), (Object)buffer.func_150792_a()));
        }
        this.aiAwake = buffer.readBoolean();
        this.aiStopWormed = buffer.readBoolean();
        this.aiWon = buffer.readBoolean();
        this.playerWon = buffer.readBoolean();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.func_150787_b(this.playerConns.size());
        this.playerConns.forEach(conn -> conn.write(buffer));
        buffer.func_150787_b(this.aiConns.size());
        this.aiConns.forEach(conn -> conn.write(buffer));
        buffer.func_150787_b(this.fortification.size());
        this.fortification.forEach(pair -> {
            buffer.func_150787_b(((Integer)pair.getLeft()).intValue());
            buffer.func_150787_b(((Integer)pair.getRight()).intValue());
        });
        buffer.writeBoolean(this.aiAwake);
        buffer.writeBoolean(this.aiStopWormed);
        buffer.writeBoolean(this.aiWon);
        buffer.writeBoolean(this.playerWon);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ISimulationController controller;
            TileEntity te = ClientUtils.getClientTE(this.pos);
            if (te instanceof TileEntitySecurityStation && (controller = ((TileEntitySecurityStation)te).getSimulationController()) != null) {
                HackSimulation aiSim = controller.getSimulation(ISimulationController.HackingSide.AI);
                HackSimulation playerSim = controller.getSimulation(ISimulationController.HackingSide.PLAYER);
                playerSim.syncFromServer(this.playerConns);
                aiSim.syncFromServer(this.aiConns);
                aiSim.updateFortification(this.fortification);
                if (this.aiAwake) {
                    aiSim.wakeUp();
                }
                aiSim.applyStopWorm(this.aiStopWormed ? 100 : 0);
                if (this.aiWon) {
                    aiSim.setHackComplete();
                }
                if (this.playerWon) {
                    playerSim.setHackComplete();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

