/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketShowArea
extends LocationIntPacket {
    private final BlockPos[] area;

    public PacketShowArea(BlockPos pos, BlockPos ... area) {
        super(pos);
        this.area = area;
    }

    public PacketShowArea(BlockPos pos, Set<BlockPos> area) {
        this(pos, area.toArray(new BlockPos[0]));
    }

    PacketShowArea(PacketBuffer buffer) {
        super(buffer);
        this.area = new BlockPos[buffer.readInt()];
        for (int i = 0; i < this.area.length; ++i) {
            this.area[i] = buffer.func_179259_c();
        }
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.area.length);
        Arrays.stream(this.area).forEach(arg_0 -> ((PacketBuffer)buffer).func_179255_a(arg_0));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> AreaRenderManager.getInstance().showArea(this.area, -1878982657, ClientUtils.getClientTE(this.pos)));
        ctx.get().setPacketHandled(true);
    }
}

