/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammableController;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class PacketDroneDebugBase {
    final int entityId;
    final BlockPos pos;

    public PacketDroneDebugBase(IDroneBase drone) {
        if (drone instanceof EntityDrone) {
            this.entityId = ((EntityDrone)drone).func_145782_y();
            this.pos = null;
        } else if (drone instanceof TileEntityProgrammableController) {
            this.pos = ((TileEntityProgrammableController)drone).func_174877_v();
            this.entityId = -1;
        } else {
            throw new IllegalArgumentException("drone must be an EntityDrone or TileEntityProgrammableController!");
        }
    }

    public PacketDroneDebugBase(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            this.entityId = buffer.readInt();
            this.pos = null;
        } else {
            this.pos = buffer.func_179259_c();
            this.entityId = -1;
        }
    }

    PacketDroneDebugBase(int entityId, BlockPos pos) {
        this.entityId = entityId;
        this.pos = pos;
    }

    public void toBytes(PacketBuffer buf) {
        if (this.pos != null) {
            buf.writeBoolean(false);
            buf.func_179255_a(this.pos);
        } else {
            buf.writeBoolean(true);
            buf.writeInt(this.entityId);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player;
            World world = ((NetworkEvent.Context)ctx.get()).getSender() == null ? ClientUtils.getClientWorld() : ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
            Object object = player = ((NetworkEvent.Context)ctx.get()).getSender() == null ? ClientUtils.getClientPlayer() : ((NetworkEvent.Context)ctx.get()).getSender();
            if (this.entityId >= 0) {
                Entity entity = world.func_73045_a(this.entityId);
                if (entity instanceof EntityDrone) {
                    this.handle(player, (IDroneBase)entity);
                }
            } else if (this.pos != null) {
                TileEntity te = world.func_175625_s(this.pos);
                if (te instanceof TileEntityProgrammableController) {
                    this.handle(player, (IDroneBase)te);
                }
            } else {
                this.handle(player, null);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    abstract void handle(PlayerEntity var1, IDroneBase var2);
}

