/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.function.Predicate;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ItemChestUpgradeKit
extends Item {
    private final Supplier<? extends Block> chestBlock;
    private final Predicate<Block> blockPredicate;

    private ItemChestUpgradeKit(Item.Properties properties, Supplier<? extends Block> chestBlock, Predicate<Block> blockPredicate) {
        super(properties);
        this.chestBlock = chestBlock;
        this.blockPredicate = blockPredicate;
    }

    protected void onUpgraded(BlockState oldState, ItemUseContext context) {
        if (oldState.func_177230_c().func_203417_a((ITag)Tags.Blocks.CHESTS_WOODEN)) {
            PneumaticCraftUtils.dropItemOnGround(new ItemStack((IItemProvider)oldState.func_177230_c()), context.func_195991_k(), context.func_195995_a().func_177972_a(context.func_196000_l()));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos = context.func_195995_a());
        if (this.blockPredicate.test(state.func_177230_c())) {
            if (!world.field_72995_K) {
                Direction facing = state.func_235901_b_((Property)HorizontalBlock.field_185512_D) ? (Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D) : Direction.NORTH;
                TileEntity te = world.func_175625_s(pos);
                NonNullList inv = NonNullList.func_191196_a();
                if (te != null) {
                    te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                        Pair<Integer, Integer> range = this.getInvRange(state, (IItemHandler)handler);
                        for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                            inv.add((Object)handler.extractItem(i, Integer.MAX_VALUE, false));
                        }
                    });
                }
                BlockState newState = this.chestBlock.get().func_176223_P();
                world.func_175656_a(pos, (BlockState)newState.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)facing));
                if (context.func_195999_j() instanceof ServerPlayerEntity) {
                    world.func_184133_a(null, pos, SoundEvents.field_187692_g, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    world.func_217378_a(context.func_195999_j(), 2001, pos, Block.func_196246_j((BlockState)newState));
                }
                PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntityBase.class).ifPresent(teRC -> {
                    IItemHandler chestInv = teRC.getPrimaryInventory();
                    for (int i = 0; i < inv.size(); ++i) {
                        if (i < chestInv.getSlots()) {
                            chestInv.insertItem(i, (ItemStack)inv.get(i), false);
                            continue;
                        }
                        PneumaticCraftUtils.dropItemOnGround((ItemStack)inv.get(i), world, pos.func_177972_a(context.func_196000_l()));
                    }
                });
                this.onUpgraded(state, context);
                context.func_195996_i().func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    private Pair<Integer, Integer> getInvRange(BlockState state, IItemHandler handler) {
        if (state.func_177230_c() == Blocks.field_150486_ae && state.func_235901_b_((Property)ChestBlock.field_196314_b)) {
            switch ((ChestType)state.func_177229_b((Property)ChestBlock.field_196314_b)) {
                case RIGHT: {
                    return Pair.of((Object)0, (Object)(handler.getSlots() / 2));
                }
                case LEFT: {
                    return Pair.of((Object)(handler.getSlots() / 2), (Object)handler.getSlots());
                }
                case SINGLE: {
                    return Pair.of((Object)0, (Object)handler.getSlots());
                }
            }
        }
        return Pair.of((Object)0, (Object)handler.getSlots());
    }

    public static class ItemSmartChestKit
    extends ItemChestUpgradeKit {
        public ItemSmartChestKit() {
            super(ModItems.defaultProps(), (Supplier)ModBlocks.SMART_CHEST, b -> b.func_203417_a((ITag)Tags.Blocks.CHESTS_WOODEN) || b == ModBlocks.REINFORCED_CHEST.get());
        }

        @Override
        protected void onUpgraded(BlockState oldState, ItemUseContext context) {
            if (oldState.func_177230_c() == ModBlocks.REINFORCED_CHEST.get()) {
                PneumaticCraftUtils.dropItemOnGround(new ItemStack((IItemProvider)ModBlocks.REINFORCED_CHEST.get()), context.func_195991_k(), context.func_195995_a().func_177972_a(context.func_196000_l()));
            } else {
                super.onUpgraded(oldState, context);
            }
        }
    }

    public static class ItemReinforcedChestKit
    extends ItemChestUpgradeKit {
        public ItemReinforcedChestKit() {
            super(ModItems.defaultProps(), (Supplier)ModBlocks.REINFORCED_CHEST, b -> b.func_203417_a((ITag)Tags.Blocks.CHESTS_WOODEN));
        }
    }
}

