/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import com.mojang.datafixers.util.Pair;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SlotPlayer
extends Slot {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{PlayerContainer.field_226619_g_, PlayerContainer.field_226618_f_, PlayerContainer.field_226617_e_, PlayerContainer.field_226616_d_};
    private final EquipmentSlotType slotType;

    public SlotPlayer(PlayerInventory inventoryIn, EquipmentSlotType slotType, int xPosition, int yPosition) {
        super((IInventory)inventoryIn, SlotPlayer.getIndexForSlot(slotType), xPosition, yPosition);
        this.slotType = slotType;
    }

    public int func_75219_a() {
        return this.slotType == EquipmentSlotType.OFFHAND ? super.func_75219_a() : 1;
    }

    public boolean func_75214_a(ItemStack stack) {
        return this.slotType == EquipmentSlotType.OFFHAND ? super.func_75214_a(stack) : stack.canEquip(this.slotType, (Entity)((PlayerInventory)this.field_75224_c).field_70458_d);
    }

    public boolean func_82869_a(PlayerEntity playerIn) {
        if (this.slotType == EquipmentSlotType.OFFHAND) {
            return super.func_82869_a(playerIn);
        }
        ItemStack itemstack = this.func_75211_c();
        return (itemstack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(playerIn);
    }

    public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
        return this.slotType.func_188453_a() == EquipmentSlotType.Group.ARMOR ? Pair.of((Object)PlayerContainer.field_226615_c_, (Object)ARMOR_SLOT_TEXTURES[this.slotType.func_188454_b()]) : Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);
    }

    private static int getIndexForSlot(EquipmentSlotType type) {
        if (type.func_188453_a() == EquipmentSlotType.Group.ARMOR) {
            return 36 + type.func_188454_b();
        }
        if (type == EquipmentSlotType.OFFHAND) {
            return 40;
        }
        throw new IllegalArgumentException("invalid equipment slot: " + type);
    }
}

