/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.item.ItemMinigun;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerMinigunMagazine
extends ContainerPneumaticBase<TileEntityBase> {
    private final ItemMinigun.MagazineHandler gunInv;
    private final Hand hand;

    public ContainerMinigunMagazine(int i, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(i, playerInventory, ContainerMinigunMagazine.getHand(buffer));
    }

    public ContainerMinigunMagazine(int windowId, PlayerInventory playerInventory, Hand hand) {
        super((ContainerType)ModContainers.MINIGUN_MAGAZINE.get(), windowId, playerInventory);
        this.hand = hand;
        ItemMinigun minigun = (ItemMinigun)playerInventory.field_70458_d.func_184586_b(hand).func_77973_b();
        this.gunInv = minigun.getMagazine(playerInventory.field_70458_d.func_184586_b(hand));
        for (int i = 0; i < this.gunInv.getSlots(); ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.gunInv, i, 26 + i % 2 * 18, 26 + i / 2 * 18));
        }
        this.addPlayerSlots(playerInventory, 84);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.gunInv.save();
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    @Override
    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        if (clickType == ClickType.CLONE && dragType == 2 && slotId >= 0 && slotId < 4) {
            ItemStack gunStack = player.func_184586_b(this.hand);
            if (gunStack.func_77973_b() instanceof ItemMinigun) {
                int slot = ItemMinigun.getLockedSlot(gunStack);
                if (slot == slotId) {
                    NBTUtils.removeTag(gunStack, "LockedSlot");
                } else {
                    NBTUtils.setInteger(gunStack, "LockedSlot", slotId);
                }
                if (player.field_70170_p.field_72995_K) {
                    player.func_184185_a(SoundEvents.field_187909_gi, 0.5f, 1.0f);
                }
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public Hand getHand() {
        return this.hand;
    }
}

