/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class HeatExtractionTracker
extends WorldSavedData {
    private static final String DATA_NAME = "PneumaticCraftHeatExtraction";
    private final Map<BlockPos, Double> extracted = new HashMap<BlockPos, Double>();

    private HeatExtractionTracker() {
        super(DATA_NAME);
    }

    public static HeatExtractionTracker getInstance(World world) {
        return (HeatExtractionTracker)((ServerWorld)world).func_217481_x().func_215752_a(HeatExtractionTracker::new, DATA_NAME);
    }

    public double getHeatExtracted(BlockPos pos) {
        return this.extracted.getOrDefault(pos, 0.0);
    }

    public void extractHeat(BlockPos pos, double heat) {
        double newAmount = this.getHeatExtracted(pos) + heat;
        if (Math.abs(newAmount) < 1.0E-6) {
            this.extracted.remove(pos);
        } else {
            this.extracted.put(pos, newAmount);
        }
        this.func_76185_a();
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.extracted.clear();
        ListNBT list = nbt.func_150295_c("extracted", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT sub = list.func_150305_b(i);
            BlockPos pos = new BlockPos(sub.func_74762_e("x"), sub.func_74762_e("y"), sub.func_74762_e("z"));
            this.extracted.put(pos, sub.func_74769_h("heat"));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        this.extracted.forEach((pos, heat) -> {
            CompoundNBT sub = new CompoundNBT();
            sub.func_74768_a("x", pos.func_177958_n());
            sub.func_74768_a("y", pos.func_177956_o());
            sub.func_74768_a("z", pos.func_177952_p());
            sub.func_74780_a("heat", heat.doubleValue());
            list.add((Object)sub);
        });
        compound.func_218657_a("extracted", (INBT)list);
        return compound;
    }
}

