/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.Iterator;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.InventoryTrackEvent;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.drone.DroneConstructingEvent;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.ai.DroneClaimManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.block.tubes.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.capabilities.CapabilityHacking;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemMinigun;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketModWrenchBlock;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.recipes.machine.ExplosionCraftingRecipeImpl;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryController;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class MiscEventHandler {
    @SubscribeEvent
    public void onWorldTickEnd(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K) {
            DroneClaimManager.getInstance(event.world).update();
            if (event.world.func_82737_E() % 100L == 0L) {
                double tickTime = MathHelper.func_76127_a((long[])ServerLifecycleHooks.getCurrentServer().field_71311_j) * 1.0E-6;
                NetworkHandler.sendToDimension(new PacketServerTickTime(tickTime), (RegistryKey<World>)event.world.func_234923_W_());
            }
        }
    }

    @SubscribeEvent
    public void handleFuelEvent(FurnaceFuelBurnTimeEvent event) {
        ItemStack containerStack = event.getItemStack();
        if (containerStack.hasContainerItem()) {
            FluidUtil.getFluidContained((ItemStack)containerStack).ifPresent(fluidStack -> {
                ResourceLocation name = fluidStack.getFluid().getRegistryName();
                if (name != null && "pneumaticcraft".equals(name.func_110624_b())) {
                    int value = PneumaticRegistry.getInstance().getFuelRegistry().getFuelValue(null, fluidStack.getFluid());
                    if (value > 0) {
                        int amountTaken = this.amountTaken(fluidStack.getAmount(), containerStack);
                        double mult = (double)Math.min(amountTaken, fluidStack.getAmount()) / 1000.0;
                        event.setBurnTime((int)((double)value * mult * (Double)ConfigHelper.common().general.fuelBucketEfficiency.get()));
                    } else {
                        event.setBurnTime(-1);
                    }
                }
            });
        }
    }

    private int amountTaken(int origAmount, ItemStack stack) {
        int newAmount = stack.getContainerItem().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getAmount()).orElse(0);
        return origAmount - newAmount;
    }

    @SubscribeEvent
    public void explosionCraftingEvent(ExplosionEvent.Detonate event) {
        if (!((Boolean)ConfigHelper.common().recipes.explosionCrafting.get()).booleanValue() || event.getWorld().field_72995_K) {
            return;
        }
        Iterator iterator = event.getAffectedEntities().iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            Entity entity = (Entity)iterator.next();
            if (!(entity instanceof ItemEntity) || !entity.func_70089_S() || (stack = ((ItemEntity)entity).func_92059_d()).func_190926_b()) continue;
            boolean firstItem = true;
            for (ItemStack result : ExplosionCraftingRecipeImpl.tryToCraft(event.getWorld(), stack)) {
                if (firstItem) {
                    ((ItemEntity)entity).func_92058_a(result);
                    iterator.remove();
                    firstItem = false;
                    continue;
                }
                PneumaticCraftUtils.dropItemOnGround(result, event.getWorld(), entity.func_233580_cy_());
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof IDroneBase) {
            MinecraftForge.EVENT_BUS.post((Event)new DroneConstructingEvent((IDroneBase)event.getEntity()));
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(PneumaticRegistry.RL("hacking"), (ICapabilityProvider)new CapabilityHacking.Provider());
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        RayTraceResult rtr = event.getTarget();
        if (rtr != null && rtr.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult brtr = (BlockRayTraceResult)rtr;
            Block b = event.getWorld().func_180495_p(brtr.func_216350_a()).func_177230_c();
            if (b instanceof FlowingFluidBlock) {
                FlowingFluid fluid = ((FlowingFluidBlock)b).getFluid();
                if (TileEntityRefineryController.isInputFluidValid(event.getWorld(), (Fluid)fluid, 4) && event.getPlayer() instanceof ServerPlayerEntity) {
                    AdvancementTriggers.OIL_BUCKET.trigger((ServerPlayerEntity)event.getPlayer());
                }
            }
        }
    }

    @SubscribeEvent
    public void onModdedWrenchBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getWorld().func_180495_p(event.getPos());
        if (!event.isCanceled() && state.func_177230_c() instanceof IPneumaticWrenchable) {
            if (event.getHand() == Hand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(event.getPlayer().func_184586_b(Hand.MAIN_HAND))) {
                event.setCanceled(true);
            } else if (ModdedWrenchUtils.getInstance().isModdedWrench(event.getPlayer().func_184586_b(event.getHand()))) {
                if (event.getWorld().field_72995_K) {
                    NetworkHandler.sendToServer(new PacketModWrenchBlock(event.getPos(), event.getFace(), event.getHand()));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onModdedWrenchEntity(PlayerInteractEvent.EntityInteract event) {
        if (!event.isCanceled() && event.getTarget() instanceof IPneumaticWrenchable) {
            if (event.getHand() == Hand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(event.getPlayer().func_184586_b(Hand.MAIN_HAND))) {
                event.setCanceled(true);
            } else if (ModdedWrenchUtils.getInstance().isModdedWrench(event.getPlayer().func_184586_b(event.getHand()))) {
                if (event.getWorld().field_72995_K) {
                    NetworkHandler.sendToServer(new PacketModWrenchBlock(event.getPos(), event.getHand(), event.getTarget().func_145782_y()));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void quetziMoo(ServerChatEvent event) {
        if (event.getUsername().equals("Quetzz") && event.getMessage().equals("m00")) {
            for (int i = 0; i < 4; ++i) {
                NetworkHandler.sendToPlayer(new PacketPlaySound(SoundEvents.field_187558_ak, SoundCategory.NEUTRAL, event.getPlayer().func_226277_ct_(), event.getPlayer().func_226278_cu_(), event.getPlayer().func_226281_cx_(), 1.0f, 1.0f, true), event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof World) {
            World world = (World)event.getWorld();
            if (!world.field_72995_K) {
                ModuleNetworkManager.getInstance(world).invalidateCache();
            }
        }
    }

    @SubscribeEvent
    public void onInventoryTracking(InventoryTrackEvent event) {
        if (event.getTileEntity() instanceof TileEntityProgrammer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (((Boolean)ConfigHelper.common().general.enableDungeonLoot.get()).booleanValue()) {
            String prefix = "minecraft:chests/";
            String name = event.getName().toString();
            if (name.startsWith(prefix)) {
                String file;
                switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                    case "abandoned_mineshaft": 
                    case "desert_pyramid": 
                    case "jungle_temple": 
                    case "simple_dungeon": 
                    case "stronghold_corridor": 
                    case "village_blacksmith": {
                        event.getTable().addPool(this.buildLootPool("simple_dungeon_loot"));
                        break;
                    }
                }
            }
        }
    }

    private LootPool buildLootPool(String name) {
        return LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)PneumaticRegistry.RL("inject/" + name)).func_216086_a(1)).bonusRolls(0.0f, 1.0f).name("pneumaticcraft_inject").func_216044_b();
    }

    @SubscribeEvent
    public void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            if (event.getSlot().func_188453_a() == EquipmentSlotType.Group.HAND && event.getTo().func_77973_b() instanceof IPositionProvider) {
                ((IPositionProvider)event.getTo().func_77973_b()).syncVariables(player, event.getTo());
            } else if (event.getSlot() == EquipmentSlotType.MAINHAND) {
                if (event.getTo().func_77973_b() instanceof ItemMinigun) {
                    ((ItemMinigun)event.getTo().func_77973_b()).onEquipmentChange(player, event.getTo(), true);
                } else if (event.getFrom().func_77973_b() instanceof ItemMinigun) {
                    ((ItemMinigun)event.getFrom().func_77973_b()).onEquipmentChange(player, event.getFrom(), false);
                }
            } else if (event.getSlot().func_188453_a() == EquipmentSlotType.Group.ARMOR) {
                for (ItemStack stack : player.func_184193_aE()) {
                    if (stack.func_77973_b() instanceof ItemPneumaticArmor) continue;
                    return;
                }
                AdvancementTriggers.PNEUMATIC_ARMOR.trigger(player);
            }
        }
    }

    @SubscribeEvent
    public void entityMounting(EntityMountEvent event) {
        if (event.isMounting() && event.getEntityMounting() instanceof EntityDrone && (event.getEntityBeingMounted() instanceof AbstractMinecartEntity || event.getEntityBeingMounted() instanceof BoatEntity) && !event.getEntityBeingMounted().func_233570_aj_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        PneumaticHelmetRegistry.getInstance().resolveBlockTags((ITagCollection<Block>)event.getTagManager().func_241835_a());
        PneumaticRegistry.getInstance().registerXPFluid(FluidIngredient.of(1, PneumaticCraftTags.Fluids.EXPERIENCE), 20);
    }
}

