/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.entity.semiblock.EntitySemiblockBase;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;

public class EntityCropSupport
extends EntitySemiblockBase {
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.5625, 0.8125);

    public EntityCropSupport(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected AxisAlignedBB calculateBlockBounds() {
        return BOUNDS;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_73012_v.nextDouble() < (Double)ConfigHelper.common().machines.cropSticksGrowthBoostChance.get() && !this.getBlockState().isAir((IBlockReader)this.field_70170_p, this.getBlockPos())) {
            if (!this.field_70170_p.field_72995_K) {
                this.getBlockState().func_227033_a_((ServerWorld)this.field_70170_p, this.getBlockPos(), this.field_70170_p.field_73012_v);
            } else {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)this.getBlockPos().func_177958_n() + 0.5, (double)this.getBlockPos().func_177956_o() + 0.5, (double)this.getBlockPos().func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean canPlace(Direction facing) {
        BlockState state = this.getBlockState();
        return (state.func_177230_c().isAir(state, (IBlockReader)this.field_70170_p, this.getBlockPos()) || state.func_177230_c() instanceof IPlantable) && this.canStay();
    }

    @Override
    public boolean canStay() {
        BlockState state = this.getBlockState();
        if (!state.func_177230_c().isAir(state, (IBlockReader)this.field_70170_p, this.getBlockPos())) {
            return true;
        }
        BlockPos posBelow = this.getBlockPos().func_177972_a(Direction.DOWN);
        BlockState stateBelow = this.field_70170_p.func_180495_p(posBelow);
        return !stateBelow.func_177230_c().isAir(stateBelow, (IBlockReader)this.field_70170_p, posBelow);
    }

    @Override
    public ActionResultType func_184199_a(PlayerEntity player, Vector3d hitVec, Hand hand) {
        BlockState state = this.getBlockState();
        if (state.func_177230_c().isAir(state, (IBlockReader)this.field_70170_p, this.getBlockPos())) {
            Vector3d end;
            BlockPos below = this.getBlockPos().func_177977_b();
            Vector3d eye = player.func_174824_e(0.0f);
            RayTraceContext ctx = new RayTraceContext(eye, end = Vector3d.func_237489_a_((Vector3i)below).func_72441_c(0.0, 0.25, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player);
            BlockRayTraceResult brtr = player.field_70170_p.func_217299_a(ctx);
            if (brtr.func_216346_c() == RayTraceResult.Type.BLOCK && brtr.func_216350_a().equals((Object)below)) {
                return player.func_184586_b(hand).func_196084_a(new ItemUseContext(player, hand, brtr));
            }
        }
        return super.func_184199_a(player, hitVec, hand);
    }
}

