/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.living;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.entity.living.EntityBasicDrone;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryExport;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetPickupItem;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetWait;
import me.desht.pneumaticcraft.common.util.DroneProgramBuilder;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class EntityCollectorDrone
extends EntityBasicDrone {
    public EntityCollectorDrone(EntityType<? extends EntityDrone> type, World world) {
        super(type, world);
    }

    public EntityCollectorDrone(World world, PlayerEntity player) {
        super((EntityType<? extends EntityDrone>)((EntityType)ModEntities.COLLECTOR_DRONE.get()), world, player);
    }

    @Override
    public boolean addProgram(BlockPos clickPos, Direction facing, BlockPos pos, ItemStack droneStack, List<IProgWidget> widgets) {
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        BlockPos invPos = clickPos;
        ArrayList<ProgWidgetArea> params = new ArrayList<ProgWidgetArea>();
        int rangeUpgrades = UpgradableItemUtils.getUpgrades(droneStack, EnumUpgrade.RANGE);
        params.add(ProgWidgetArea.fromPosition(pos, 16 + rangeUpgrades * 2));
        LazyOptional<IItemHandler> itemCap = IOHelper.getInventoryForTE(this.field_70170_p.func_175625_s(clickPos), facing);
        if (itemCap.isPresent()) {
            Set<Item> filtered = this.getFilteredItems(itemCap);
            if (!filtered.isEmpty()) {
                filtered.forEach(item -> params.add((ProgWidgetArea)((Object)ProgWidgetItemFilter.withFilter(new ItemStack((IItemProvider)item)))));
            }
        } else {
            invPos = this.findAdjacentInventory(pos);
        }
        builder.add(new ProgWidgetPickupItem(), params.toArray(new IProgWidget[0]));
        ProgWidgetInventoryExport export = new ProgWidgetInventoryExport();
        boolean[] sides = new boolean[6];
        sides[facing.func_176745_a()] = true;
        export.setSides(sides);
        builder.add(export, ProgWidgetArea.fromPosition(invPos));
        this.maybeAddStandbyInstruction(builder, droneStack);
        builder.add(new ProgWidgetWait(), ProgWidgetText.withText("2s"));
        widgets.addAll(builder.build());
        return true;
    }

    private BlockPos findAdjacentInventory(BlockPos pos) {
        return Arrays.stream(Direction.values()).filter(d -> IOHelper.getInventoryForTE(this.field_70170_p.func_175625_s(pos.func_177972_a(d)), d.func_176734_d()).isPresent()).findFirst().map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).orElse(pos);
    }

    private Set<Item> getFilteredItems(LazyOptional<IItemHandler> cap) {
        return cap.map(handler -> IntStream.range(0, handler.getSlots()).filter(i -> !handler.getStackInSlot(i).func_190926_b()).mapToObj(i -> handler.getStackInSlot(i).func_77973_b()).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }
}

