/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import me.desht.pneumaticcraft.common.config.subconfig.IAuxConfig;
import me.desht.pneumaticcraft.lib.Log;
import org.apache.commons.io.FileUtils;

public abstract class AuxConfigJson
implements IAuxConfig {
    protected File file;
    private final boolean inPreInit;

    AuxConfigJson(boolean inPreInit) {
        this.inPreInit = inPreInit;
    }

    @Override
    public void preInit(File file) throws IOException {
        this.file = file;
        if (this.inPreInit) {
            this.processFile();
        }
    }

    @Override
    public void postInit(File file) throws IOException {
        this.file = file;
        if (!this.inPreInit) {
            this.processFile();
        }
    }

    private void processFile() throws IOException {
        if (this.file.exists()) {
            this.readFromFile();
            this.writeToFile();
        } else if (this.file.createNewFile()) {
            this.clear();
            this.writeToFile();
        }
    }

    public void writeToFile() throws IOException {
        JsonObject root = new JsonObject();
        this.writeToJson(root);
        String jsonString = root.toString();
        JsonParser parser = new JsonParser();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonElement el = parser.parse(jsonString);
        FileUtils.write((File)this.file, (CharSequence)gson.toJson(el), (Charset)Charsets.UTF_8);
    }

    public void tryWriteToFile() {
        try {
            this.writeToFile();
        }
        catch (IOException e) {
            Log.stacktrace("Failed to save config", e);
        }
    }

    private void readFromFile() throws IOException {
        JsonParser parser = new JsonParser();
        JsonObject root = (JsonObject)parser.parse(FileUtils.readFileToString((File)this.file, (Charset)Charsets.UTF_8));
        this.readFromJson(root);
    }

    protected abstract void writeToJson(JsonObject var1);

    protected abstract void readFromJson(JsonObject var1);
}

