/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockSecurityStation
extends BlockPneumaticCraft {
    private static final VoxelShape SHAPE_N = Stream.of(Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)8.0, (double)15.0), Block.func_208617_a((double)1.0, (double)10.0, (double)9.0, (double)11.0, (double)11.0, (double)15.0), Block.func_208617_a((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)11.0, (double)7.0), Block.func_208617_a((double)12.0, (double)10.0, (double)11.0, (double)15.0, (double)11.0, (double)15.0), Block.func_208617_a((double)12.25, (double)10.0, (double)7.0, (double)12.75, (double)10.5, (double)11.0), Block.func_208617_a((double)9.25, (double)10.0, (double)7.0, (double)9.75, (double)10.5, (double)9.0), Block.func_208617_a((double)3.0, (double)10.5, (double)2.0, (double)13.0, (double)14.5, (double)4.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)8.0, (double)3.0), Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0), Block.func_208617_a((double)13.25, (double)10.0, (double)7.0, (double)13.75, (double)10.5, (double)11.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.rotateY(SHAPE_E, 90);
    private static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public BlockSecurityStation() {
        super(ModBlocks.defaultProps());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction d = (Direction)state.func_177229_b((Property)this.directionProperty());
        return SHAPES[d.func_176736_b()];
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntitySecurityStation.class;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entityLiving, ItemStack iStack) {
        if (entityLiving instanceof PlayerEntity) {
            PneumaticCraftUtils.getTileEntityAt((IBlockReader)world, pos, TileEntitySecurityStation.class).ifPresent(te -> te.sharedUsers.add(((PlayerEntity)entityLiving).func_146103_bH()));
        }
        super.func_180633_a(world, pos, state, entityLiving, iStack);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        TileEntity te;
        if (player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntitySecurityStation) {
            TileEntitySecurityStation teSS = (TileEntitySecurityStation)te;
            if (teSS.isPlayerOnWhiteList(player)) {
                return super.func_225533_a_(state, world, pos, player, hand, brtr);
            }
            if (!teSS.hasValidNetwork()) {
                player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.outOfOrder", new Object[0]).func_240699_a_(TextFormatting.RED), false);
            } else if (teSS.hasPlayerHacked(player)) {
                player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.alreadyHacked", new Object[0]).func_240699_a_(TextFormatting.GOLD), false);
            } else if (this.getPlayerHackLevel(player) < teSS.getSecurityLevel()) {
                player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.cantHack", new Object[0]).func_240699_a_(TextFormatting.GOLD), false);
                player.func_70097_a(DamageSource.field_76380_i, 1.0f);
            } else {
                teSS.initiateHacking(player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private int getPlayerHackLevel(PlayerEntity player) {
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
        return handler.isArmorReady(EquipmentSlotType.HEAD) && handler.getArmorPressure(EquipmentSlotType.HEAD) > 0.0f ? handler.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.SECURITY) : 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return PneumaticCraftUtils.getTileEntityAt(blockAccess, pos, TileEntitySecurityStation.class).map(teSS -> teSS.getRedstoneController().shouldEmit() ? 15 : 0).orElse(0);
    }
}

