/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.DamageSourcePneumaticCraft;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockPlasticBrick
extends Block
implements ColorHandlers.ITintableBlock {
    private static final VoxelShape COLLISION_SHAPE = BlockPlasticBrick.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final EnumProperty<PartType> X_PART = EnumProperty.func_177709_a((String)"x_part", PartType.class);
    private static final EnumProperty<PartType> Z_PART = EnumProperty.func_177709_a((String)"z_part", PartType.class);
    private final DyeColor color;

    public BlockPlasticBrick(DyeColor color) {
        super(ModBlocks.defaultProps().func_200947_a(SoundType.field_185848_a).func_200943_b(2.0f));
        this.color = color;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(X_PART, (Comparable)((Object)PartType.NONE))).func_206870_a(Z_PART, (Comparable)((Object)PartType.NONE)));
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    public DyeColor getColor() {
        return this.color;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{X_PART, Z_PART});
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return COLLISION_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState state = super.func_196258_a(ctx);
        return this.calcParts((IWorld)ctx.func_195991_k(), ctx.func_195995_a(), state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.calcParts(worldIn, currentPos, stateIn);
    }

    private BlockState calcParts(IWorld world, BlockPos pos, BlockState stateIn) {
        boolean zRight;
        boolean xRight;
        Block w = world.func_180495_p(pos.func_177976_e()).func_177230_c();
        Block e = world.func_180495_p(pos.func_177974_f()).func_177230_c();
        PartType xType = PartType.NONE;
        boolean bl = xRight = (pos.func_177958_n() + pos.func_177956_o() & 1) == 0;
        if (xRight && w == this) {
            xType = PartType.RIGHT;
        } else if (!xRight && e == this) {
            xType = PartType.LEFT;
        }
        Block n = world.func_180495_p(pos.func_177978_c()).func_177230_c();
        Block s = world.func_180495_p(pos.func_177968_d()).func_177230_c();
        PartType zType = PartType.NONE;
        boolean bl2 = zRight = (pos.func_177952_p() + pos.func_177956_o() & 1) == 0;
        if (zRight && s == this) {
            zType = PartType.RIGHT;
        } else if (!zRight && n == this) {
            zType = PartType.LEFT;
        }
        return (BlockState)((BlockState)stateIn.func_206870_a(X_PART, (Comparable)((Object)xType))).func_206870_a(Z_PART, (Comparable)((Object)zType));
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        ItemStack stack;
        if (entityIn instanceof LivingEntity && (stack = ((LivingEntity)entityIn).func_184582_a(EquipmentSlotType.FEET)).func_190926_b()) {
            entityIn.func_70097_a(DamageSourcePneumaticCraft.PLASTIC_BLOCK, 3.0f);
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 1));
        }
    }

    @Override
    public int getTintColor(BlockState state, @Nullable IBlockDisplayReader world, @Nullable BlockPos pos, int tintIndex) {
        return this.getColor().getColorValue();
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public static class ItemPlasticBrick
    extends BlockItem
    implements ICustomTooltipName {
        public ItemPlasticBrick(BlockPlasticBrick blockPlasticBrick) {
            super((Block)blockPlasticBrick, ModItems.defaultProps());
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            return "block.pneumaticcraft.plastic_brick";
        }
    }

    static enum PartType implements IStringSerializable
    {
        NONE("none"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private PartType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

