/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DimensionMatcher
implements IPlayerMatcher {
    private final Set<ResourceLocation> dimensionIds;

    public DimensionMatcher(Set<ResourceLocation> dimensionIds) {
        this.dimensionIds = ImmutableSet.copyOf(dimensionIds);
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_150787_b(this.dimensionIds.size());
        this.dimensionIds.forEach(arg_0 -> ((PacketBuffer)buffer).func_192572_a(arg_0));
    }

    @Override
    public JsonElement toJson() {
        JsonArray res = new JsonArray();
        this.dimensionIds.forEach(id -> res.add(id.toString()));
        return res;
    }

    @Override
    public void addDescription(PlayerEntity player, List<ITextComponent> tooltip) {
        if (!this.dimensionIds.isEmpty()) {
            List<ITextComponent> items = this.dimensionIds.stream().map(id -> new StringTextComponent(id.toString())).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.dimensions", new Object[0]), items);
        }
    }

    @Override
    public boolean test(PlayerEntity playerEntity) {
        return this.dimensionIds.isEmpty() || this.dimensionIds.contains(playerEntity.field_70170_p.func_234923_W_().func_240901_a_());
    }

    public static class Factory
    implements IPlayerMatcher.MatcherFactory<DimensionMatcher> {
        @Override
        public DimensionMatcher fromJson(JsonElement json) {
            ObjectOpenHashSet dimensionIds = new ObjectOpenHashSet();
            json.getAsJsonArray().forEach(arg_0 -> Factory.lambda$fromJson$0((Set)dimensionIds, arg_0));
            return new DimensionMatcher((Set<ResourceLocation>)dimensionIds);
        }

        @Override
        public DimensionMatcher fromBytes(PacketBuffer buffer) {
            int n = buffer.func_150792_a();
            ObjectOpenHashSet dimensionIds = new ObjectOpenHashSet();
            for (int i = 0; i < n; ++i) {
                dimensionIds.add(buffer.func_192575_l());
            }
            return new DimensionMatcher((Set<ResourceLocation>)dimensionIds);
        }

        private static /* synthetic */ void lambda$fromJson$0(Set dimensionIds, JsonElement el) {
            dimensionIds.add(new ResourceLocation(el.getAsString()));
        }
    }
}

