/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class DroneAIPlace<W extends ProgWidgetAreaItemBase>
extends DroneAIBlockInteraction<W> {
    public DroneAIPlace(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.drone.world().func_180495_p(pos).func_185904_a().func_76222_j()) {
            if (Vector3d.func_237489_a_((Vector3i)pos).func_72436_e(this.drone.getDronePos()) < 1.2) {
                return false;
            }
            boolean failedOnPlacement = false;
            for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(i);
                if (!(droneStack.func_77973_b() instanceof BlockItem) || !this.progWidget.isItemValidForFilters(droneStack)) continue;
                BlockPos placerPos = this.findClearSide(pos);
                if (placerPos == null) {
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.noClearSides", pos);
                    failedOnPlacement = true;
                    break;
                }
                Block placingBlock = ((BlockItem)droneStack.func_77973_b()).func_179223_d();
                BlockState state = placingBlock.func_196258_a(this.getPlacementContext(placerPos, pos, droneStack));
                if (state == null) {
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.cantPlaceBlock", pos);
                    failedOnPlacement = true;
                    continue;
                }
                if (this.worldCache.func_195585_a(null, state.func_196954_c((IBlockReader)this.drone.world(), pos))) {
                    if (state.func_196955_c((IWorldReader)this.drone.world(), pos)) {
                        return true;
                    }
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.cantPlaceBlock", pos);
                    failedOnPlacement = true;
                    continue;
                }
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.entityInWay", pos);
                failedOnPlacement = true;
            }
            if (!failedOnPlacement) {
                this.abort();
            }
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        if (squareDistToBlock < 4.0) {
            for (int slot = 0; slot < this.drone.getInv().getSlots(); ++slot) {
                ActionResultType res;
                ItemStack droneStack = this.drone.getInv().getStackInSlot(slot);
                if (!(droneStack.func_77973_b() instanceof BlockItem) || !this.progWidget.isItemValidForFilters(droneStack) || !this.worldCache.func_180495_p(pos).func_185904_a().func_76222_j()) continue;
                BlockItem blockItem = (BlockItem)droneStack.func_77973_b();
                BlockItemUseContext ctx = this.getPlacementContext(pos, pos, droneStack);
                if (!this.progWidget.getCachedAreaSet().contains(ctx.func_195995_a()) || !(res = blockItem.func_195942_a(ctx)).func_226246_a_()) continue;
                this.drone.addAirToDrone(-100);
                if (slot == 0 && this.drone.getInv().getStackInSlot(slot).func_190926_b()) {
                    this.drone.getInv().setStackInSlot(slot, ItemStack.field_190927_a);
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private BlockPos findClearSide(BlockPos pos) {
        for (Direction side : DirectionUtil.VALUES) {
            BlockPos pos2 = pos.func_177972_a(side);
            if (!this.drone.world().func_180495_p(pos.func_177972_a(side)).func_196957_g((IBlockReader)this.drone.world(), pos2, PathType.AIR)) continue;
            return pos2;
        }
        return null;
    }

    private BlockItemUseContext getPlacementContext(BlockPos placerPos, BlockPos targetPos, ItemStack droneStack) {
        BlockRayTraceResult brtr = this.drone.world().func_217299_a(new RayTraceContext(Vector3d.func_237489_a_((Vector3i)placerPos), Vector3d.func_237489_a_((Vector3i)targetPos), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.drone.getFakePlayer()));
        return new BlockItemUseContext((ItemUseContext)new DroneBlockItemUseContext((PlayerEntity)this.drone.getFakePlayer(), droneStack, brtr));
    }

    private static class DroneBlockItemUseContext
    extends ItemUseContext {
        protected DroneBlockItemUseContext(@Nullable PlayerEntity droneFakePlayer, ItemStack heldItem, BlockRayTraceResult rayTraceResultIn) {
            super(droneFakePlayer.field_70170_p, droneFakePlayer, Hand.MAIN_HAND, heldItem, rayTraceResultIn);
        }
    }
}

