/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ICraftingWidget;
import me.desht.pneumaticcraft.common.util.DummyContainer;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ItemTagMatcher;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.IItemHandler;

public class DroneAICrafting
extends Goal {
    private final ICraftingWidget widget;
    private final IDroneBase drone;
    private final int maxActions;
    private int actionCount;

    public DroneAICrafting(IDroneBase drone, ICraftingWidget widget) {
        this.drone = drone;
        this.widget = widget;
        this.maxActions = widget.useCount() ? widget.getCount() : 0;
        this.actionCount = 0;
    }

    public boolean func_75250_a() {
        if (this.maxActions > 0 && this.actionCount >= this.maxActions) {
            return false;
        }
        CraftingInventory craftingGrid = this.widget.getCraftingGrid();
        return this.widget.getRecipe(this.drone.world(), craftingGrid).map(recipe -> {
            List<List<ItemStack>> equivalentsList = this.buildEquivalentsList(craftingGrid);
            if (equivalentsList.isEmpty()) {
                return false;
            }
            int[] equivIndices = new int[9];
            CraftingInventory craftMatrix = new CraftingInventory((Container)new DummyContainer(), 3, 3);
            do {
                for (int i = 0; i < equivalentsList.size(); ++i) {
                    ItemStack stack = equivalentsList.get(i).isEmpty() ? ItemStack.field_190927_a : equivalentsList.get(i).get(equivIndices[i]);
                    craftMatrix.func_70299_a(i, stack);
                }
                if (!recipe.func_77569_a((IInventory)craftMatrix, this.drone.world()) || !this.doCrafting(recipe.func_77572_b((IInventory)craftMatrix), craftMatrix)) continue;
                ++this.actionCount;
                return true;
            } while (this.count(equivIndices, equivalentsList));
            return false;
        }).orElse(false);
    }

    private List<List<ItemStack>> buildEquivalentsList(CraftingInventory craftingGrid) {
        ArrayList<List<ItemStack>> equivalentsList = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < craftingGrid.func_70302_i_(); ++i) {
            equivalentsList.add(new ArrayList());
            ItemStack recipeStack = craftingGrid.func_70301_a(i);
            if (recipeStack.func_190926_b()) continue;
            ArrayList<ItemStack> equivalents = new ArrayList<ItemStack>();
            for (int j = 0; j < this.drone.getInv().getSlots(); ++j) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(j);
                if (droneStack.func_190926_b() || droneStack.func_77973_b() != recipeStack.func_77973_b() && !ItemTagMatcher.matchTags(droneStack, recipeStack)) continue;
                equivalents.add(droneStack);
            }
            if (equivalents.isEmpty()) {
                return Collections.emptyList();
            }
            ((List)equivalentsList.get(i)).addAll(equivalents);
        }
        return equivalentsList;
    }

    private boolean count(int[] curIndexes, List<List<ItemStack>> equivalentsList) {
        for (int i = 0; i < equivalentsList.size(); ++i) {
            List<ItemStack> list = equivalentsList.get(i);
            int n = i;
            curIndexes[n] = curIndexes[n] + 1;
            if (!list.isEmpty() && curIndexes[i] < list.size()) {
                return true;
            }
            curIndexes[i] = 0;
        }
        return false;
    }

    public boolean doCrafting(ItemStack craftedStack, CraftingInventory craftMatrix) {
        int i;
        for (i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            int requiredCount = 0;
            ItemStack stack = craftMatrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            for (int j = 0; j < craftMatrix.func_70302_i_(); ++j) {
                if (stack != craftMatrix.func_70301_a(j)) continue;
                ++requiredCount;
            }
            if (requiredCount <= stack.func_190916_E()) continue;
            return false;
        }
        BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)this.drone.getFakePlayer(), (ItemStack)craftedStack, (IInventory)craftMatrix);
        for (i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack = craftMatrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b().hasContainerItem(stack)) {
                ItemStack containerItem = stack.func_77973_b().getContainerItem(stack);
                if (!containerItem.func_190926_b() && containerItem.func_77984_f() && containerItem.func_77952_i() > containerItem.func_77958_k()) {
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent((PlayerEntity)this.drone.getFakePlayer(), containerItem, Hand.MAIN_HAND));
                    continue;
                }
                IOHelper.insertOrDrop(this.drone.world(), containerItem, (IItemHandler)this.drone.getInv(), this.drone.getDronePos(), false);
            }
            stack.func_190918_g(1);
        }
        for (i = 0; i < this.drone.getInv().getSlots(); ++i) {
            ItemStack stack = this.drone.getInv().getStackInSlot(i);
            if (stack.func_190916_E() > 0) continue;
            this.drone.getInv().setStackInSlot(i, ItemStack.field_190927_a);
        }
        IOHelper.insertOrDrop(this.drone.world(), craftedStack, (IItemHandler)this.drone.getInv(), this.drone.getDronePos(), false);
        return true;
    }
}

