/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.BiConsumer;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class RenderUtils {
    public static final int FULL_BRIGHT = 0xF000F0;

    public static int[] decomposeColor(int color) {
        int[] res = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return res;
    }

    public static float[] decomposeColorF(int color) {
        float[] res = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return res;
    }

    private static boolean drawSide(byte mask, Direction d1, Direction d2) {
        return (mask & 1 << d1.func_176745_a() | mask & 1 << d2.func_176745_a()) != 0;
    }

    public static RenderType renderFrame(MatrixStack matrixStack, IRenderTypeBuffer buffer, AxisAlignedBB aabb, float fw, float r, float g, float b, float a, int packedLightIn, boolean disableDepthTest, Direction ... sides) {
        RenderType type = ModRenderTypes.getBlockFrame(disableDepthTest);
        IVertexBuilder builder = buffer.getBuffer(ModRenderTypes.getBlockFrame(disableDepthTest));
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        byte mask = 0;
        if (sides.length == 0) {
            mask = -1;
        } else {
            for (Direction d : sides) {
                mask = (byte)(mask | 1 << d.func_176745_a());
            }
        }
        float x1 = (float)aabb.field_72340_a;
        float y1 = (float)aabb.field_72338_b;
        float z1 = (float)aabb.field_72339_c;
        float x2 = (float)aabb.field_72336_d;
        float y2 = (float)aabb.field_72337_e;
        float z2 = (float)aabb.field_72334_f;
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y1 - fw, z1 - fw, x2 - fw, y1 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y2 - fw, z1 - fw, x2 - fw, y2 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y1 - fw, z2 - fw, x2 - fw, y1 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y2 - fw, z2 - fw, x2 - fw, y2 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.WEST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y1 - fw, z1 + fw, x1 + fw, y1 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.WEST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y2 - fw, z1 + fw, x1 + fw, y2 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.EAST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y1 - fw, z1 + fw, x2 + fw, y1 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.EAST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y2 - fw, z1 + fw, x2 + fw, y2 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.WEST, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y1 - fw, z1 - fw, x1 + fw, y2 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.EAST, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y1 - fw, z1 - fw, x2 + fw, y2 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.WEST, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y1 - fw, z2 - fw, x1 + fw, y2 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.EAST, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y1 - fw, z2 - fw, x2 + fw, y2 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        return type;
    }

    private static void renderOffsetAABB(Matrix4f posMat, IVertexBuilder builder, float x1, float y1, float z1, float x2, float y2, float z2, float r, float g, float b, float a, int packedLightIn) {
        builder.func_227888_a_(posMat, x1, y2, z1).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 0.0f, -1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y2, z1).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 0.0f, -1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y1, z1).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 0.0f, -1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x1, y1, z1).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 0.0f, -1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x1, y1, z2).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 0.0f, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y1, z2).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 0.0f, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y2, z2).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 0.0f, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x1, y2, z2).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 0.0f, 1.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x1, y1, z1).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, -1.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y1, z1).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, -1.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y1, z2).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, -1.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x1, y1, z2).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, -1.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x1, y2, z2).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 1.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y2, z2).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 1.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y2, z1).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 1.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x1, y2, z1).func_227885_a_(r, g, b, a).func_225584_a_(0.0f, 1.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x1, y1, z2).func_227885_a_(r, g, b, a).func_225584_a_(-1.0f, 0.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x1, y2, z2).func_227885_a_(r, g, b, a).func_225584_a_(-1.0f, 0.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x1, y2, z1).func_227885_a_(r, g, b, a).func_225584_a_(-1.0f, 0.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x1, y1, z1).func_227885_a_(r, g, b, a).func_225584_a_(-1.0f, 0.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y1, z1).func_227885_a_(r, g, b, a).func_225584_a_(1.0f, 0.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y2, z1).func_227885_a_(r, g, b, a).func_225584_a_(1.0f, 0.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y2, z2).func_227885_a_(r, g, b, a).func_225584_a_(1.0f, 0.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, x2, y1, z2).func_227885_a_(r, g, b, a).func_225584_a_(1.0f, 0.0f, 0.0f).func_227886_a_(packedLightIn).func_181675_d();
    }

    public static float rotateMatrixForDirection(MatrixStack matrixStack, Direction facing) {
        float yRotation;
        switch (facing) {
            case UP: {
                yRotation = 0.0f;
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStack.func_227861_a_(0.0, -1.0, -1.0);
                break;
            }
            case DOWN: {
                yRotation = 0.0f;
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                matrixStack.func_227861_a_(0.0, -1.0, 1.0);
                break;
            }
            case NORTH: {
                yRotation = 0.0f;
                break;
            }
            case EAST: {
                yRotation = 90.0f;
                break;
            }
            case SOUTH: {
                yRotation = 180.0f;
                break;
            }
            default: {
                yRotation = 270.0f;
            }
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yRotation));
        return yRotation;
    }

    public static void renderProgressingLineGUI(MatrixStack matrixStack, ProgressingLine line, int color, float lineWidth) {
        int[] cols = RenderUtils.decomposeColor(color);
        float progress = line.getProgress();
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.lineWidth((float)lineWidth);
        wr.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        wr.func_227888_a_(posMat, line.startX, line.startY, line.startZ).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        wr.func_227888_a_(posMat, MathHelper.func_219799_g((float)progress, (float)line.startX, (float)line.endX), MathHelper.func_219799_g((float)progress, (float)line.startY, (float)line.endY), MathHelper.func_219799_g((float)progress, (float)line.startZ, (float)line.endZ)).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderProgressingLine(ProgressingLine line, MatrixStack matrixStack, IVertexBuilder builder, int color) {
        int[] cols = RenderUtils.decomposeColor(color);
        float progress = line.getProgress();
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        RenderUtils.posF(builder, posMat, line.startX, line.startY, line.startZ).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        RenderUtils.posF(builder, posMat, MathHelper.func_219799_g((float)progress, (float)line.startX, (float)line.endX), MathHelper.func_219799_g((float)progress, (float)line.startY, (float)line.endY), MathHelper.func_219799_g((float)progress, (float)line.startZ, (float)line.endZ)).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
    }

    public static void renderProgressingLine(ProgressingLine prev, ProgressingLine line, float partialTick, MatrixStack matrixStack, IVertexBuilder builder, int color) {
        int[] cols = RenderUtils.decomposeColor(color);
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        float progress = line.getProgress();
        double lx1 = MathHelper.func_219799_g((float)partialTick, (float)line.startX, (float)prev.startX);
        double ly1 = MathHelper.func_219799_g((float)partialTick, (float)line.startY, (float)prev.startY);
        double lz1 = MathHelper.func_219799_g((float)partialTick, (float)line.startZ, (float)prev.startZ);
        RenderUtils.posF(builder, posMat, lx1, ly1, lz1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        RenderUtils.posF(builder, posMat, MathHelper.func_219803_d((double)progress, (double)lx1, (double)MathHelper.func_219799_g((float)partialTick, (float)line.endX, (float)prev.endX)), MathHelper.func_219803_d((double)progress, (double)ly1, (double)MathHelper.func_219799_g((float)partialTick, (float)line.endY, (float)prev.endY)), MathHelper.func_219803_d((double)progress, (double)lz1, (double)MathHelper.func_219799_g((float)partialTick, (float)line.endZ, (float)prev.endZ))).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
    }

    public static void renderRing(ProgressingLine line, ProgressingLine lastLine, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float partialTick, float rotationYaw, float rotationPitch, int color) {
        matrixStackIn.func_227860_a_();
        double renderProgress = MathHelper.func_219799_g((float)partialTick, (float)lastLine.progress, (float)line.progress);
        matrixStackIn.func_227861_a_((double)(line.endX - line.startX) * renderProgress, (double)(line.endY - line.startY) * renderProgress, (double)(line.endZ - line.startZ) * renderProgress);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotationYaw - 90.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotationPitch));
        IVertexBuilder builder = bufferIn.getBuffer(ModRenderTypes.getLineLoops(1.0));
        int[] cols = RenderUtils.decomposeColor(0xFF000000 | color);
        double size = (1.0 + 4.0 * renderProgress) / 16.0;
        Matrix4f posMat = matrixStackIn.func_227866_c_().func_227870_a_();
        for (int i = 0; i < 500; i += 25) {
            RenderUtils.posF(builder, posMat, 0.0, PneumaticCraftUtils.sin[i] * size, PneumaticCraftUtils.cos[i] * size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        }
        matrixStackIn.func_227865_b_();
    }

    public static void rotateToPlayerFacing(MatrixStack matrixStack) {
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216778_f()));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f - Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216777_e()));
    }

    public static void drawTexture(MatrixStack matrixStack, IVertexBuilder builder, int x, int y, int packedLightIn) {
        RenderUtils.drawTexture(matrixStack, builder, x, y, 0.0f, 0.0f, 1.0f, 1.0f, packedLightIn);
    }

    public static void drawTexture(MatrixStack matrixStack, IVertexBuilder builder, int x, int y, float u1, float v1, float u2, float v2, int packedLightIn) {
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(posMat, (float)x, (float)(y + 16), 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u1, v2).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, (float)(x + 16), (float)(y + 16), 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u2, v2).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, (float)(x + 16), (float)y, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u2, v1).func_227886_a_(packedLightIn).func_181675_d();
        builder.func_227888_a_(posMat, (float)x, (float)y, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u1, v1).func_227886_a_(packedLightIn).func_181675_d();
    }

    public static IVertexBuilder posF(IVertexBuilder builder, Matrix4f posMat, double x, double y, double z) {
        return builder.func_227888_a_(posMat, (float)x, (float)y, (float)z);
    }

    public static void finishBuffer(IRenderTypeBuffer buffer, RenderType type) {
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            RenderSystem.disableDepthTest();
            ((IRenderTypeBuffer.Impl)buffer).func_228462_a_(type);
        }
    }

    public static void renderWithTypeAndFinish(MatrixStack matrixStack, IRenderTypeBuffer buffer, RenderType type, BiConsumer<Matrix4f, IVertexBuilder> consumer) {
        consumer.accept(matrixStack.func_227866_c_().func_227870_a_(), buffer.getBuffer(type));
        RenderUtils.finishBuffer(buffer, type);
    }

    public static void renderWithType(MatrixStack matrixStack, IRenderTypeBuffer buffer, RenderType type, BiConsumer<Matrix4f, IVertexBuilder> consumer) {
        consumer.accept(matrixStack.func_227866_c_().func_227870_a_(), buffer.getBuffer(type));
    }

    public static void renderString3d(String str, float x, float y, int color, MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_228079_a_(str, x, y, color, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, 0xF000F0);
    }

    public static void renderString3d(String str, float x, float y, int color, MatrixStack matrixStack, IRenderTypeBuffer buffer, boolean dropShadow, boolean disableDepthTest) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_228079_a_(str, x, y, color, dropShadow, matrixStack.func_227866_c_().func_227870_a_(), buffer, disableDepthTest, 0, 0xF000F0);
    }
}

