/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import java.util.Random;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModParticleTypes;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemMinigun;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySentryTurret;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;

public class MovingSoundMinigun
extends TickableSound {
    private final Entity entity;
    private final TileEntity tileEntity;
    private boolean finished = false;

    MovingSoundMinigun(Entity entity) {
        super((SoundEvent)ModSounds.MINIGUN.get(), SoundCategory.NEUTRAL);
        this.entity = entity;
        this.tileEntity = null;
        this.init(entity instanceof EntityDrone ? ((Double)ConfigHelper.client().sound.minigunVolumeDrone.get()).floatValue() : ((Double)ConfigHelper.client().sound.minigunVolumeHeld.get()).floatValue());
    }

    MovingSoundMinigun(TileEntity te) {
        super((SoundEvent)ModSounds.MINIGUN.get(), SoundCategory.NEUTRAL);
        this.entity = null;
        this.tileEntity = te;
        this.field_147660_d = this.tileEntity.func_174877_v().func_177958_n();
        this.field_147661_e = this.tileEntity.func_174877_v().func_177956_o();
        this.field_147658_f = this.tileEntity.func_174877_v().func_177952_p();
        this.init(((Double)ConfigHelper.client().sound.minigunVolumeSentryTurret.get()).floatValue());
    }

    private void init(float volume) {
        this.field_147659_g = true;
        this.field_147665_h = 0;
        this.field_147662_b = volume;
    }

    public void func_73660_a() {
        Minigun minigun = null;
        boolean wasFinished = this.finished;
        if (this.entity != null) {
            if (!this.entity.func_70089_S()) {
                this.finished = true;
            } else {
                this.field_147660_d = (float)this.entity.func_226277_ct_();
                this.field_147661_e = (float)this.entity.func_226278_cu_();
                this.field_147658_f = (float)this.entity.func_226281_cx_();
                if (this.entity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)this.entity;
                    ItemStack curItem = player.func_184614_ca();
                    if (curItem.func_77973_b() == ModItems.MINIGUN.get()) {
                        minigun = ((ItemMinigun)ModItems.MINIGUN.get()).getMinigun(curItem, player);
                    }
                } else if (this.entity instanceof EntityDrone) {
                    minigun = ((EntityDrone)this.entity).getMinigun();
                }
            }
        } else if (this.tileEntity != null) {
            if (this.tileEntity.func_145837_r()) {
                this.finished = true;
            } else if (this.tileEntity instanceof TileEntitySentryTurret) {
                minigun = ((TileEntitySentryTurret)this.tileEntity).getMinigun();
            }
        }
        if (minigun != null) {
            this.playParticles(minigun);
        }
        boolean bl = this.finished = minigun == null || !minigun.isMinigunActivated() || (double)minigun.getMinigunSpeed() < 0.36000000536441806;
        if (this.finished && !wasFinished) {
            Vector3d startVec;
            ClientUtils.getClientWorld().func_184148_a(ClientUtils.getClientPlayer(), this.field_147660_d, this.field_147661_e, this.field_147658_f, (SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundCategory.NEUTRAL, this.field_147662_b, 1.0f);
            if (minigun != null && (startVec = minigun.getMuzzlePosition()) != null) {
                ClientUtils.getClientWorld().func_195594_a((IParticleData)ParticleTypes.field_197594_E, startVec.field_72450_a, startVec.field_72448_b, startVec.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }

    private void playParticles(Minigun minigun) {
        Vector3d muzzlePos = minigun.getMuzzlePosition();
        if (muzzlePos == null) {
            return;
        }
        Vector3d lookVec = minigun.getLookAngle();
        Random r = ClientUtils.getClientWorld().field_73012_v;
        for (int i = 0; i < 10; ++i) {
            Vector3d velVec = lookVec.func_186678_a((double)(3.0f + (float)i * 0.2f));
            Particle bullet = Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)ModParticleTypes.BULLET_PARTICLE.get(), muzzlePos.field_72450_a + (double)(r.nextFloat() * 0.1f) - (double)0.05f, muzzlePos.field_72448_b + (double)(r.nextFloat() * 0.1f) - (double)0.05f, muzzlePos.field_72449_c + (double)(r.nextFloat() * 0.1f) - (double)0.05f, velVec.field_72450_a, velVec.field_72448_b, velVec.field_72449_c);
            if (bullet == null) continue;
            switch (r.nextInt(8)) {
                case 0: {
                    bullet.func_70538_b(0.1f, 0.1f, 0.1f);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    bullet.func_70538_b(1.0f, 0.25f + r.nextFloat() * 0.75f, 0.0f);
                    break;
                }
                default: {
                    float[] rgb = RenderUtils.decomposeColorF(minigun.getAmmoColor());
                    bullet.func_70538_b(rgb[1], rgb[2], rgb[3]);
                }
            }
            bullet.func_70541_f(minigun.getParticleScale());
        }
        if (r.nextInt(10) == 0) {
            ClientUtils.getClientWorld().func_195594_a((IParticleData)ParticleTypes.field_197631_x, muzzlePos.field_72450_a, muzzlePos.field_72448_b, muzzlePos.field_72449_c, lookVec.field_72450_a * (double)0.01f, lookVec.field_72448_b * (double)0.01f, lookVec.field_72449_c * (double)0.01f);
        }
    }

    public boolean func_147667_k() {
        return this.finished;
    }
}

