/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pressure_gauge;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public class PressureGaugeRenderer3D {
    private static final float RADIUS = 19.0f;
    private static final float PI_F = (float)Math.PI;
    private static final float START_ANGLE = 4.1887903f;
    private static final float STOP_ANGLE = -1.0471976f;
    private static final int CIRCLE_POINTS = 180;
    private static final int GAUGE_POINTS = 150;

    public static void drawPressureGauge(MatrixStack matrixStack, IRenderTypeBuffer buffer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos) {
        PressureGaugeRenderer3D.drawPressureGauge(matrixStack, buffer, minPressure, maxPressure, dangerPressure, minWorkingPressure, currentPressure, xPos, yPos, -16777216);
    }

    public static void drawPressureGauge(MatrixStack matrixStack, IRenderTypeBuffer buffer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos, int fgColor) {
        RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.TRIANGLE_FAN, (posMat, builder) -> PressureGaugeRenderer3D.drawGaugeBackground(posMat, builder, minPressure, maxPressure, dangerPressure, minWorkingPressure, xPos, yPos));
        RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.getLineLoops(2.0), (posMat, builder) -> PressureGaugeRenderer3D.drawGaugeSurround(posMat, builder, xPos, yPos, fgColor));
        int currentScale = (int)maxPressure;
        ArrayList<PressureGaugeRenderer2D.TextScaler> textScalers = new ArrayList<PressureGaugeRenderer2D.TextScaler>();
        RenderUtils.renderWithType(matrixStack, buffer, (RenderType)RenderType.field_228614_Q_, (posMat, builder) -> PressureGaugeRenderer3D.drawScale(posMat, builder, minPressure, maxPressure, xPos, yPos, currentScale, textScalers));
        RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.getLineLoops(2.0), (posMat, builder) -> {
            float angleIndicator = 150 - (int)((currentPressure - minPressure) / (maxPressure - minPressure) * 150.0f);
            angleIndicator = -angleIndicator / 180.0f * 2.0f * (float)Math.PI - -1.0471976f;
            PressureGaugeRenderer3D.drawNeedle(posMat, builder, xPos, yPos, angleIndicator, fgColor);
        });
        PressureGaugeRenderer3D.drawText(matrixStack, buffer, xPos, yPos, fgColor, textScalers);
    }

    private static void drawGaugeBackground(Matrix4f posMat, IVertexBuilder builder, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, int xPos, int yPos) {
        float[] color = PressureGaugeRenderer2D.RED;
        RenderUtils.posF(builder, posMat, xPos, yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
        int explodeBoundary = 150 - (int)((dangerPressure - minPressure) / (maxPressure - minPressure) * 150.0f);
        int workingBoundary = 150 - (int)((minWorkingPressure - minPressure) / (maxPressure - minPressure) * 150.0f);
        boolean changedColorGreen = false;
        boolean changedColorYellow = false;
        for (int i = 0; i < 150; ++i) {
            if (i == explodeBoundary && !changedColorGreen) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? PressureGaugeRenderer2D.YELLOW : PressureGaugeRenderer2D.GREEN;
                RenderUtils.posF(builder, posMat, xPos, yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
                --i;
                changedColorGreen = true;
            }
            if (i == workingBoundary && !changedColorYellow) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? PressureGaugeRenderer2D.GREEN : PressureGaugeRenderer2D.YELLOW;
                RenderUtils.posF(builder, posMat, xPos, yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
                --i;
                changedColorYellow = true;
            }
            float angle = (float)(-i) / 180.0f * 2.0f * (float)Math.PI - -1.0471976f;
            RenderUtils.posF(builder, posMat, MathHelper.func_76134_b((float)angle) * 19.0f + (float)xPos, MathHelper.func_76126_a((float)angle) * 19.0f + (float)yPos, 0.0).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
        }
    }

    private static void drawGaugeSurround(Matrix4f posMat, IVertexBuilder builder, int xPos, int yPos, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        for (int i = 0; i < 180; ++i) {
            float angle = (float)i / 180.0f * 2.0f * (float)Math.PI;
            RenderUtils.posF(builder, posMat, MathHelper.func_76134_b((float)angle) * 19.0f + (float)xPos, MathHelper.func_76126_a((float)angle) * 19.0f + (float)yPos, 0.0).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        }
    }

    private static void drawScale(Matrix4f posMat, IVertexBuilder builder, float minPressure, float maxPressure, int xPos, int yPos, int currentScale, List<PressureGaugeRenderer2D.TextScaler> textScalers) {
        for (int i = 0; i <= 150; ++i) {
            float angle = (float)(-i) / 180.0f * 2.0f * (float)Math.PI - -1.0471976f;
            if (i != 150 - (int)(((float)currentScale - minPressure) / (maxPressure - minPressure) * 150.0f)) continue;
            float x = MathHelper.func_76134_b((float)angle);
            float y = MathHelper.func_76126_a((float)angle);
            textScalers.add(new PressureGaugeRenderer2D.TextScaler(currentScale, (int)(x * 19.0f * 1.3f), (int)(y * 19.0f * 1.3f)));
            --currentScale;
            float r1 = maxPressure > 10.0f && textScalers.size() % 5 == 1 ? 0.8f : 0.92f;
            float r2 = maxPressure > 10.0f && textScalers.size() % 5 == 1 ? 1.15f : 1.08f;
            builder.func_227888_a_(posMat, x * 19.0f * r1 + (float)xPos, y * 19.0f * r1 + (float)yPos, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            builder.func_227888_a_(posMat, x * 19.0f * r2 + (float)xPos, y * 19.0f * r2 + (float)yPos, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        }
    }

    private static void drawNeedle(Matrix4f posMat, IVertexBuilder builder, int xPos, int yPos, float angle, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        builder.func_227888_a_(posMat, MathHelper.func_76134_b((float)(angle + 2.7960174f)) * 19.0f * 0.3f + (float)xPos, MathHelper.func_76126_a((float)(angle + 2.7960174f)) * 19.0f * 0.3f + (float)yPos, 0.0f).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        builder.func_227888_a_(posMat, MathHelper.func_76134_b((float)(angle + 3.487168f)) * 19.0f * 0.3f + (float)xPos, MathHelper.func_76126_a((float)(angle + 3.487168f)) * 19.0f * 0.3f + (float)yPos, 0.0f).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        builder.func_227888_a_(posMat, MathHelper.func_76134_b((float)angle) * 19.0f * 0.8f + (float)xPos, MathHelper.func_76126_a((float)angle) * 19.0f * 0.8f + (float)yPos, 0.0f).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
    }

    private static void drawText(MatrixStack matrixStack, IRenderTypeBuffer buffer, int xPos, int yPos, int fgColor, List<PressureGaugeRenderer2D.TextScaler> textScalers) {
        for (int i = 0; i < textScalers.size(); ++i) {
            if (textScalers.size() > 11 && i % 5 != 0) continue;
            PressureGaugeRenderer2D.TextScaler scaler = textScalers.get(i);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(xPos + scaler.x) - 1.5, (double)(yPos + scaler.y) - 1.5, 0.0);
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            RenderUtils.renderString3d(Integer.toString(scaler.pressure), 0.0f, 0.0f, fgColor, matrixStack, buffer, false, false);
            matrixStack.func_227865_b_();
        }
    }
}

