/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pressure_gauge;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public class PressureGaugeRenderer2D {
    static final int CIRCLE_POINTS = 500;
    static final float RADIUS = 20.0f;
    private static final float PI_F = (float)Math.PI;
    private static final float START_ANGLE = 4.1887903f;
    static final float STOP_ANGLE = -1.0471976f;
    static final int GAUGE_POINTS = 416;
    static final float[] RED = new float[]{0.722f, 0.255f, 0.255f, 1.0f};
    static final float[] GREEN = new float[]{0.475f, 0.678f, 0.224f, 1.0f};
    static final float[] YELLOW = new float[]{0.922f, 0.635f, 0.239f, 1.0f};

    public static void drawPressureGauge(MatrixStack matrixStack, FontRenderer fontRenderer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos) {
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, fontRenderer, minPressure, maxPressure, dangerPressure, minWorkingPressure, currentPressure, xPos, yPos, -16777216);
    }

    public static void drawPressureGauge(MatrixStack matrixStack, FontRenderer fontRenderer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos, int fgColor) {
        RenderSystem.disableTexture();
        RenderSystem.lineWidth((float)1.0f);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        PressureGaugeRenderer2D.drawGaugeBackground(matrixStack, (IVertexBuilder)wr, minPressure, maxPressure, dangerPressure, minWorkingPressure, xPos, yPos);
        Tessellator.func_178181_a().func_78381_a();
        wr.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        PressureGaugeRenderer2D.drawGaugeSurround(matrixStack, (IVertexBuilder)wr, xPos, yPos, fgColor);
        Tessellator.func_178181_a().func_78381_a();
        int currentScale = (int)maxPressure;
        ArrayList<TextScaler> textScalers = new ArrayList<TextScaler>();
        wr.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        PressureGaugeRenderer2D.drawScale(matrixStack, (IVertexBuilder)wr, minPressure, maxPressure, xPos, yPos, currentScale, textScalers);
        Tessellator.func_178181_a().func_78381_a();
        float angleIndicator = 416 - (int)((currentPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        angleIndicator = -angleIndicator / 500.0f * 2.0f * (float)Math.PI - -1.0471976f;
        wr.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        PressureGaugeRenderer2D.drawNeedle(matrixStack, (IVertexBuilder)wr, xPos, yPos, angleIndicator, fgColor);
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        PressureGaugeRenderer2D.drawText(matrixStack, fontRenderer, xPos, yPos, fgColor, textScalers);
    }

    private static void drawNeedle(MatrixStack matrixStack, IVertexBuilder builder, int xPos, int yPos, float angle, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(posMat, MathHelper.func_76134_b((float)(angle + 2.7960174f)) * 20.0f * 0.3f + (float)xPos, MathHelper.func_76126_a((float)(angle + 2.7960174f)) * 20.0f * 0.3f + (float)yPos, 0.0f).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        builder.func_227888_a_(posMat, MathHelper.func_76134_b((float)(angle + 3.487168f)) * 20.0f * 0.3f + (float)xPos, MathHelper.func_76126_a((float)(angle + 3.487168f)) * 20.0f * 0.3f + (float)yPos, 0.0f).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        builder.func_227888_a_(posMat, MathHelper.func_76134_b((float)angle) * 20.0f * 0.8f + (float)xPos, MathHelper.func_76126_a((float)angle) * 20.0f * 0.8f + (float)yPos, 0.0f).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
    }

    private static void drawScale(MatrixStack matrixStack, IVertexBuilder builder, float minPressure, float maxPressure, int xPos, int yPos, int currentScale, List<TextScaler> textScalers) {
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        for (int i = 0; i <= 416; ++i) {
            float angle = (float)(-i) / 500.0f * 2.0f * (float)Math.PI - -1.0471976f;
            if (i != 416 - (int)(((float)currentScale - minPressure) / (maxPressure - minPressure) * 416.0f)) continue;
            float x = MathHelper.func_76134_b((float)angle);
            float y = MathHelper.func_76126_a((float)angle);
            textScalers.add(new TextScaler(currentScale, (int)((double)(x * 20.0f) * 1.25), (int)((double)(y * 20.0f) * 1.25)));
            --currentScale;
            float r1 = maxPressure > 10.0f && textScalers.size() % 5 == 1 ? 0.8f : 0.92f;
            float r2 = maxPressure > 10.0f && textScalers.size() % 5 == 1 ? 1.15f : 1.08f;
            builder.func_227888_a_(posMat, x * 20.0f * r1 + (float)xPos, y * 20.0f * r1 + (float)yPos, 0.0f).func_225586_a_(0, 0, 0, 1).func_181675_d();
            builder.func_227888_a_(posMat, x * 20.0f * r2 + (float)xPos, y * 20.0f * r2 + (float)yPos, 0.0f).func_225586_a_(0, 0, 0, 1).func_181675_d();
        }
    }

    private static void drawText(MatrixStack matrixStack, FontRenderer fontRenderer, int xPos, int yPos, int fgColor, List<TextScaler> textScalers) {
        for (int i = 0; i < textScalers.size(); ++i) {
            if (textScalers.size() > 11 && i % 5 != 0) continue;
            TextScaler scaler = textScalers.get(i);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(xPos + scaler.x) - 1.5, (double)(yPos + scaler.y) - 1.5, 0.0);
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            fontRenderer.func_238421_b_(matrixStack, Integer.toString(scaler.pressure), 0.0f, 0.0f, fgColor);
            matrixStack.func_227865_b_();
        }
    }

    private static void drawGaugeBackground(MatrixStack matrixStack, IVertexBuilder builder, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, int xPos, int yPos) {
        float[] color = RED;
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(posMat, (float)xPos, (float)yPos, 0.0f).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
        int explodeBoundary = 416 - (int)((dangerPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        int workingBoundary = 416 - (int)((minWorkingPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        boolean changedColorGreen = false;
        boolean changedColorYellow = false;
        for (int i = 0; i < 416; ++i) {
            if (i == explodeBoundary && !changedColorGreen) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? YELLOW : GREEN;
                builder.func_227888_a_(posMat, (float)xPos, (float)yPos, 0.0f).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
                --i;
                changedColorGreen = true;
            }
            if (i == workingBoundary && !changedColorYellow) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? GREEN : YELLOW;
                builder.func_227888_a_(posMat, (float)xPos, (float)yPos, 0.0f).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
                --i;
                changedColorYellow = true;
            }
            float angle = (float)(-i) / 500.0f * 2.0f * (float)Math.PI - -1.0471976f;
            builder.func_227888_a_(posMat, MathHelper.func_76134_b((float)angle) * 20.0f + (float)xPos, MathHelper.func_76126_a((float)angle) * 20.0f + (float)yPos, 0.0f).func_227885_a_(color[0], color[1], color[2], color[3]).func_181675_d();
        }
    }

    private static void drawGaugeSurround(MatrixStack matrixStack, IVertexBuilder builder, int xPos, int yPos, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        for (int i = 0; i < 500; ++i) {
            float angle = (float)i / 500.0f * 2.0f * (float)Math.PI;
            builder.func_227888_a_(posMat, MathHelper.func_76134_b((float)angle) * 20.0f + (float)xPos, MathHelper.func_76126_a((float)angle) * 20.0f + (float)yPos, 0.0f).func_227885_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        }
    }

    static class TextScaler {
        final int pressure;
        final int x;
        final int y;

        TextScaler(int pressure, int x, int y) {
            this.pressure = pressure;
            this.x = x;
            this.y = y;
        }
    }
}

