/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.common.entity.semiblock.EntitySpawnerAgitator;
import me.desht.pneumaticcraft.common.hacking.block.HackableMobSpawner;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.Reflections;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;

public class BlockTrackEntryMobSpawner
implements IBlockTrackEntry {
    private static final ResourceLocation ID = PneumaticRegistry.RL("block_tracker.module.spawner");

    @Override
    public boolean shouldTrackWithThisEntry(IBlockReader world, BlockPos pos, BlockState state, TileEntity te) {
        return state.func_177230_c() == Blocks.field_150474_ac;
    }

    @Override
    public List<BlockPos> getServerUpdatePositions(TileEntity te) {
        return te == null ? Collections.emptyList() : Collections.singletonList(te.func_174877_v());
    }

    @Override
    public int spamThreshold() {
        return 10;
    }

    @Override
    public void addInformation(World world, BlockPos pos, TileEntity te, Direction face, List<ITextComponent> infoList) {
        if (te instanceof MobSpawnerTileEntity) {
            AbstractSpawner spawner = ((MobSpawnerTileEntity)te).func_145881_a();
            Entity e = spawner.func_184994_d();
            if (e == null) {
                infoList.add((ITextComponent)new StringTextComponent("<ERROR> Missing entity?"));
                return;
            }
            infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.type", e.func_200200_C_().getString()));
            if (Reflections.isActivated(spawner) || this.hasAgitator(world, pos)) {
                infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.time", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(spawner.field_98286_b, false)));
            } else if (HackableMobSpawner.isHacked((IBlockReader)world, pos)) {
                infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.hacked", new Object[0]));
            } else {
                infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.spawner.standby", new Object[0]));
            }
        }
    }

    private boolean hasAgitator(World world, BlockPos pos) {
        return SemiblockTracker.getInstance().getSemiblock(world, pos) instanceof EntitySpawnerAgitator;
    }

    @Override
    public ResourceLocation getEntryID() {
        return ID;
    }
}

