/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.DroneDebuggerOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderDroneAI;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderTargetCircle;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.entity_tracker.EntityTrackHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.EntityProgrammableController;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.entity.living.EntityDroneBase;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityStart;
import me.desht.pneumaticcraft.common.network.PacketUpdateDebuggingDrone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.event.InputEvent;

public class RenderEntityTarget {
    private static final float STAT_SCALE = 0.02f;
    public final Entity entity;
    private final RenderTargetCircle circle1;
    private final RenderTargetCircle circle2;
    public int ticksExisted = 0;
    private float oldSize;
    private final IGuiAnimatedStat stat;
    private boolean didMakeLockSound;
    public boolean isLookingAtTarget;
    private List<ITextComponent> textList = new ArrayList<ITextComponent>();
    private final List<IEntityTrackEntry> trackEntries;
    private int hackTime;
    private double distToEntity;

    public RenderEntityTarget(Entity entity) {
        this.entity = entity;
        this.trackEntries = EntityTrackHandler.getTrackersForEntity(entity);
        this.circle1 = new RenderTargetCircle(entity);
        this.circle2 = new RenderTargetCircle(entity);
        this.stat = new WidgetAnimatedStat(null, entity.func_145748_c_(), WidgetAnimatedStat.StatIcon.NONE, 20, -20, HUDHandler.getInstance().getStatOverlayColor(), null, false);
        this.stat.setMinimumContractedDimensions(0, 0);
        this.stat.setAutoLineWrap(false);
    }

    public RenderDroneAI getDroneAIRenderer() {
        for (IEntityTrackEntry tracker : this.trackEntries) {
            if (!(tracker instanceof EntityTrackHandler.EntityTrackEntryDrone)) continue;
            return ((EntityTrackHandler.EntityTrackEntryDrone)tracker).getDroneAIRenderer();
        }
        throw new IllegalStateException("[RenderTarget] Drone entity, but no drone AI Renderer?");
    }

    public void update() {
        this.stat.tickWidget();
        this.stat.setTitle(this.entity.func_145748_c_());
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        this.distToEntity = this.entity.func_70032_d((Entity)ClientUtils.getClientPlayer());
        if (this.ticksExisted >= 30 && !this.didMakeLockSound) {
            this.didMakeLockSound = true;
            player.field_70170_p.func_184134_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)ModSounds.HUD_ENTITY_LOCK.get(), SoundCategory.PLAYERS, 0.1f, 1.0f, true);
        }
        boolean tagged = this.entity instanceof EntityDroneBase && ItemPneumaticArmor.isPlayerDebuggingDrone((PlayerEntity)player, (EntityDroneBase)this.entity);
        this.circle1.setRenderingAsTagged(tagged);
        this.circle2.setRenderingAsTagged(tagged);
        this.circle1.update();
        this.circle2.update();
        for (IEntityTrackEntry tracker : this.trackEntries) {
            tracker.update(this.entity);
        }
        this.isLookingAtTarget = this.isPlayerLookingAtTarget();
        if (this.hackTime > 0) {
            IHackableEntity hackableEntity = HackManager.getHackableForEntity(this.entity, ClientUtils.getClientPlayer());
            this.hackTime = hackableEntity != null ? ++this.hackTime : 0;
        }
    }

    public boolean isInitialized() {
        return this.ticksExisted > 120;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks, boolean justRenderWhenHovering) {
        for (IEntityTrackEntry tracker : this.trackEntries) {
            tracker.render(matrixStack, buffer, this.entity, partialTicks);
        }
        double x = MathHelper.func_219803_d((double)partialTicks, (double)this.entity.field_70169_q, (double)this.entity.func_226277_ct_());
        double y = MathHelper.func_219803_d((double)partialTicks, (double)this.entity.field_70167_r, (double)this.entity.func_226278_cu_()) + (double)this.entity.func_213302_cg() / 2.0;
        double z = MathHelper.func_219803_d((double)partialTicks, (double)this.entity.field_70166_s, (double)this.entity.func_226281_cx_());
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(x, y, z);
        RenderUtils.rotateToPlayerFacing(matrixStack);
        float size = this.entity.func_213302_cg() * 0.5f;
        float alpha = 0.5f;
        if (this.ticksExisted < 60) {
            size += 5.0f - (float)Math.abs(this.ticksExisted) * 0.083f;
            alpha = (float)Math.abs(this.ticksExisted) * 0.005f;
        }
        float renderSize = MathHelper.func_219799_g((float)partialTicks, (float)this.oldSize, (float)size);
        this.circle1.render(matrixStack, buffer, renderSize, partialTicks, alpha);
        this.circle2.render(matrixStack, buffer, renderSize + 0.2f, partialTicks, alpha);
        float targetAcquireProgress = ((float)this.ticksExisted + partialTicks - 50.0f) / 0.7f;
        if (this.ticksExisted > 50 && this.ticksExisted <= 120) {
            RenderProgressBar.render3d(matrixStack, buffer, 0.0, 0.4, 1.8, 0.7, 0.0, targetAcquireProgress, -788529408, -805241088);
        }
        matrixStack.func_227862_a_(0.02f, 0.02f, 0.02f);
        if (this.ticksExisted > 120) {
            if (justRenderWhenHovering && !this.isLookingAtTarget) {
                this.stat.closeStat();
            } else {
                this.stat.openStat();
            }
            this.textList = new ArrayList<ITextComponent>();
            for (IEntityTrackEntry tracker : this.trackEntries) {
                tracker.addInfo(this.entity, this.textList, this.isLookingAtTarget);
            }
            this.textList.add((ITextComponent)new StringTextComponent(String.format("Dist: %.1fm", this.distToEntity)));
            this.stat.setText(this.textList);
            float mul = this.getStatSizeMultiplier(this.distToEntity);
            matrixStack.func_227862_a_(mul, mul, mul);
            this.stat.renderStat(matrixStack, buffer, partialTicks);
        } else if (this.ticksExisted > 50) {
            RenderUtils.renderString3d("Acquiring Target...", 0.0f, 0.0f, -8421505, matrixStack, buffer, false, true);
            RenderUtils.renderString3d((int)targetAcquireProgress + "%", 37.0f, 24.0f, -16765184, matrixStack, buffer, false, true);
        } else if (this.ticksExisted < -30) {
            this.stat.closeStat();
            this.stat.renderStat(matrixStack, buffer, partialTicks);
            RenderUtils.renderString3d("Lost Target!", 0.0f, 0.0f, -8421505, matrixStack, buffer, false, true);
        }
        matrixStack.func_227865_b_();
        this.oldSize = size;
    }

    private float getStatSizeMultiplier(double dist) {
        if (dist < 4.0) {
            return (float)(dist / 4.0);
        }
        if (dist < 10.0) {
            return 1.0f;
        }
        return (float)(dist / 10.0);
    }

    public List<ITextComponent> getEntityText() {
        return this.textList;
    }

    private boolean isPlayerLookingAtTarget() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Vector3d vec3 = player.func_70676_i(1.0f).func_72432_b();
        Vector3d vec31 = new Vector3d(this.entity.func_226277_ct_() - player.func_226277_ct_(), this.entity.func_174813_aQ().field_72338_b + (double)(this.entity.func_213302_cg() / 2.0f) - (player.func_226278_cu_() + (double)player.func_70047_e()), this.entity.func_226281_cx_() - player.func_226281_cx_());
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        return d1 > 1.0 - 0.05 / d0;
    }

    public void hack() {
        IHackableEntity hackable;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (hackable = HackManager.getHackableForEntity(this.entity, ClientUtils.getClientPlayer())) != null && (this.hackTime == 0 || this.hackTime > hackable.getHackTime(this.entity, ClientUtils.getClientPlayer()))) {
            NetworkHandler.sendToServer(new PacketHackingEntityStart(this.entity));
        }
    }

    public void selectAsDebuggingTarget() {
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && this.entity instanceof EntityDroneBase) {
            DroneDebuggerOptions.clearAreaShowWidgetId();
            if (ItemPneumaticArmor.isPlayerDebuggingDrone(ClientUtils.getClientPlayer(), (EntityDroneBase)this.entity)) {
                NetworkHandler.sendToServer(new PacketUpdateDebuggingDrone(-1));
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.SCI_FI.get(), 1.0f, 2.0f);
            } else if (this.entity instanceof EntityDrone) {
                NetworkHandler.sendToServer(new PacketUpdateDebuggingDrone(this.entity.func_145782_y()));
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.HUD_ENTITY_LOCK.get(), 1.0f, 2.0f);
            } else if (this.entity instanceof EntityProgrammableController) {
                NetworkHandler.sendToServer(new PacketUpdateDebuggingDrone(((EntityProgrammableController)this.entity).getControllerPos()));
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.HUD_ENTITY_LOCK.get(), 1.0f, 2.0f);
            }
        }
    }

    public void onHackConfirmServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(InputEvent.MouseScrollEvent event) {
        if (this.isInitialized() && this.isPlayerLookingAtTarget()) {
            return this.stat.func_231043_a_(event.getMouseX(), event.getMouseY(), event.getScrollDelta());
        }
        return false;
    }

    public void updateColor(int color) {
        this.stat.setBackgroundColor(color);
    }
}

