/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.model.entity.semiblocks.ModelLogisticsFrame;
import me.desht.pneumaticcraft.client.render.entity.RenderSemiblockBase;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderLogisticsFrame
extends RenderSemiblockBase<EntityLogisticsFrame> {
    public static final IRenderFactory<EntityLogisticsFrame> FACTORY = RenderLogisticsFrame::new;
    private final ModelLogisticsFrame model = new ModelLogisticsFrame();

    private RenderLogisticsFrame(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public void render(EntityLogisticsFrame entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Direction side;
        float alpha = (float)entity.getAlpha() / 255.0f;
        if (alpha == 0.0f) {
            return;
        }
        if (entity.isAir()) {
            return;
        }
        matrixStackIn.func_227860_a_();
        if (entity.getTimeSinceHit() > 0) {
            this.wobble(entity, partialTicks, matrixStackIn);
        }
        matrixStackIn.func_227861_a_(0.0, (side = entity.getSide()).func_176740_k() == Direction.Axis.Y ? 0.5 : -0.5, 0.0);
        switch (side) {
            case UP: {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                matrixStackIn.func_227861_a_(0.0, -1.0, 0.0);
                break;
            }
            case DOWN: {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
                matrixStackIn.func_227861_a_(0.0, -1.0, 0.0);
                break;
            }
            case NORTH: {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                break;
            }
            case WEST: {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                break;
            }
        }
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getTextureLocation(entity)));
        this.model.func_225598_a_(matrixStackIn, builder, this.kludgeLightingLevel(entity, packedLightIn), OverlayTexture.func_229200_a_((float)0.0f, (boolean)false), 1.0f, 1.0f, 1.0f, alpha);
        matrixStackIn.func_227865_b_();
    }

    public Vector3d getRenderOffset(EntityLogisticsFrame entityIn, float partialTicks) {
        VoxelShape shape = entityIn.getBlockState().func_196954_c((IBlockReader)entityIn.getWorld(), entityIn.getBlockPos());
        double yOff = (shape.func_197758_c(Direction.Axis.Y) - shape.func_197762_b(Direction.Axis.Y)) / 2.0;
        switch (entityIn.getSide()) {
            case DOWN: {
                return new Vector3d(0.0, shape.func_197762_b(Direction.Axis.Y), 0.0);
            }
            case UP: {
                return new Vector3d(0.0, shape.func_197758_c(Direction.Axis.Y) - 1.0, 0.0);
            }
            case NORTH: {
                return new Vector3d(0.0, yOff - 0.5, shape.func_197762_b(Direction.Axis.Z));
            }
            case SOUTH: {
                return new Vector3d(0.0, yOff - 0.5, shape.func_197758_c(Direction.Axis.Z) - 1.0);
            }
            case WEST: {
                return new Vector3d(shape.func_197762_b(Direction.Axis.X), yOff - 0.5, 0.0);
            }
            case EAST: {
                return new Vector3d(shape.func_197758_c(Direction.Axis.X) - 1.0, yOff - 0.5, 0.0);
            }
        }
        return Vector3d.field_186680_a;
    }

    public ResourceLocation getTextureLocation(EntityLogisticsFrame entityLogisticsFrame) {
        return entityLogisticsFrame.getTexture();
    }
}

