/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.area;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.Set;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockReader;

public class AreaRenderer {
    private final Set<BlockPos> showingPositions;
    private final int color;
    private final float size;
    private final boolean disableDepthTest;
    private final boolean drawShapes;
    private final boolean drawFaces;
    private final boolean disableWriteMask;

    private AreaRenderer(Set<BlockPos> area, int color, float size, boolean disableDepthTest, boolean drawShapes, boolean disableWriteMask, boolean drawFaces) {
        this.showingPositions = area;
        this.color = color;
        this.size = size;
        this.disableDepthTest = disableDepthTest;
        this.disableWriteMask = disableWriteMask;
        this.drawShapes = drawShapes;
        this.drawFaces = drawFaces;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        RenderType type;
        if (this.drawFaces) {
            type = ModRenderTypes.getBlockHilightFace(this.disableDepthTest, this.disableWriteMask);
            this.render(matrixStack, buffer.getBuffer(type));
            RenderUtils.finishBuffer(buffer, type);
        }
        type = ModRenderTypes.getBlockHilightLine(this.disableDepthTest, this.disableWriteMask);
        this.render(matrixStack, buffer.getBuffer(type));
        RenderUtils.finishBuffer(buffer, type);
    }

    private void render(MatrixStack matrixStack, IVertexBuilder builder) {
        int[] cols = RenderUtils.decomposeColor(this.color);
        for (BlockPos pos : this.showingPositions) {
            matrixStack.func_227860_a_();
            if (this.drawShapes) {
                matrixStack.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            } else {
                double start = (double)(1.0f - this.size) / 2.0;
                matrixStack.func_227861_a_((double)pos.func_177958_n() + start, (double)pos.func_177956_o() + start, (double)pos.func_177952_p() + start);
            }
            Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
            this.addVertices(builder, posMat, pos, cols);
            matrixStack.func_227865_b_();
        }
    }

    private void addVertices(IVertexBuilder wr, Matrix4f posMat, BlockPos pos, int[] cols) {
        boolean xray;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockState state = world.func_180495_p(pos);
        boolean bl = xray = this.disableDepthTest || this.disableWriteMask;
        if (!xray && !state.func_185904_a().func_76222_j()) {
            return;
        }
        if (this.drawShapes) {
            VoxelShape shape = state.func_177230_c() instanceof BlockPneumaticCraftCamo ? ((BlockPneumaticCraftCamo)state.func_177230_c()).getUncamouflagedShape(state, (IBlockReader)world, pos, ISelectionContext.func_216377_a()) : state.func_215700_a((IBlockReader)world, pos, ISelectionContext.func_216377_a());
            shape.func_197755_b((x1d, y1d, z1d, x2d, y2d, z2d) -> {
                float x1 = (float)x1d;
                float x2 = (float)x2d;
                float y1 = (float)y1d;
                float y2 = (float)y2d;
                float z1 = (float)z1d;
                float z2 = (float)z2d;
                wr.func_227888_a_(posMat, x1, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            });
        } else {
            wr.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, this.size, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, this.size, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, 0.0f, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, 0.0f, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, this.size, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, this.size, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, 0.0f, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, 0.0f, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, this.size, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, this.size, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, this.size, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, this.size, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, 0.0f, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, 0.0f, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, 0.0f, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, 0.0f, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, 0.0f, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, this.size, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, this.size, this.size).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, this.size, this.size, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, this.size, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        }
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private int color = 0x40808080;
        private float size = 0.5f;
        private boolean disableDepthTest = false;
        private boolean drawShapes = false;
        private boolean disableWriteMask = false;
        private boolean drawFaces = true;

        Builder() {
        }

        Builder withColor(int color) {
            this.color = color;
            return this;
        }

        Builder withSize(float size) {
            this.size = size;
            return this;
        }

        Builder disableDepthTest() {
            this.disableDepthTest = true;
            return this;
        }

        Builder disableWriteMask() {
            this.disableWriteMask = true;
            return this;
        }

        Builder xray() {
            this.disableDepthTest = true;
            this.disableWriteMask = true;
            return this;
        }

        Builder drawShapes() {
            this.drawShapes = true;
            return this;
        }

        Builder outlineOnly() {
            this.drawFaces = false;
            return this;
        }

        AreaRenderer build(Set<BlockPos> area) {
            return new AreaRenderer(area, this.color, this.size, this.disableDepthTest, this.drawShapes, this.disableWriteMask, this.drawFaces);
        }

        AreaRenderer build(BlockPos pos) {
            return this.build(Collections.singleton(pos));
        }
    }
}

