/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.gui.widget.ICanRender3d;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.Validate;

public class WidgetVerticalScrollbar
extends Widget
implements ICanRender3d {
    public float currentScroll;
    private int states;
    private boolean listening;
    private boolean dragging;

    public WidgetVerticalScrollbar(int x, int y, int height) {
        super(x, y, 14, height, StringTextComponent.field_240750_d_);
    }

    public WidgetVerticalScrollbar setStates(int states) {
        this.states = states;
        return this;
    }

    public WidgetVerticalScrollbar setCurrentState(int state) {
        Validate.isTrue((state >= 0 && state <= this.states ? 1 : 0) != 0, (String)("State " + state + " out of range! Valid range [1 - " + this.states + "] inclusive"), (Object[])new Object[0]);
        this.currentScroll = (float)state / (float)this.states;
        return this;
    }

    public boolean func_231043_a_(double x, double y, double dir) {
        if (this.field_230693_o_ && this.listening) {
            double wheel = MathHelper.func_151237_a((double)(-dir), (double)-1.0, (double)1.0);
            this.currentScroll = MathHelper.func_76131_a((float)(this.currentScroll + (float)wheel / (float)this.states), (float)0.0f, (float)1.0f);
            return true;
        }
        return false;
    }

    public void func_230982_a_(double x, double y) {
        this.currentScroll = (float)(y - 7.0 - (double)this.field_230691_m_) / (float)(this.field_230689_k_ - 17);
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        this.dragging = true;
    }

    public void func_231000_a__(double x, double y) {
        this.dragging = false;
    }

    protected void func_230983_a_(double x, double y, double dx, double dy) {
        this.dragging = true;
        this.currentScroll = (float)(y - 7.0 - (double)this.field_230691_m_) / (float)(this.field_230689_k_ - 17);
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
    }

    public WidgetVerticalScrollbar setListening(boolean listening) {
        this.listening = listening;
        return this;
    }

    public int getState() {
        float scroll = this.currentScroll;
        return MathHelper.func_76125_a((int)((int)((scroll += 0.5f / (float)this.states) * (float)this.states)), (int)0, (int)this.states);
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        if (this.field_230694_p_) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.WIDGET_VERTICAL_SCROLLBAR);
            WidgetVerticalScrollbar.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)12.0f, (float)0.0f, (int)this.field_230688_j_, (int)1, (int)26, (int)15);
            for (int i = 0; i < this.field_230689_k_ - 2; ++i) {
                WidgetVerticalScrollbar.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)(this.field_230691_m_ + 1 + i), (float)12.0f, (float)1.0f, (int)this.field_230688_j_, (int)1, (int)26, (int)15);
            }
            WidgetVerticalScrollbar.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)(this.field_230691_m_ + this.field_230689_k_ - 1), (float)12.0f, (float)14.0f, (int)this.field_230688_j_, (int)1, (int)26, (int)15);
            if (!this.field_230693_o_) {
                RenderSystem.color4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
            }
            WidgetVerticalScrollbar.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1 + (int)((float)(this.field_230689_k_ - 17) * this.currentScroll)), (float)0.0f, (float)0.0f, (int)12, (int)15, (int)26, (int)15);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void render3d(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        if (this.field_230694_p_) {
            RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(Textures.WIDGET_VERTICAL_SCROLLBAR, true), (posMat, builder) -> {
                this.blit3d((IVertexBuilder)builder, (Matrix4f)posMat, this.field_230690_l_, this.field_230691_m_, 12, 0, this.field_230688_j_, 1, 26, 15);
                for (int i = 0; i < this.field_230689_k_ - 2; ++i) {
                    this.blit3d((IVertexBuilder)builder, (Matrix4f)posMat, this.field_230690_l_, this.field_230691_m_ + 1 + i, 12, 1, this.field_230688_j_, 1, 26, 15);
                }
                this.blit3d((IVertexBuilder)builder, (Matrix4f)posMat, this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_ - 1, 12, 14, this.field_230688_j_, 1, 26, 15);
                this.blit3d((IVertexBuilder)builder, (Matrix4f)posMat, this.field_230690_l_ + 1, this.field_230691_m_ + 1 + (int)((float)(this.field_230689_k_ - 17) * this.currentScroll), 0, 0, 12, 15, 26, 15);
            });
        }
    }

    private void blit3d(IVertexBuilder builder, Matrix4f posMat, int x, int y, int textureX, int textureY, int width, int height, int textureWidth, int textureHeight) {
        float u1 = (float)textureX / (float)textureWidth;
        float u2 = (float)(textureX + width) / (float)textureWidth;
        float v1 = (float)textureY / (float)textureHeight;
        float v2 = (float)(textureY + height) / (float)textureHeight;
        RenderUtils.posF(builder, posMat, x, y + height, 0.0).func_225586_a_(255, 255, 255, 255).func_225583_a_(u1, v2).func_227886_a_(0xF000F0).func_181675_d();
        RenderUtils.posF(builder, posMat, x + width, y + height, 0.0).func_225586_a_(255, 255, 255, 255).func_225583_a_(u2, v2).func_227886_a_(0xF000F0).func_181675_d();
        RenderUtils.posF(builder, posMat, x + width, y, 0.0).func_225586_a_(255, 255, 255, 255).func_225583_a_(u2, v1).func_227886_a_(0xF000F0).func_181675_d();
        RenderUtils.posF(builder, posMat, x, y, 0.0).func_225586_a_(255, 255, 255, 255).func_225583_a_(u1, v1).func_227886_a_(0xF000F0).func_181675_d();
    }
}

