/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.widget.IDrawAfterRender;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;

public class WidgetComboBox
extends WidgetTextField
implements IDrawAfterRender {
    private final ArrayList<String> elements = new ArrayList();
    private final FontRenderer fontRenderer;
    private boolean enabled = true;
    private boolean fixedOptions;
    private boolean shouldSort = true;
    private int selectedIndex = -1;
    private final int baseHeight;
    private final Consumer<WidgetComboBox> pressable;
    private List<String> applicable = null;

    public WidgetComboBox(FontRenderer fontRenderer, int x, int y, int width, int height) {
        this(fontRenderer, x, y, width, height, b -> {});
    }

    public WidgetComboBox(FontRenderer fontRenderer, int x, int y, int width, int height, Consumer<WidgetComboBox> pressable) {
        super(fontRenderer, x, y, width, height);
        this.fontRenderer = fontRenderer;
        this.baseHeight = height;
        this.pressable = pressable;
    }

    public WidgetComboBox setElements(Collection<String> elements) {
        this.elements.clear();
        this.elements.addAll(elements);
        if (this.shouldSort) {
            Collections.sort(this.elements);
        }
        return this;
    }

    public WidgetComboBox setElements(String[] elements) {
        this.elements.clear();
        this.elements.ensureCapacity(elements.length);
        this.elements.addAll(Arrays.asList(elements));
        if (this.shouldSort) {
            Collections.sort(this.elements);
        }
        return this;
    }

    public WidgetComboBox setShouldSort(boolean shouldSort) {
        this.shouldSort = shouldSort;
        return this;
    }

    private List<String> getApplicableElements() {
        this.applicable = this.elements.stream().filter(element -> this.fixedOptions || element.toLowerCase().contains(this.func_146179_b().toLowerCase())).collect(Collectors.toList());
        return this.applicable;
    }

    public void func_146191_b(String textToWrite) {
        super.func_146191_b(textToWrite);
        this.applicable = null;
    }

    @Override
    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        super.func_230431_b_(matrixStack, mouseX, mouseY, partialTick);
        this.fontRenderer.func_238421_b_(matrixStack, this.func_230999_j_() ? "\u25b2" : "\u25bc", (float)(this.field_230690_l_ + this.field_230688_j_ - 7), (float)(this.field_230691_m_ + 1), 0xC0C0C0);
    }

    @Override
    public void renderAfterEverythingElse(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        if (this.enabled && this.field_230693_o_ && this.func_230999_j_()) {
            List<String> applicableElements = this.getApplicableElements();
            int n = applicableElements.size();
            this.fontRenderer.getClass();
            WidgetComboBox.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ - 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 3 + n * 9), (int)-6250336);
            int n2 = applicableElements.size();
            this.fontRenderer.getClass();
            WidgetComboBox.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_ + 2 + n2 * 9), (int)-16777216);
            this.fontRenderer.getClass();
            int hovered = (mouseY - this.field_230691_m_ - this.field_230689_k_) / 9;
            for (int i = 0; i < applicableElements.size(); ++i) {
                String element = applicableElements.get(i);
                String string = this.fontRenderer.func_238412_a_(element, this.func_230998_h_());
                float f = this.field_230690_l_ + 4;
                this.fontRenderer.getClass();
                this.fontRenderer.func_238405_a_(matrixStack, string, f, (float)(this.field_230691_m_ + this.field_230689_k_ + 2 + i * 9), i == hovered ? 16769152 : 0xE0E0E0);
            }
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_146176_q() && this.field_230693_o_) {
            boolean flag;
            int n;
            if (this.func_230999_j_()) {
                int n2 = this.getApplicableElements().size();
                this.fontRenderer.getClass();
                n = n2 * 9;
            } else {
                n = 0;
            }
            int h = this.baseHeight + n;
            boolean bl = flag = mouseX >= (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY >= (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + h);
            if (flag) {
                if (mouseY < (double)(this.field_230691_m_ + this.field_230689_k_)) {
                    this.func_230996_d_(!this.func_230999_j_());
                } else {
                    this.func_230996_d_(false);
                    int n3 = (int)mouseY - this.field_230691_m_ - this.field_230689_k_;
                    this.fontRenderer.getClass();
                    int i = n3 / 9;
                    if (i < this.getApplicableElements().size()) {
                        this.func_146180_a(this.getApplicableElements().get(i));
                        this.selectedIndex = i;
                        this.pressable.accept(this);
                    }
                }
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        List<String> applicableElements;
        if (this.fixedOptions) {
            return false;
        }
        if (this.enabled && this.func_230999_j_() && keyCode == 258 && (applicableElements = this.getApplicableElements()).size() > 0) {
            this.func_146180_a(applicableElements.get(0));
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char key, int keyCode) {
        return !this.fixedOptions && super.func_231042_a_(key, keyCode);
    }

    public void func_146184_c(boolean enabled) {
        super.func_146184_c(enabled);
        this.enabled = enabled;
    }

    public WidgetComboBox setFixedOptions() {
        this.fixedOptions = true;
        this.applicable = null;
        return this;
    }

    public int getSelectedElementIndex() {
        return this.selectedIndex;
    }

    public void selectElement(int index) {
        if (index >= 0 && index < this.elements.size()) {
            this.selectedIndex = index;
            this.func_146180_a(this.elements.get(index));
        }
    }

    public final <T extends Enum<T>> WidgetComboBox initFromEnum(T initialValue, Function<T, String> xlate) {
        List<String> labels = Arrays.stream(initialValue.getClass().getEnumConstants()).filter(val -> initialValue.getClass().isAssignableFrom(val.getClass())).map(val -> val).map(xlate).collect(Collectors.toList());
        this.setShouldSort(false);
        this.setElements(labels);
        this.setFixedOptions();
        this.selectElement(initialValue.ordinal());
        return this;
    }

    public final <T extends Enum<T>> WidgetComboBox initFromEnum(T initialValue) {
        return this.initFromEnum(initialValue, e -> I18n.func_135052_a((String)((ITranslatableEnum)((Object)e)).getTranslationKey(), (Object[])new Object[0]));
    }
}

