/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorColors;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class GuiArmorColors
extends GuiPneumaticScreenBase
implements Slider.ISlider {
    private boolean needSave = false;
    private final int[][] origColors = new int[4][SelectorType.values().length];
    private final int[][] colors = new int[4][SelectorType.values().length];
    private final List<SelectorButton> selectorButtons = new ArrayList<SelectorButton>();
    private final Map<ColorComponent, RGBSlider> rgbSliders = new EnumMap<ColorComponent, RGBSlider>(ColorComponent.class);
    private WidgetButtonExtended saveButton;
    private WidgetLabel scrollLabel;
    private static EquipmentSlotType selectedSlot = EquipmentSlotType.HEAD;
    private static SelectorType selectorType = SelectorType.PRIMARY;

    public GuiArmorColors() {
        super((ITextComponent)new StringTextComponent("Colors"));
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            ItemStack stack = player.func_184582_a(slot);
            int idx = slot.func_188454_b();
            if (!(stack.func_77973_b() instanceof ItemPneumaticArmor)) continue;
            int n = ((ItemPneumaticArmor)stack.func_77973_b()).func_200886_f(stack);
            this.colors[idx][0] = n;
            this.origColors[idx][0] = n;
            int n2 = ((ItemPneumaticArmor)stack.func_77973_b()).getSecondaryColor(stack);
            this.colors[idx][1] = n2;
            this.origColors[idx][1] = n2;
            int n3 = ((ItemPneumaticArmor)stack.func_77973_b()).getEyepieceColor(stack);
            this.colors[idx][2] = n3;
            this.origColors[idx][2] = n3;
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.xSize = this.field_230708_k_;
        this.ySize = this.field_230709_l_;
        this.selectorButtons.clear();
        for (EquipmentSlotType equipmentSlotType : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            for (SelectorType type : SelectorType.values()) {
                this.selectorButtons.add(new SelectorButton(this, equipmentSlotType, type));
            }
        }
        this.selectorButtons.forEach(this::func_230480_a_);
        for (SelectorType selectorType : SelectorType.values()) {
            this.func_230480_a_(new WidgetLabel(87 + selectorType.xOffset, 30, (ITextComponent)new StringTextComponent(selectorType.label), -1).setAlignment(WidgetLabel.Alignment.CENTRE));
        }
        this.rgbSliders.clear();
        for (ColorComponent colorComponent : ColorComponent.values()) {
            this.rgbSliders.put(colorComponent, new RGBSlider(this, colorComponent, 43, 165 + colorComponent.yOffset, 128, 10, this.getCurrentColor() >> colorComponent.bitShift & 0xFF));
        }
        this.rgbSliders.values().forEach(this::func_230480_a_);
        this.scrollLabel = new WidgetLabel(107, 210, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.colors.scrollWheel", new Object[0]), -6250336).setAlignment(WidgetLabel.Alignment.CENTRE);
        this.func_230480_a_(this.scrollLabel);
        this.scrollLabel.field_230694_p_ = false;
        this.func_230480_a_(new WidgetButtonExtended(85, 130, 40, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.copy", new Object[0]), b -> this.copyColorsToOtherPieces()).setTooltipKey("pneumaticcraft.armor.gui.misc.colors.copyTooltip", new Object[0]));
        this.saveButton = this.func_230480_a_(new WidgetButtonExtended(43, this.field_230709_l_ - 30, 40, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.save", new Object[0]), b -> this.saveChanges()));
        this.func_230480_a_(new WidgetButtonExtended(88, this.field_230709_l_ - 30, 40, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.reset", new Object[0]), b -> this.resetColors(Screen.func_231173_s_())).setTooltipKey("pneumaticcraft.armor.gui.misc.colors.resetTooltip", new Object[0]));
        this.func_230480_a_(new WidgetButtonExtended(133, this.field_230709_l_ - 30, 40, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.cancel", new Object[0]), b -> this.func_231175_as__()));
        TranslationTextComponent translationTextComponent = PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.colors.showEnchantGlint", new Object[0]);
        int n = this.field_230708_k_ - this.field_230712_o_.func_238414_a_((ITextProperties)translationTextComponent) - 40;
        this.field_230712_o_.getClass();
        this.func_230480_a_(new WidgetCheckBox(n, this.field_230709_l_ - 9 - 10, -1, (ITextComponent)translationTextComponent, b -> ConfigHelper.setShowEnchantGlint(b.checked)).setChecked((Boolean)ConfigHelper.client().armor.showEnchantGlint.get()));
    }

    private void setCurrentColor(int newCol) {
        this.colors[GuiArmorColors.selectedSlot.func_188454_b()][GuiArmorColors.selectorType.ordinal()] = newCol;
    }

    private int getCurrentColor() {
        return this.colors[selectedSlot.func_188454_b()][selectorType.ordinal()];
    }

    private void saveChanges() {
        Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.HUD_INIT_COMPLETE.get(), 1.0f, 1.0f);
        NetworkHandler.sendToServer(new PacketUpdateArmorColors());
        this.needSave = false;
    }

    private void copyColorsToOtherPieces() {
        for (int i = 0; i < this.colors.length; ++i) {
            if (i != selectedSlot.func_188454_b()) {
                this.colors[i][GuiArmorColors.selectorType.ordinal()] = this.getCurrentColor();
            }
            this.updateClientSideArmor(EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)i));
        }
    }

    private void resetColors(boolean factorySettings) {
        for (int i = 0; i < this.colors.length; ++i) {
            for (SelectorType type : SelectorType.values()) {
                this.colors[i][type.ordinal()] = factorySettings ? type.defaultColor : this.origColors[i][type.ordinal()];
            }
            this.updateClientSideArmor(EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)i));
        }
        this.updateSliders();
        this.needSave = factorySettings;
    }

    private void updateClientSideArmor(EquipmentSlotType slot) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184582_a(slot);
        if (stack.func_77973_b() instanceof ItemPneumaticArmor) {
            ((ItemPneumaticArmor)stack.func_77973_b()).func_200885_a(stack, this.colors[slot.func_188454_b()][SelectorType.PRIMARY.ordinal()]);
            ((ItemPneumaticArmor)stack.func_77973_b()).setSecondaryColor(stack, this.colors[slot.func_188454_b()][SelectorType.SECONDARY.ordinal()]);
            if (slot == EquipmentSlotType.HEAD) {
                ((ItemPneumaticArmor)stack.func_77973_b()).setEyepieceColor(stack, this.colors[slot.func_188454_b()][SelectorType.EYEPIECE.ordinal()]);
            }
        }
        for (EquipmentSlotType slot2 : EquipmentSlotType.values()) {
            HUDHandler.getInstance().updateOverlayColors(slot2);
        }
        this.selectorButtons.get((3 - slot.func_188454_b()) * SelectorType.values().length).setRenderStacks(stack);
        this.needSave = true;
    }

    private void updateSliders() {
        for (ColorComponent color : ColorComponent.values()) {
            this.updateSlider(this.rgbSliders.get((Object)color), (this.getCurrentColor() & color.mask) >> color.bitShift);
        }
    }

    private void updateSlider(Slider s, int val) {
        s.setValue((double)val);
        s.func_238482_a_((ITextComponent)s.dispString.func_230532_e_().func_240702_b_(Integer.toString(val)).func_230529_a_(s.suffix));
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.selectorButtons.forEach(b -> {
            b.field_230693_o_ = selectorType != ((SelectorButton)b).selectorType || selectedSlot != ((SelectorButton)b).slot;
        });
        this.saveButton.field_230693_o_ = this.needSave;
        this.scrollLabel.field_230694_p_ = this.rgbSliders.values().stream().anyMatch(Widget::func_230449_g_);
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, x, y, partialTicks);
        double scaleFactor = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        int scale = (int)((double)Minecraft.func_71410_x().func_228018_at_().func_198083_n() / (scaleFactor * 3.0));
        InventoryScreen.func_228187_a_((int)(this.field_230708_k_ * 2 / 3), (int)(this.field_230709_l_ * 3 / 4), (int)scale, (float)((float)(this.field_230708_k_ * 2) / 3.0f - (float)x), (float)((float)this.field_230709_l_ / 4.0f - (float)y), (LivingEntity)Minecraft.func_71410_x().field_71439_g);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        for (RGBSlider slider : this.rgbSliders.values()) {
            if (!slider.func_230449_g_()) continue;
            double val = Math.signum(delta);
            if (Screen.func_231173_s_()) {
                val *= 10.0;
            }
            int newVal = MathHelper.func_76125_a((int)((int)((double)slider.getValueInt() + val)), (int)0, (int)255);
            if (slider.getValueInt() != newVal) {
                this.updateSlider(slider, newVal);
                this.onChangeSliderValue(slider);
            }
            return true;
        }
        return false;
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a((Screen)GuiArmorMainScreen.getInstance());
    }

    public void func_231164_f_() {
        if (this.needSave) {
            this.resetColors(false);
        }
        super.func_231164_f_();
    }

    public void onChangeSliderValue(Slider slider) {
        if (slider instanceof RGBSlider) {
            ColorComponent component = ((RGBSlider)slider).getColor();
            this.setCurrentColor(this.getCurrentColor() & ~component.mask | slider.getValueInt() << component.bitShift);
            this.updateClientSideArmor(selectedSlot);
        }
    }

    private static class SelectorButton
    extends WidgetButtonExtended {
        private final GuiArmorColors gui;
        private final EquipmentSlotType slot;
        private final SelectorType selectorType;

        public SelectorButton(GuiArmorColors gui, EquipmentSlotType slot, SelectorType selectorType) {
            super(78 + selectorType.xOffset, 41 + (3 - slot.func_188454_b()) * 22, 18, 18, "", b -> {
                selectedSlot = slot;
                selectorType = selectorType;
                gui.updateSliders();
            });
            this.gui = gui;
            this.slot = slot;
            this.selectorType = selectorType;
            boolean bl = this.field_230694_p_ = selectorType.showButton(slot) && ItemPneumaticArmor.isPneumaticArmorPiece(ClientUtils.getClientPlayer(), slot);
            if (selectorType == SelectorType.PRIMARY) {
                this.setRenderStacks(Minecraft.func_71410_x().field_71439_g.func_184582_a(slot));
                this.setIconPosition(WidgetButtonExtended.IconPosition.LEFT);
            }
        }

        @Override
        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
            SelectorButton.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 3), (int)(this.field_230691_m_ + 3), (int)(this.field_230690_l_ + 14), (int)(this.field_230691_m_ + 14), (int)this.gui.colors[this.slot.func_188454_b()][this.selectorType.ordinal()]);
            this.func_238465_a_(matrixStack, this.field_230690_l_ + 4, this.field_230690_l_ + 14, this.field_230691_m_ + 14, -14671840);
            this.func_238473_b_(matrixStack, this.field_230690_l_ + 14, this.field_230691_m_ + 3, this.field_230691_m_ + 14, -14671840);
        }
    }

    public static enum SelectorType {
        PRIMARY(0, "1", -6908266),
        SECONDARY(22, "2", -4144960),
        EYEPIECE(44, "E", -16733696);

        private final int xOffset;
        private final String label;
        private final int defaultColor;

        private SelectorType(int xOffset, String label, int defaultColor) {
            this.xOffset = xOffset;
            this.label = label;
            this.defaultColor = defaultColor;
        }

        boolean showButton(EquipmentSlotType slot) {
            return slot == EquipmentSlotType.HEAD || this != EYEPIECE;
        }

        public int getDefaultColor() {
            return this.defaultColor;
        }
    }

    private static enum ColorComponent {
        RED(16, TextFormatting.RED + "R: ", 0),
        GREEN(8, TextFormatting.GREEN + "G: ", 15),
        BLUE(0, TextFormatting.BLUE + "B: ", 30);

        private final int mask;
        private final int bitShift;
        private final String prefix;
        private final int yOffset;

        private ColorComponent(int bitShift, String prefix, int yOffset) {
            this.mask = 255 << bitShift;
            this.bitShift = bitShift;
            this.prefix = prefix;
            this.yOffset = yOffset;
        }
    }

    private static class RGBSlider
    extends Slider {
        private final ColorComponent color;

        public RGBSlider(GuiArmorColors gui, ColorComponent color, int xPos, int yPos, int width, int height, double currentVal) {
            super(xPos, yPos, width, height, (ITextComponent)new StringTextComponent(color.prefix), StringTextComponent.field_240750_d_, 0.0, 255.0, currentVal, false, true, null, (Slider.ISlider)gui);
            this.color = color;
        }

        public ColorComponent getColor() {
            return this.color;
        }
    }
}

