/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.inventory.ContainerVacuumPump;
import me.desht.pneumaticcraft.common.tileentity.TileEntityVacuumPump;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiVacuumPump
extends GuiPneumaticContainerBase<ContainerVacuumPump, TileEntityVacuumPump> {
    public GuiVacuumPump(ContainerVacuumPump container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_VACUUM_PUMP;
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        super.func_230451_b_(matrixStack, x, y);
        this.field_230712_o_.func_238421_b_(matrixStack, "+", 32.0f, 47.0f, -16733696);
        this.field_230712_o_.func_238421_b_(matrixStack, "-", 138.0f, 47.0f, -65536);
        float pressure = ((IAirHandlerMachine)((TileEntityVacuumPump)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((TileEntityVacuumPump)this.te).getInputSide()).orElseThrow(RuntimeException::new)).getPressure();
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, this.field_230712_o_, -1.0f, 7.0f, 5.0f, 2.0f, pressure, this.field_146999_f / 5, this.field_147000_g / 5 + 4);
        float vacPressure = ((IAirHandlerMachine)((TileEntityVacuumPump)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((TileEntityVacuumPump)this.te).getVacuumSide()).orElseThrow(RuntimeException::new)).getPressure();
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, this.field_230712_o_, -1.0f, 7.0f, 5.0f, -1.0f, vacPressure, this.field_146999_f * 4 / 5, this.field_147000_g / 5 + 4);
    }

    @Override
    protected PointXY getGaugeLocation() {
        return null;
    }

    @Override
    protected void addPressureStatInfo(List<ITextComponent> pressureStatText) {
        IAirHandlerMachine inputAirHandler = (IAirHandlerMachine)((TileEntityVacuumPump)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((TileEntityVacuumPump)this.te).getInputSide()).orElseThrow(RuntimeException::new);
        IAirHandlerMachine vacuumHandler = (IAirHandlerMachine)((TileEntityVacuumPump)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((TileEntityVacuumPump)this.te).getVacuumSide()).orElseThrow(RuntimeException::new);
        pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.inputPressure", PneumaticCraftUtils.roundNumberTo(inputAirHandler.getPressure(), 2)));
        pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.vacuumPressure", PneumaticCraftUtils.roundNumberTo(vacuumHandler.getPressure(), 2)));
        pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.inputAir", String.format("%,d", inputAirHandler.getAir())));
        pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.vacuumPump.vacuumAir", String.format("%,d", vacuumHandler.getAir())));
        int volume = inputAirHandler.getVolume();
        int upgrades = ((TileEntityVacuumPump)this.te).getUpgrades(EnumUpgrade.VOLUME);
        pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.baseVolume", String.format("%,d", 2000)));
        if (volume > inputAirHandler.getBaseVolume()) {
            pressureStatText.add((ITextComponent)new StringTextComponent("\u25b6 " + upgrades + " x ").func_230529_a_(EnumUpgrade.VOLUME.getItemStack().func_200301_q()));
            pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.effectiveVolume", String.format("%,d", volume)));
        }
        if (((TileEntityVacuumPump)this.te).turning) {
            int suction = Math.round(4.0f * ((TileEntityVacuumPump)this.te).getSpeedMultiplierFromUpgrades());
            pressureStatText.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.suction", String.format("%,d", suction)));
        }
    }

    @Override
    protected void addProblems(List<ITextComponent> textList) {
        super.addProblems(textList);
        float pressure = ((Float)((TileEntityVacuumPump)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((TileEntityVacuumPump)this.te).getInputSide()).map(IAirHandler::getPressure).orElseThrow(RuntimeException::new)).floatValue();
        if (pressure < 2.0f) {
            textList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.notEnoughPressure", new Object[0]));
            textList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.applyPressure", Float.valueOf(2.0f)).func_240699_a_(TextFormatting.BLACK));
        }
    }
}

