/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.RenderHackSimulation;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.inventory.ContainerSecurityStationHacking;
import me.desht.pneumaticcraft.common.item.ItemNetworkComponent;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiSecurityStationHacking
extends GuiPneumaticContainerBase<ContainerSecurityStationHacking, TileEntitySecurityStation> {
    private WidgetAnimatedStat statusStat;
    private RenderHackSimulation hackRenderer;
    private HackSimulation bgSimulation;
    private int stopWorms = 0;
    private int nukeViruses = 0;
    private final ItemStack stopWorm = new ItemStack((IItemProvider)ModItems.STOP_WORM.get());
    private final ItemStack nukeVirus = new ItemStack((IItemProvider)ModItems.NUKE_VIRUS.get());
    private WidgetButtonExtended nukeVirusButton;
    private WidgetButtonExtended stopWormButton;

    public GuiSecurityStationHacking(ContainerSecurityStationHacking container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 238;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.statusStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.status", new Object[0]), new ItemStack((IItemProvider)ModBlocks.SECURITY_STATION.get()), -22016, false);
        this.addInfoTab(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.security_station.hacking", new Object[0]));
        this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate(((Item)ModItems.NUKE_VIRUS.get()).func_77658_a(), new Object[0]), new ItemStack((IItemProvider)ModItems.NUKE_VIRUS.get()), -15152664, false).setText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.security_station.nukeVirus", new Object[0]));
        this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate(((Item)ModItems.STOP_WORM.get()).func_77658_a(), new Object[0]), new ItemStack((IItemProvider)ModItems.STOP_WORM.get()), -4115918, false).setText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.security_station.stopWorm", new Object[0]));
        this.nukeVirusButton = new WidgetButtonExtended(this.field_147003_i + 152, this.field_147009_r + 95, 18, 18, "").setRenderStacks(this.nukeVirus);
        this.func_230480_a_(this.nukeVirusButton);
        this.stopWormButton = new WidgetButtonExtended(this.field_147003_i + 152, this.field_147009_r + 143, 18, 18, "", b -> {
            if (!((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI).isStopWormed()) {
                PneumaticCraftUtils.consumeInventoryItem(ClientUtils.getClientPlayer().field_71071_by, (Item)ModItems.STOP_WORM.get());
                ClientUtils.getClientPlayer().func_184185_a(SoundEvents.field_187872_fl, 1.0f, 1.0f);
            }
        });
        this.func_230480_a_(this.stopWormButton).withTag("stop_worm").setRenderStacks(this.stopWorm);
        this.initConnectionRendering();
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    private void initConnectionRendering() {
        this.hackRenderer = new RenderHackSimulation(this.field_147003_i + 16, this.field_147009_r + 30, 31);
        this.bgSimulation = HackSimulation.dummySimulation();
        this.bgSimulation.wakeUp();
        for (int i = 0; i < ((TileEntitySecurityStation)this.te).getPrimaryInventory().getSlots(); ++i) {
            this.bgSimulation.addNode(i, ((TileEntitySecurityStation)this.te).getPrimaryInventory().getStackInSlot(i));
        }
    }

    public static void addExtraHackInfoStatic(List<ITextComponent> curInfo) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiSecurityStationHacking) {
            ((GuiSecurityStationHacking)Minecraft.func_71410_x().field_71462_r).addExtraHackInfo(curInfo);
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_HACKING;
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    protected boolean shouldAddRedstoneTab() {
        return false;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return null;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        super.func_230451_b_(matrixStack, x, y);
        if (((TileEntitySecurityStation)this.te).getSimulationController() != null) {
            HackSimulation aiSim = ((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
            HackSimulation playerSim = ((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
            if (aiSim.isAwake()) {
                GuiSecurityStationHacking.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.aiTracing", new Object[0]).func_240699_a_(TextFormatting.RED), (int)(this.field_146999_f / 2), (int)7, (int)0xFFFFFF);
            } else {
                GuiSecurityStationHacking.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.detectionChance", ((TileEntitySecurityStation)this.te).getDetectionChance()).func_240699_a_(TextFormatting.GOLD), (int)(this.field_146999_f / 2), (int)7, (int)0xFFFFFF);
            }
            if (aiSim.isHackComplete()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackFailed.1", new Object[0]).func_240699_a_(TextFormatting.RED));
                if (!((TileEntitySecurityStation)this.te).getSimulationController().isJustTesting()) {
                    builder.add((Object)StringTextComponent.field_240750_d_);
                    builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackFailed.2", new Object[0]).func_240699_a_(TextFormatting.RED));
                }
                GuiUtils.showPopupHelpScreen(matrixStack, (Screen)this, this.field_230712_o_, (List<ITextComponent>)builder.build());
            } else if (playerSim.isHackComplete()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackSucceeded.1", new Object[0]).func_240699_a_(TextFormatting.GREEN));
                if (!((TileEntitySecurityStation)this.te).getSimulationController().isJustTesting()) {
                    builder.add((Object)StringTextComponent.field_240750_d_);
                    builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackSucceeded.2", new Object[0]).func_240699_a_(TextFormatting.GREEN));
                }
                GuiUtils.showPopupHelpScreen(matrixStack, (Screen)this, this.field_230712_o_, (List<ITextComponent>)builder.build());
            }
        }
        this.renderConsumables(matrixStack);
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        super.func_230450_a_(matrixStack, partialTicks, x, y);
        this.hackRenderer.render(matrixStack, this.bgSimulation, -14540033);
        if (((TileEntitySecurityStation)this.te).getSimulationController() != null) {
            HackSimulation aiSim = ((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
            if (!aiSim.isStopWormed() || (((TileEntitySecurityStation)this.te).func_145831_w().func_82737_E() & 0xFL) < 8L) {
                this.hackRenderer.render(matrixStack, ((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI), -65536);
            }
            this.hackRenderer.render(matrixStack, ((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER), -16711936);
        }
    }

    private void renderConsumables(MatrixStack matrixStack) {
        this.field_230712_o_.func_238421_b_(matrixStack, PneumaticCraftUtils.convertAmountToString(this.nukeViruses), 158.0f, 112.0f, this.nukeViruses == 0 ? -40864 : -1);
        this.field_230712_o_.func_238421_b_(matrixStack, PneumaticCraftUtils.convertAmountToString(this.stopWorms), 158.0f, 160.0f, this.stopWorms == 0 ? -40864 : -1);
    }

    @Override
    public void func_231023_e_() {
        HackSimulation aiSim;
        super.func_231023_e_();
        this.stopWorms = 0;
        this.nukeViruses = 0;
        for (ItemStack stack : this.field_213127_e.field_70462_a) {
            if (stack.func_77973_b() == ModItems.STOP_WORM.get()) {
                this.stopWorms += stack.func_190916_E();
            }
            if (stack.func_77973_b() != ModItems.NUKE_VIRUS.get()) continue;
            this.nukeViruses += stack.func_190916_E();
        }
        this.bgSimulation.tick();
        this.statusStat.setText(this.getStatusText());
        HackSimulation playerSim = ((TileEntitySecurityStation)this.te).getSimulationController() == null ? null : ((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        HackSimulation hackSimulation = aiSim = ((TileEntitySecurityStation)this.te).getSimulationController() == null ? null : ((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
        if (aiSim != null && aiSim.isAwake()) {
            this.stopWormButton.field_230693_o_ = this.stopWorms > 0;
            this.stopWormButton.setTooltipText((ITextComponent)(this.stopWorms > 0 ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.stopWorm", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.stopWorm.none", new Object[0]).func_240699_a_(TextFormatting.GOLD)));
        } else {
            this.stopWormButton.field_230693_o_ = false;
            this.stopWormButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.stopWorm.notTracing", new Object[0]).func_240699_a_(TextFormatting.GOLD));
        }
        if (playerSim != null) {
            boolean bl = this.nukeVirusButton.field_230693_o_ = this.hasNukeViruses() && playerSim.isNukeVirusReady();
            if (playerSim.isNukeVirusReady()) {
                this.nukeVirusButton.setTooltipText((ITextComponent)(this.hasNukeViruses() ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.nukeVirus", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.nukeVirus.none", new Object[0]).func_240699_a_(TextFormatting.GOLD)));
            } else {
                this.nukeVirusButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.nukeVirus.coolDown", new Object[0]).func_240699_a_(TextFormatting.GOLD));
            }
        }
    }

    private List<ITextComponent> getStatusText() {
        ArrayList<ITextComponent> text = new ArrayList<ITextComponent>();
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityLevel", new Object[0]).func_240699_a_(TextFormatting.WHITE));
        text.add((ITextComponent)new StringTextComponent("L" + ((TileEntitySecurityStation)this.te).getSecurityLevel()).func_240699_a_(TextFormatting.BLACK));
        text.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityRange", new Object[0]).func_240699_a_(TextFormatting.WHITE));
        text.add((ITextComponent)new StringTextComponent(((TileEntitySecurityStation)this.te).getRange() * 2 + 1 + "m\u00b2").func_240699_a_(TextFormatting.BLACK));
        return text;
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn != null && slotIn.func_75216_d() && ((TileEntitySecurityStation)this.te).getSimulationController() != null) {
            switch (mouseButton) {
                case 0: {
                    this.tryHackSlot(slotId);
                    break;
                }
                case 1: {
                    this.tryFortifySlot(slotId);
                    break;
                }
                case 2: {
                    this.tryNukeVirus(slotId);
                }
            }
        } else {
            super.func_184098_a(slotIn, slotId, mouseButton, type);
        }
    }

    private void tryFortifySlot(int slotId) {
        HackSimulation playerSim = ((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        HackSimulation.Node node = playerSim.getNodeAt(slotId);
        if (node.isHacked() && !node.isFortified() && node.getFortification() == 0) {
            playerSim.fortify(slotId);
            NetworkHandler.sendToServer(new PacketGuiButton("fortify:" + slotId));
        }
    }

    private void tryHackSlot(int slotId) {
        HackSimulation playerSim = ((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        HackSimulation.Node node = playerSim.getNodeAt(slotId);
        if (!node.isHacked() && playerSim.getHackedNeighbour(slotId) >= 0) {
            playerSim.startHack(slotId);
            NetworkHandler.sendToServer(new PacketGuiButton("hack:" + slotId));
        }
    }

    private void tryNukeVirus(int slotId) {
        HackSimulation playerSim;
        HackSimulation.Node node;
        if (this.hasNukeViruses() && ((TileEntitySecurityStation)this.te).getSimulationController() != null && !(node = (playerSim = ((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER)).getNodeAt(slotId)).isHacked() && playerSim.getHackedNeighbour(slotId) >= 0 && playerSim.initiateNukeVirus(slotId)) {
            NetworkHandler.sendToServer(new PacketGuiButton("nuke:" + slotId));
            PneumaticCraftUtils.consumeInventoryItem(this.field_230706_i_.field_71439_g.field_71071_by, (Item)ModItems.NUKE_VIRUS.get());
        }
    }

    public void addExtraHackInfo(List<ITextComponent> toolTip) {
        HackSimulation playerSim;
        HackSimulation.Node node;
        if (this.field_147006_u != null && ((TileEntitySecurityStation)this.te).getSimulationController() != null && (node = (playerSim = ((TileEntitySecurityStation)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER)).getNodeAt(this.field_147006_u.field_75222_d)) != null) {
            if (node.isHacked()) {
                if (node.getFortification() == 0) {
                    toolTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.rightClickFortify", new Object[0]).func_240699_a_(TextFormatting.DARK_AQUA));
                } else if (node.getFortificationProgress() < 1.0f) {
                    toolTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.fortifyProgress", (int)(node.getFortificationProgress() * 100.0f)).func_240699_a_(TextFormatting.DARK_AQUA));
                } else {
                    toolTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.fortified", new Object[0]).func_240699_a_(TextFormatting.AQUA));
                }
            } else if (playerSim.getHackedNeighbour(this.field_147006_u.field_75222_d) >= 0) {
                if (node.getHackProgress() == 0.0f) {
                    toolTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.leftClickHack", new Object[0]).func_240699_a_(TextFormatting.GREEN));
                } else {
                    toolTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.hackProgress", (int)(node.getHackProgress() * 100.0f)).func_240699_a_(TextFormatting.GREEN));
                }
                if (this.nukeViruses > 0 && playerSim.isNukeVirusReady() && node.getType() == ItemNetworkComponent.NetworkComponentType.NETWORK_NODE) {
                    toolTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.middleClickNuke", new Object[0]).func_240699_a_(TextFormatting.YELLOW));
                }
            }
        }
    }

    boolean hasNukeViruses() {
        return this.nukeViruses > 0;
    }
}

