/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.semiblock;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public interface ISemiBlock
extends ICapabilityProvider {
    public ResourceLocation getSemiblockId();

    public ITextComponent getDisplayName();

    public World getWorld();

    public BlockPos getBlockPos();

    public TileEntity getCachedTileEntity();

    public CompoundNBT serializeNBT(CompoundNBT var1);

    public void tick();

    public boolean isValid();

    public NonNullList<ItemStack> getDrops();

    public boolean canPlace(Direction var1);

    default public void onPlaced(PlayerEntity player, ItemStack stack, Direction facing) {
    }

    default public boolean onRightClickWithConfigurator(PlayerEntity player, Direction side) {
        return false;
    }

    public boolean canCoexist(ISemiBlock var1);

    public int getTrackingId();

    public void removeSemiblock(PlayerEntity var1);

    default public void addTooltip(List<ITextComponent> curInfo, PlayerEntity player, CompoundNBT tag, boolean extended) {
    }

    public void writeToBuf(PacketBuffer var1);

    public void readFromBuf(PacketBuffer var1);

    default public int getColor() {
        return -8355712;
    }

    public static ISemiBlock byTrackingId(World world, int id) {
        Entity e = world.func_73045_a(id);
        return e instanceof ISemiBlock ? (ISemiBlock)e : null;
    }
}

