/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.ingredient;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import net.minecraft.fluid.Fluid;

public class CompoundFluidIngredient
extends FluidIngredient {
    private final Stream<FluidIngredient> ingredients;
    private List<Fluid> fluids;
    private int dynamicAmount;

    CompoundFluidIngredient(Stream<FluidIngredient> ingredients) {
        super(null, 0, null, null, null, false);
        this.ingredients = ingredients;
    }

    @Override
    protected Collection<Fluid> getFluidList() {
        if (this.fluids == null) {
            Set f = this.ingredients.map(FluidIngredient::getFluidList).collect(HashSet::new, Set::addAll, Set::addAll);
            this.fluids = ImmutableList.copyOf((Collection)f);
            this.dynamicAmount = this.ingredients.map(FluidIngredient::getAmount).max(Integer::compare).orElse(0);
        }
        return this.fluids;
    }

    @Override
    public int getAmount() {
        return this.dynamicAmount;
    }
}

