/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ShapedRecipeNoMirror
extends ShapedRecipe {
    private final NonNullList<Ingredient> recipeItemsIn;
    public static final Serializer SERIALIZER = new Serializer();

    public ShapedRecipeNoMirror(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.recipeItemsIn = recipeItemsIn;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        for (int i = 0; i <= inv.func_174922_i() - this.getRecipeWidth(); ++i) {
            for (int j = 0; j <= inv.func_174923_h() - this.getRecipeHeight(); ++j) {
                if (!this.checkMatch(inv, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingInventory craftingInventory, int width, int height) {
        for (int i = 0; i < craftingInventory.func_174922_i(); ++i) {
            for (int j = 0; j < craftingInventory.func_174923_h(); ++j) {
                int k = i - width;
                int l = j - height;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.getRecipeWidth() && l < this.getRecipeHeight()) {
                    ingredient = (Ingredient)this.recipeItemsIn.get(k + l * this.getRecipeWidth());
                }
                if (ingredient.test(craftingInventory.func_70301_a(i + j * craftingInventory.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        public ShapedRecipe func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe r = super.func_199425_a_(recipeId, json);
            return new ShapedRecipeNoMirror(r.func_199560_c(), r.func_193358_e(), r.getRecipeWidth(), r.getRecipeHeight(), (NonNullList<Ingredient>)r.func_192400_c(), r.func_77571_b());
        }

        @Nullable
        public ShapedRecipe func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapedRecipe r = super.func_199426_a_(recipeId, buffer);
            return new ShapedRecipeNoMirror(r.func_199560_c(), r.func_193358_e(), r.getRecipeWidth(), r.getRecipeHeight(), (NonNullList<Ingredient>)r.func_192400_c(), r.func_77571_b());
        }

        public void func_199427_a_(PacketBuffer buffer, ShapedRecipe recipe) {
            super.func_199427_a_(buffer, recipe);
        }
    }
}

