/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class TileEntityPlatformRise
extends TileEntityPlatformBase {
    private boolean linkedToRamp = false;
    private boolean linkedToFloor = false;
    private boolean isRail = false;

    public TileEntityPlatformRise() {
        super(Values.tilePlatformRise);
    }

    @Override
    protected void buildNBT(CompoundNBT nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74757_a("linkedToRamp", this.linkedToRamp);
        nbtTag.func_74757_a("linkedToFloor", this.linkedToFloor);
        nbtTag.func_74757_a("isRail", this.isRail);
    }

    @Override
    protected void processNBT(CompoundNBT nbtTag) {
        super.processNBT(nbtTag);
        this.linkedToRamp = nbtTag.func_74767_n("linkedToRamp");
        this.linkedToFloor = nbtTag.func_74767_n("linkedToFloor");
        this.isRail = nbtTag.func_74767_n("isRail");
    }

    @Override
    public void setTextureInfo(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlockPlatform) {
            this.setFrameTextureBlock(ItemBlockPlatform.getFrameTextureStack(stack));
            this.setCoverTextureBlock(ItemBlockPlatform.getCoverTextureStack(stack));
            this.isRail = ((ItemBlockPlatform)stack.func_77973_b()).getPlatformType() == EnumPlatformType.RAIL;
        }
    }

    public void setLinkedToRamp(boolean linkToRamp) {
        this.linkedToRamp = linkToRamp;
    }

    public boolean isLinkedToRamp() {
        return this.linkedToRamp;
    }

    public void setLinkedToFloor(boolean linkedToFloor) {
        this.linkedToFloor = linkedToFloor;
    }

    public boolean isLinkedToFloor() {
        return this.linkedToFloor;
    }

    public boolean isLinked() {
        return this.isLinkedToFloor() || this.isLinkedToRamp();
    }

    public boolean isRail() {
        return this.isRail;
    }
}

