/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import shetiphian.core.common.Function;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class TileEntityPlatformFrame
extends TileEntityPlatformBase {
    private EnumTorchType torch = EnumTorchType.NONE;

    public TileEntityPlatformFrame() {
        super(Values.tilePlatformFrame);
    }

    @Override
    protected void buildNBT(CompoundNBT nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74774_a("torch", (byte)this.torch.ordinal());
    }

    @Override
    protected void processNBT(CompoundNBT nbtTag) {
        super.processNBT(nbtTag);
        this.torch = EnumTorchType.byIndex(nbtTag.func_74771_c("torch"));
    }

    protected void processNBT_SyncOnly(CompoundNBT nbtTag) {
        super.processNBT_SyncOnly(nbtTag);
        Function.updateLighting((TileEntity)this);
    }

    public EnumTorchType getTorch() {
        return this.torch;
    }

    public boolean setTorch(EnumTorchType torch) {
        if (torch != null && torch != EnumTorchType.NONE) {
            this.torch = torch;
            return true;
        }
        return false;
    }

    public void removeTorch() {
        switch (this.torch) {
            case GLOWSTONE: {
                this.torch = EnumTorchType.LIGHT;
                return;
            }
            case LAMP_OFF: {
                this.torch = EnumTorchType.REDSTONE_ON;
                return;
            }
            case LAMP_ON: {
                this.torch = EnumTorchType.REDSTONE_OFF;
                return;
            }
        }
        this.torch = EnumTorchType.NONE;
    }

    @Override
    public void addExtraDrops(List<ItemStack> drops) {
        super.addExtraDrops(drops);
        if (this.torch != null && this.torch != EnumTorchType.NONE) {
            drops.add(this.torch.getItemStack());
            if (this.torch.isUpgrade()) {
                drops.add(this.torch.getBaseItemStack());
            }
        }
    }
}

