/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.BooleanSupplier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import org.apache.commons.lang3.tuple.Pair;
import shadows.placebo.Placebo;

@Mod.EventBusSubscriber(modid="placebo", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlaceboTaskQueue {
    private static final Queue<Pair<String, BooleanSupplier>> TASKS = new ArrayDeque<Pair<String, BooleanSupplier>>();

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            Iterator it = TASKS.iterator();
            Pair current = null;
            while (it.hasNext()) {
                current = (Pair)it.next();
                try {
                    if (!((BooleanSupplier)current.getRight()).getAsBoolean()) continue;
                    it.remove();
                }
                catch (Exception ex) {
                    Placebo.LOGGER.error("An exception occurred while running a ticking task with ID {}.  It will be terminated.", current.getLeft());
                    it.remove();
                    ex.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void stopped(FMLServerStoppedEvent e) {
        TASKS.clear();
    }

    @SubscribeEvent
    public static void started(FMLServerStartedEvent e) {
        TASKS.clear();
    }

    public static void submitTask(String id, BooleanSupplier task) {
        TASKS.add((Pair<String, BooleanSupplier>)Pair.of((Object)id, (Object)task));
    }
}

