/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.OnDatapackSyncEvent;
import org.apache.logging.log4j.Logger;
import shadows.placebo.Placebo;
import shadows.placebo.json.SerializerBuilder;
import shadows.placebo.net.ReloadListenerPacket;
import shadows.placebo.util.NetworkUtils;

public abstract class PlaceboJsonReloadListener<V extends TypeKeyed<V>>
extends JsonReloadListener {
    private static final Map<String, PlaceboJsonReloadListener<?>> SYNC_REGISTRY = new HashMap();
    public static final ResourceLocation DEFAULT = new ResourceLocation("default");
    protected final Logger logger;
    protected final String path;
    protected final boolean synced;
    protected final boolean subtypes;
    protected final BiMap<ResourceLocation, SerializerBuilder.Serializer> serializers = HashBiMap.create();
    protected Map<ResourceLocation, V> registry = ImmutableMap.of();
    private final Map<ResourceLocation, V> staged = new HashMap<ResourceLocation, V>();

    public PlaceboJsonReloadListener(Logger logger, String path, boolean synced, boolean subtypes) {
        super(new GsonBuilder().setLenient().create(), path);
        this.logger = logger;
        this.path = path;
        this.synced = synced;
        this.subtypes = subtypes;
        this.registerBuiltinSerializers();
        if (this.serializers.isEmpty()) {
            throw new RuntimeException("Attempted to create a json reload listener for " + path + " with no top-level serializers!");
        }
        if (synced) {
            if (SYNC_REGISTRY.containsKey(path)) {
                throw new RuntimeException("Attempted to create a synced json reload listener for " + path + " but one already exists!");
            }
            SYNC_REGISTRY.put(path, this);
            MinecraftForge.EVENT_BUS.addListener(this::sync);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager pResourceManager, IProfiler pProfiler) {
        this.beginReload();
        objects.forEach((key, ele) -> {
            try {
                if (PlaceboJsonReloadListener.checkAndLogEmpty(ele, key, this.path, this.logger)) {
                    SerializerBuilder.Serializer serializer;
                    JsonObject obj = ele.getAsJsonObject();
                    if (this.subtypes && obj.has("type")) {
                        ResourceLocation type = new ResourceLocation(obj.get("type").getAsString());
                        serializer = (SerializerBuilder.Serializer)this.serializers.get((Object)type);
                        if (serializer == null) {
                            throw new RuntimeException("Attempted to deserialize a " + this.path + " with type " + type + " but no serializer exists!");
                        }
                    } else {
                        serializer = (SerializerBuilder.Serializer)this.serializers.get((Object)DEFAULT);
                    }
                    TypeKeyed deserialized = (TypeKeyed)serializer.deserialize(obj);
                    deserialized.setId((ResourceLocation)key);
                    deserialized.setSerializer(serializer);
                    Preconditions.checkNotNull((Object)deserialized.getId(), (Object)("A " + this.path + " with id " + key + " failed to set ID."));
                    Preconditions.checkNotNull((Object)deserialized.getSerializer(), (Object)("A " + this.path + " with id " + key + " failed to set serializer."));
                    this.register((ResourceLocation)key, (Object)deserialized);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed parsing {} file {}.", (Object)this.path, key);
                e.printStackTrace();
            }
        });
        this.onReload();
    }

    protected abstract void registerBuiltinSerializers();

    protected void beginReload() {
        this.registry = new HashMap<ResourceLocation, V>();
    }

    protected void onReload() {
        this.registry = ImmutableMap.copyOf(this.registry);
        this.logger.info("Registered {} {}.", (Object)this.registry.size(), (Object)this.path);
    }

    public final void registerSerializer(ResourceLocation id, SerializerBuilder<V> serializer) {
        if (this.subtypes) {
            if (this.serializers.containsKey((Object)id)) {
                throw new RuntimeException("Attempted to register a " + this.path + " serializer with id " + id + " but one already exists!");
            }
            if (this.serializers.isEmpty() && id != DEFAULT) {
                this.serializers.put((Object)DEFAULT, (Object)serializer.build(this.synced));
            }
            this.serializers.put((Object)id, (Object)serializer.build(this.synced));
        } else {
            if (!this.serializers.isEmpty()) {
                throw new RuntimeException("Attempted to register a " + this.path + " serializer with id " + id + " but subtypes are not supported!");
            }
            this.serializers.put((Object)DEFAULT, (Object)serializer.build(this.synced));
        }
    }

    private final void sync(OnDatapackSyncEvent e) {
        ServerPlayerEntity player = e.getPlayer();
        if (player == null) {
            NetworkUtils.sendToAll(Placebo.CHANNEL, new ReloadListenerPacket.Start(this.path));
            this.registry.forEach((k, v) -> NetworkUtils.sendToAll(Placebo.CHANNEL, new ReloadListenerPacket.Content<TypeKeyed>(this.path, (ResourceLocation)k, (TypeKeyed)v)));
            NetworkUtils.sendToAll(Placebo.CHANNEL, new ReloadListenerPacket.End(this.path));
        } else {
            NetworkUtils.sendTo(Placebo.CHANNEL, new ReloadListenerPacket.Start(this.path), (PlayerEntity)player);
            this.registry.forEach((k, v) -> NetworkUtils.sendTo(Placebo.CHANNEL, new ReloadListenerPacket.Content<TypeKeyed>(this.path, (ResourceLocation)k, (TypeKeyed)v), (PlayerEntity)player));
            NetworkUtils.sendTo(Placebo.CHANNEL, new ReloadListenerPacket.End(this.path), (PlayerEntity)player);
        }
    }

    protected <T extends V> void register(ResourceLocation key, T item) {
        this.registry.put(key, item);
    }

    public Set<ResourceLocation> getKeys() {
        return this.registry.keySet();
    }

    public Collection<V> getValues() {
        return this.registry.values();
    }

    @Nullable
    public V getValue(ResourceLocation key) {
        return this.getOrDefault(key, null);
    }

    public V getOrDefault(ResourceLocation key, V defValue) {
        return (V)((TypeKeyed)this.registry.getOrDefault(key, defValue));
    }

    public static boolean checkAndLogEmpty(JsonElement e, ResourceLocation id, String type, Logger logger) {
        String s = e.toString();
        if (s.isEmpty() || s.equals("{}")) {
            logger.debug("Ignoring {} item with id {} as it is empty.", (Object)type, (Object)id);
            return false;
        }
        return true;
    }

    public static boolean checkConditions(JsonElement e, ResourceLocation id, String type, Logger logger) {
        if (e.isJsonObject() && !CraftingHelper.processConditions((JsonObject)e.getAsJsonObject(), (String)"conditions")) {
            logger.debug("Skipping loading {} item with id {} as it's conditions were not met", (Object)type, (Object)id);
            return false;
        }
        return true;
    }

    public static void initSync(String path) {
        SYNC_REGISTRY.computeIfPresent(path, (k, v) -> {
            v.staged.clear();
            return v;
        });
    }

    public static <V extends TypeKeyed<V>> void writeItem(String path, V value, PacketBuffer buf) {
        SYNC_REGISTRY.computeIfPresent(path, (k, v) -> {
            ResourceLocation serId = (ResourceLocation)v.serializers.inverse().get((Object)value.getSerializer());
            buf.func_192572_a(serId);
            value.getSerializer().serialize(value, buf);
            return v;
        });
    }

    public static <V extends TypeKeyed<V>> V readItem(String path, ResourceLocation key, PacketBuffer buf) {
        PlaceboJsonReloadListener<?> listener = SYNC_REGISTRY.get(path);
        if (listener == null) {
            throw new RuntimeException("Received sync packet for unknown registry!");
        }
        SerializerBuilder.Serializer serializer = (SerializerBuilder.Serializer)listener.serializers.get((Object)buf.func_192575_l());
        TypeKeyed v = (TypeKeyed)serializer.deserialize(buf);
        v.setId(key);
        v.setSerializer(serializer);
        return (V)v;
    }

    public static <V extends TypeKeyed<V>> void acceptItem(String path, ResourceLocation key, V value) {
        SYNC_REGISTRY.computeIfPresent(path, (k, v) -> {
            v.staged.put(key, value);
            return v;
        });
    }

    public static <V extends TypeKeyed<V>> void endSync(String path) {
        SYNC_REGISTRY.computeIfPresent(path, (k, v) -> {
            v.beginReload();
            v.staged.forEach(v::register);
            v.onReload();
            return v;
        });
    }

    public static abstract class TypeKeyedBase<V extends TypeKeyed<V>>
    implements TypeKeyed<V> {
        protected ResourceLocation id;
        protected SerializerBuilder.Serializer serializer;

        @Override
        public void setId(ResourceLocation id) {
            if (this.id != null) {
                throw new UnsupportedOperationException();
            }
            this.id = id;
        }

        @Override
        public void setSerializer(SerializerBuilder.Serializer serializer) {
            if (this.serializer != null) {
                throw new UnsupportedOperationException();
            }
            this.serializer = serializer;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public SerializerBuilder.Serializer getSerializer() {
            return this.serializer;
        }
    }

    public static interface TypeKeyed<V extends TypeKeyed<V>> {
        public void setId(ResourceLocation var1);

        public void setSerializer(SerializerBuilder.Serializer var1);

        public ResourceLocation getId();

        public SerializerBuilder.Serializer getSerializer();
    }
}

