/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_640;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.helper.Draw;
import nx.pingwheel.common.helper.MathUtils;
import nx.pingwheel.common.helper.PingData;
import nx.pingwheel.common.helper.Raycast;
import nx.pingwheel.common.networking.PingLocationPacketC2S;
import nx.pingwheel.common.networking.PingLocationPacketS2C;
import nx.pingwheel.common.sound.DirectionalSoundInstance;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ClientCore {
    private static final int TPS = 20;
    private static final ClientConfig Config = ClientGlobal.ConfigHandler.getConfig();
    private static final ArrayList<PingData> pingRepo = new ArrayList();
    private static boolean queuePing = false;
    private static class_638 lastWorld = null;
    private static int dimension = 0;
    private static int lastPing = 0;
    private static int pingSequence = 0;

    private ClientCore() {
    }

    public static void markLocation() {
        queuePing = true;
    }

    public static void onPingLocation(class_2540 packet) {
        class_243 vecToPing;
        Optional<PingLocationPacketS2C> pingLocationPacket = PingLocationPacketS2C.parse(packet);
        if (pingLocationPacket.isEmpty() || ClientGlobal.Game.field_1724 == null || ClientGlobal.Game.field_1687 == null) {
            return;
        }
        PingLocationPacketS2C pingLocation = pingLocationPacket.get();
        if (!pingLocation.getChannel().equals(Config.getChannel())) {
            return;
        }
        if (Config.getPingDistance() < 2048 && (vecToPing = ClientGlobal.Game.field_1724.method_19538().method_1035(pingLocation.getPos())).method_1033() > (double)Config.getPingDistance()) {
            return;
        }
        class_640 authorPlayer = ClientGlobal.Game.field_1724.field_3944.method_2871(pingLocation.getAuthor());
        String authorName = authorPlayer != null ? authorPlayer.method_2966().getName() : "";
        ClientGlobal.Game.execute(() -> {
            ClientCore.addOrReplacePing(new PingData(pingLocation.getPos(), pingLocation.getEntity(), pingLocation.getAuthor(), authorName, pingLocation.getSequence(), pingLocation.getDimension(), (int)ClientGlobal.Game.field_1687.method_8510()));
            if (pingLocation.getDimension() == dimension) {
                ClientGlobal.Game.method_1483().method_4873((class_1113)new DirectionalSoundInstance(ClientGlobal.PING_SOUND_EVENT, class_3419.field_15250, (float)Config.getPingVolume() / 100.0f, 1.0f, pingLocation.getPos()));
            }
        });
    }

    public static void onRenderWorld(class_4587 matrixStack, Matrix4f projectionMatrix, float tickDelta) {
        if (ClientGlobal.Game.field_1687 == null) {
            return;
        }
        if (lastWorld != ClientGlobal.Game.field_1687) {
            lastWorld = ClientGlobal.Game.field_1687;
            dimension = lastWorld.method_27983().method_29177().hashCode();
        }
        int time = (int)ClientGlobal.Game.field_1687.method_8510();
        if (queuePing) {
            if ((float)(time - lastPing) > Config.getCorrectionPeriod() * 20.0f) {
                ++pingSequence;
            }
            lastPing = time;
            queuePing = false;
            ClientCore.executePing(tickDelta);
        }
        ClientCore.processPings(matrixStack, projectionMatrix, tickDelta, time);
    }

    public static void onRenderGUI(class_332 ctx, float tickDelta) {
        if (ClientGlobal.Game.field_1724 == null || pingRepo.isEmpty()) {
            return;
        }
        class_4587 m = ctx.method_51448();
        class_1041 wnd = ClientGlobal.Game.method_22683();
        class_243 screenBounds = new class_243((double)wnd.method_4486(), (double)wnd.method_4502(), 0.0);
        class_241 safeZoneTopLeft = new class_241((float)Config.getSafeZoneLeft(), (float)Config.getSafeZoneTop());
        class_241 safeZoneBottomRight = new class_241((float)screenBounds.field_1352 - (float)Config.getSafeZoneRight(), (float)screenBounds.field_1351 - (float)Config.getSafeZoneBottom());
        class_241 safeScreenCentre = new class_241((safeZoneBottomRight.field_1343 - safeZoneTopLeft.field_1343) * 0.5f, (safeZoneBottomRight.field_1342 - safeZoneTopLeft.field_1342) * 0.5f);
        boolean showDirectionIndicator = Config.isDirectionIndicatorVisible();
        boolean showNameLabels = Config.isNameLabelForced() || ClientGlobal.KEY_BINDING_NAME_LABELS.method_1434();
        m.method_22903();
        m.method_46416(0.0f, 0.0f, (float)(-pingRepo.size()));
        for (PingData ping : pingRepo) {
            boolean isOffScreen;
            if (ping.screenPos == null || ping.screenPos.z <= 0.0f && !showDirectionIndicator || ping.getDimension() != dimension) continue;
            m.method_46416(0.0f, 0.0f, 1.0f);
            Vector3f pos = ping.screenPos;
            float pingSize = (float)Config.getPingSize() / 100.0f;
            float pingScale = ClientCore.getDistanceScale(ping.distance) * pingSize * 0.4f;
            class_241 pingDirectionVec = new class_241(pos.x - safeZoneTopLeft.field_1343 - safeScreenCentre.field_1343, pos.y - safeZoneTopLeft.field_1342 - safeScreenCentre.field_1342);
            boolean behindCamera = false;
            if (pos.z <= 0.0f) {
                behindCamera = true;
                pingDirectionVec = pingDirectionVec.method_35582(-1.0f);
            }
            float pingAngle = (float)Math.atan2(pingDirectionVec.field_1342, pingDirectionVec.field_1343);
            boolean bl = isOffScreen = behindCamera || pos.x < 0.0f || (double)pos.x > screenBounds.field_1352 || pos.y < 0.0f || (double)pos.y > screenBounds.field_1351;
            if (isOffScreen && showDirectionIndicator) {
                class_241 indicator = MathUtils.calculateAngleRectIntersection(pingAngle, safeZoneTopLeft, safeZoneBottomRight);
                m.method_22903();
                m.method_46416(indicator.field_1343, indicator.field_1342, 0.0f);
                m.method_22903();
                m.method_22905(pingScale, pingScale, 1.0f);
                double indicatorOffsetX = Math.cos((double)pingAngle + Math.PI) * 12.0;
                double indicatorOffsetY = Math.sin((double)pingAngle + Math.PI) * 12.0;
                m.method_22904(indicatorOffsetX, indicatorOffsetY, 0.0);
                Draw.renderPing(ctx, ping.itemStack, Config.isItemIconVisible());
                m.method_22909();
                m.method_22903();
                MathUtils.rotateZ(m, pingAngle);
                m.method_22905(pingSize, pingSize, 1.0f);
                m.method_22905(0.25f, 0.25f, 1.0f);
                m.method_46416(-5.0f, 0.0f, 0.0f);
                Draw.renderArrow(m, true);
                m.method_22905(0.9f, 0.9f, 1.0f);
                Draw.renderArrow(m, false);
                m.method_22909();
                m.method_22909();
            }
            if (behindCamera) continue;
            m.method_22903();
            m.method_46416(pos.x, pos.y, 0.0f);
            m.method_22905(pingScale, pingScale, 1.0f);
            String text = String.format("%,.1fm", ping.distance);
            Draw.renderLabel(ctx, text, -1.5f);
            Draw.renderPing(ctx, ping.itemStack, Config.isItemIconVisible());
            if (showNameLabels && !ping.getAuthor().equals(ClientGlobal.Game.field_1724.method_5667())) {
                Draw.renderLabel(ctx, ping.getAuthorName(), 1.75f);
            }
            m.method_22909();
        }
        m.method_22909();
    }

    private static void processPings(class_4587 matrixStack, Matrix4f projectionMatrix, float tickDelta, int time) {
        if (ClientGlobal.Game.field_1724 == null || pingRepo.isEmpty()) {
            return;
        }
        Matrix4f modelViewMatrix = matrixStack.method_23760().method_23761();
        class_243 cameraPos = ClientGlobal.Game.field_1724.method_5836(tickDelta);
        for (PingData ping : pingRepo) {
            class_1297 ent;
            if (ping.getUuid() != null && (ent = ClientCore.getEntity(ping.getUuid())) != null) {
                if (ent.method_5864() == class_1299.field_6052 && Config.isItemIconVisible()) {
                    ping.itemStack = ((class_1542)ent).method_6983().method_7972();
                }
                ping.setPos(ent.method_30950(tickDelta).method_1031(0.0, ent.method_5829().method_17940(), 0.0));
            }
            ping.distance = cameraPos.method_1022(ping.getPos());
            ping.screenPos = MathUtils.worldToScreen(ping.getPos(), modelViewMatrix, projectionMatrix);
            ping.aliveTime = time - ping.getSpawnTime();
        }
        pingRepo.removeIf(p -> p.aliveTime > Config.getPingDuration() * 20);
        pingRepo.sort((a, b) -> Double.compare(b.distance, a.distance));
    }

    private static void executePing(float tickDelta) {
        class_1297 cameraEntity = ClientGlobal.Game.field_1719;
        if (cameraEntity == null || ClientGlobal.Game.field_1687 == null) {
            return;
        }
        class_243 cameraDirection = cameraEntity.method_5828(tickDelta);
        class_239 hitResult = Raycast.traceDirectional(cameraDirection, tickDelta, Math.min(Config.getRaycastDistance(), Config.getPingDistance()), cameraEntity.method_5715());
        if (hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        UUID uuid = null;
        if (hitResult.method_17783() == class_239.class_240.field_1331) {
            uuid = ((class_3966)hitResult).method_17782().method_5667();
        }
        new PingLocationPacketC2S(Config.getChannel(), hitResult.method_17784(), uuid, pingSequence, dimension).send();
    }

    private static void addOrReplacePing(PingData newPing) {
        int index = -1;
        for (int i = 0; i < pingRepo.size(); ++i) {
            PingData entry = pingRepo.get(i);
            if (!entry.getAuthor().equals(newPing.getAuthor()) || entry.getSequence() != newPing.getSequence()) continue;
            index = i;
            break;
        }
        if (index != -1) {
            pingRepo.set(index, newPing);
        } else {
            pingRepo.add(newPing);
        }
    }

    private static class_1297 getEntity(UUID uuid) {
        if (ClientGlobal.Game.field_1687 == null) {
            return null;
        }
        for (class_1297 entity : ClientGlobal.Game.field_1687.method_18112()) {
            if (!entity.method_5667().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    private static float getDistanceScale(double distance) {
        double scale = 2.0 / Math.pow(distance, 0.3);
        return (float)Math.max(1.0, scale);
    }
}

