/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.tile.ITileModule;
import net.roguelogix.phosphophyllite.tile.ModuleRegistry;
import net.roguelogix.phosphophyllite.tile.PhosphophylliteTile;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface ISidedMultipart {
    public ITileModule initialCoreModule();

    public static class SidedMultipartModule
    implements ITileModule {
        @Nonnull
        ITileModule coreModule;
        final ITileModule[] sidedModules = new ITileModule[6];
        final TileEntity tile;
        final ISidedMultipart multipartTile;

        @OnModLoad
        static void onModLoad() {
            ModuleRegistry.registerModule(ISidedMultipart.class, SidedMultipartModule::new);
        }

        SidedMultipartModule(TileEntity tile) {
            assert (tile instanceof ISidedMultipart);
            this.tile = tile;
            this.multipartTile = (ISidedMultipart)tile;
            this.coreModule = this.multipartTile.initialCoreModule();
        }

        @Override
        public TileEntity getTile() {
            return this.tile;
        }

        public ITileModule getSideModule(@Nullable Direction side) {
            if (side == null) {
                return this.coreModule;
            }
            ITileModule module = this.sidedModules[side.func_176745_a()];
            if (module == null) {
                return this.coreModule;
            }
            return module;
        }

        public <T> T getSideModule(@Nullable Direction side, Class<T> moduleType) {
            return (T)this.getSideModule(side);
        }

        public void setSideModule(@Nullable ITileModule module, @Nullable Direction side) {
            if (side == null) {
                if (module != null) {
                    this.coreModule = module;
                }
                return;
            }
            this.sidedModules[side.func_176745_a()] = module;
        }

        @Override
        public <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
            return this.getSideModule(side).capability(cap, side);
        }

        @Override
        public void onAdded() {
            this.coreModule.onAdded();
            for (ITileModule sidedModule : this.sidedModules) {
                if (sidedModule == null) continue;
                sidedModule.onAdded();
            }
        }

        @Override
        public void onRemoved(boolean chunkUnload) {
            this.coreModule.onRemoved(chunkUnload);
            for (ITileModule sidedModule : this.sidedModules) {
                if (sidedModule == null) continue;
                sidedModule.onRemoved(chunkUnload);
            }
        }

        @Override
        public void readNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b("core")) {
                CompoundNBT subNBT = nbt.func_74775_l("core");
                this.coreModule.readNBT(subNBT);
            }
            for (Direction value : Direction.values()) {
                if (!nbt.func_74764_b(value.toString())) continue;
                CompoundNBT subNBT = nbt.func_74775_l(value.toString());
                ITileModule module = this.sidedModules[value.func_176745_a()];
                if (module == null) {
                    PhosphophylliteTile.LOGGER.warn("Attempting to read NBT to side module that doesnt exist! " + this.tile + " : " + this.tile.func_174877_v());
                    continue;
                }
                module.readNBT(subNBT);
            }
        }

        @Override
        @Nullable
        public CompoundNBT writeNBT() {
            CompoundNBT nbt = null;
            CompoundNBT subNBT = this.coreModule.writeNBT();
            if (subNBT != null) {
                nbt = new CompoundNBT();
                nbt.func_218657_a("core", (INBT)subNBT);
            }
            for (Direction value : Direction.values()) {
                ITileModule module = this.sidedModules[value.func_176745_a()];
                if (module == null || (subNBT = module.writeNBT()) == null) continue;
                if (nbt == null) {
                    nbt = new CompoundNBT();
                }
                nbt.func_218657_a(value.toString(), (INBT)subNBT);
            }
            return nbt;
        }

        @Override
        public void handleDataNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b("core")) {
                CompoundNBT subNBT = nbt.func_74775_l("core");
                this.coreModule.handleDataNBT(subNBT);
            }
            for (Direction value : Direction.values()) {
                if (!nbt.func_74764_b(value.toString())) continue;
                CompoundNBT subNBT = nbt.func_74775_l(value.toString());
                ITileModule module = this.sidedModules[value.func_176745_a()];
                if (module == null) {
                    PhosphophylliteTile.LOGGER.warn("Attempting to read NBT to side module that doesnt exist! " + this.tile + " : " + this.tile.func_174877_v());
                    continue;
                }
                module.handleDataNBT(subNBT);
            }
        }

        @Override
        @Nullable
        public CompoundNBT getDataNBT() {
            CompoundNBT nbt = null;
            CompoundNBT subNBT = this.coreModule.getDataNBT();
            if (subNBT != null) {
                nbt = new CompoundNBT();
                nbt.func_218657_a("core", (INBT)subNBT);
            }
            for (Direction value : Direction.values()) {
                ITileModule module = this.sidedModules[value.func_176745_a()];
                if (module == null || (subNBT = module.getDataNBT()) == null) continue;
                if (nbt == null) {
                    nbt = new CompoundNBT();
                }
                nbt.func_218657_a(value.toString(), (INBT)subNBT);
            }
            return nbt;
        }

        @Override
        public void handleUpdateNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b("core")) {
                CompoundNBT subNBT = nbt.func_74775_l("core");
                this.coreModule.handleUpdateNBT(subNBT);
            }
            for (Direction value : Direction.values()) {
                if (!nbt.func_74764_b(value.toString())) continue;
                CompoundNBT subNBT = nbt.func_74775_l(value.toString());
                ITileModule module = this.sidedModules[value.func_176745_a()];
                if (module == null) {
                    PhosphophylliteTile.LOGGER.warn("Attempting to read NBT to side module that doesnt exist! " + this.tile + " : " + this.tile.func_174877_v());
                    continue;
                }
                module.handleUpdateNBT(subNBT);
            }
        }

        @Override
        @Nullable
        public CompoundNBT getUpdateNBT() {
            CompoundNBT nbt = null;
            CompoundNBT subNBT = this.coreModule.getUpdateNBT();
            if (subNBT != null) {
                nbt = new CompoundNBT();
                nbt.func_218657_a("core", (INBT)subNBT);
            }
            for (Direction value : Direction.values()) {
                ITileModule module = this.sidedModules[value.func_176745_a()];
                if (module == null || (subNBT = module.getUpdateNBT()) == null) continue;
                if (nbt == null) {
                    nbt = new CompoundNBT();
                }
                nbt.func_218657_a(value.toString(), (INBT)subNBT);
            }
            return nbt;
        }

        @Override
        public String getDebugInfo() {
            StringBuilder builder = new StringBuilder();
            builder.append("SidedModules:\n");
            builder.append("Core:\n");
            builder.append(this.coreModule.getDebugInfo());
            for (Direction value : Direction.values()) {
                ITileModule module = this.sidedModules[value.func_176745_a()];
                if (module == null) continue;
                builder.append("\n");
                builder.append(value);
                builder.append(":\n");
                builder.append(module.getDebugInfo());
            }
            builder.append("\n");
            return builder.toString();
        }

        @Override
        public String saveKey() {
            return "PhosphophylliteMultipartTileModule";
        }

        @Override
        public void onBlockUpdate(BlockState neighborBlockState, BlockPos neighborPos) {
            this.coreModule.onBlockUpdate(neighborBlockState, neighborPos);
            for (ITileModule sidedModule : this.sidedModules) {
                if (sidedModule == null) continue;
                sidedModule.onBlockUpdate(neighborBlockState, neighborPos);
            }
        }
    }
}

