/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.gui.client;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;

public class RenderHelper {
    private static ResourceLocation currentResource;
    public static String[] baseSizePrefixes;

    public static ResourceLocation getBlankTextureResource() {
        return new ResourceLocation("phosphophyllite", "textures/blank.png");
    }

    public static ResourceLocation getCurrentResource() {
        return currentResource;
    }

    public static void clearRenderColor() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setRenderColor(int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderHelper.setRenderColor(red, green, blue, alpha);
    }

    public static void setRenderColor(float red, float green, float blue, float alpha) {
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
        currentResource = resourceLocation;
    }

    public static void drawTexture(@Nonnull MatrixStack mStack, int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite) {
        AbstractGui.func_238470_a_((MatrixStack)mStack, (int)x, (int)y, (int)blitOffset, (int)width, (int)height, (TextureAtlasSprite)sprite);
    }

    public static void drawFluid(@Nonnull MatrixStack mStack, int x, int y, int blitOffset, int width, int height, Fluid fluid) {
        ResourceLocation preservedResource = RenderHelper.getCurrentResource();
        RenderHelper.bindTexture(PlayerContainer.field_226615_c_);
        RenderHelper.setRenderColor(fluid.getAttributes().getColor());
        RenderHelper.drawTexture(mStack, x, y, blitOffset, width, height, (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getAttributes().getStillTexture()));
        RenderHelper.clearRenderColor();
        RenderHelper.bindTexture(preservedResource);
    }

    public static void drawTextureGrid(@Nonnull MatrixStack mStack, int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite, int horizontalRepeat, int verticalRepeat) {
        for (int iX = 0; iX < horizontalRepeat; ++iX) {
            for (int iY = 0; iY < verticalRepeat; ++iY) {
                RenderHelper.drawTexture(mStack, x + width * iX, y + height * iY, blitOffset, width, height, sprite);
            }
        }
    }

    public static void drawFluidGrid(@Nonnull MatrixStack mStack, int x, int y, int blitOffset, int width, int height, Fluid fluid, int xRepeat, int yRepeat) {
        for (int iX = 0; iX < xRepeat; ++iX) {
            for (int iY = 0; iY < yRepeat; ++iY) {
                RenderHelper.drawFluid(mStack, x + width * iX, y + height * iY, blitOffset, width, height, fluid);
            }
        }
    }

    public static void drawMaskedFluid(@Nonnull MatrixStack mStack, int x, int y, int blitOffset, int width, int height, int u, int v, Fluid fluid) {
        RenderHelper.drawFluid(mStack, x, y, blitOffset, width, height, fluid);
        AbstractGui.func_238463_a_((MatrixStack)mStack, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)256, (int)256);
    }

    public static void drawMaskedFluidGrid(@Nonnull MatrixStack mStack, int x, int y, int blitOffset, int width, int height, int u, int v, Fluid fluid, int xRepeat, int yRepeat) {
        for (int iX = 0; iX < xRepeat; ++iX) {
            for (int iY = 0; iY < yRepeat; ++iY) {
                RenderHelper.drawMaskedFluid(mStack, x + width * iX, y + height * iY, blitOffset, width, height, u, v, fluid);
            }
        }
    }

    public static String formatValue(double value, @Nullable String suffix) {
        return RenderHelper.formatValue(value, suffix, false);
    }

    public static String formatValue(double value, @Nullable String suffix, boolean allowMilliSuffix) {
        return RenderHelper.formatValue(value, 1, suffix, allowMilliSuffix);
    }

    public static String formatValue(double value, int precision, @Nullable String suffix, boolean allowMilliSuffix) {
        PeekingIterator suffixIter = Iterators.peekingIterator(Arrays.stream(baseSizePrefixes).iterator());
        if (Math.abs(value) < 1.0 && allowMilliSuffix) {
            if (suffix != null) {
                return String.format("%." + precision + "f %s", value * 1000.0, (String)suffixIter.peek() + suffix);
            }
            return String.format("%." + precision + "f", value * 1000.0);
        }
        suffixIter.next();
        if (Math.abs(value) < 1000.0) {
            if (suffix != null) {
                return String.format("%." + precision + "f %s", value, (String)suffixIter.peek() + suffix);
            }
            return String.format("%." + precision + "f", value);
        }
        suffixIter.next();
        while (Math.abs(value) >= 999950.0 && suffixIter.hasNext()) {
            value /= 1000.0;
            suffixIter.next();
        }
        if (suffix != null) {
            return String.format("%." + precision + "f %s", value / 1000.0, (String)suffixIter.peek() + suffix);
        }
        return String.format("%." + precision + "f", value / 1000.0);
    }

    static {
        baseSizePrefixes = new String[]{"m", "", "Ki", "Me", "Gi", "Te", "Pe", "Ex", "Ze", "Yo", "Ho"};
    }
}

