/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.api.ScaleEventCallback;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.PehkuiEntityExtensions;

public class ScaleData {
    private float baseScale;
    private float prevBaseScale;
    private float initialScale;
    private float targetScale;
    private int scaleTicks;
    private int totalScaleTicks;
    private Boolean persistent = null;
    private Float2FloatFunction easing = null;
    private boolean shouldSync;
    private final ScaleType scaleType;
    @Nullable
    private final class_1297 entity;
    private final SortedSet<ScaleModifier> baseValueModifiers;
    private final SortedSet<ScaleModifier> differingModifierCache;
    private boolean trackModifierChanges;
    private float cachedScale = Float.NaN;
    private float cachedPrevScale = Float.NaN;

    @ApiStatus.Internal
    protected ScaleData(ScaleType scaleType, @Nullable class_1297 entity) {
        float defaultBaseScale;
        this.scaleType = scaleType;
        this.entity = entity;
        this.baseScale = defaultBaseScale = scaleType.getDefaultBaseScale();
        this.prevBaseScale = defaultBaseScale;
        this.initialScale = defaultBaseScale;
        this.targetScale = defaultBaseScale;
        this.scaleTicks = 0;
        this.totalScaleTicks = scaleType.getDefaultTickDelay();
        this.shouldSync = false;
        this.baseValueModifiers = new ObjectAVLTreeSet<ScaleModifier>(){

            public boolean add(ScaleModifier arg0) {
                if (super.add((Object)arg0)) {
                    ScaleData.this.invalidateCachedScales();
                    if (ScaleData.this.trackModifierChanges) {
                        ScaleData.this.invalidateCachedModifiers();
                        ScaleData.this.onUpdate();
                    }
                    return true;
                }
                return false;
            }

            public boolean remove(Object arg0) {
                if (super.remove(arg0)) {
                    ScaleData.this.invalidateCachedScales();
                    if (ScaleData.this.trackModifierChanges) {
                        ScaleData.this.invalidateCachedModifiers();
                        ScaleData.this.onUpdate();
                    }
                    return true;
                }
                return false;
            }
        };
        this.differingModifierCache = new ObjectAVLTreeSet();
        this.trackModifierChanges = false;
        this.getBaseValueModifiers().addAll(this.getScaleType().getDefaultBaseValueModifiers());
        this.trackModifierChanges = true;
    }

    public void tick() {
        this.invalidateCachedScales();
        float currScale = this.getBaseScale();
        float targetScale = this.getTargetScale();
        if (currScale != targetScale) {
            int scaleTickDelay = this.getScaleTickDelay();
            if (this.scaleTicks >= scaleTickDelay) {
                this.initialScale = targetScale;
                this.scaleTicks = 0;
                this.setBaseScale(targetScale);
            } else {
                ++this.scaleTicks;
                this.setBaseScale(this.calculateScaleForTick(this.scaleTicks, 0.0f));
            }
        } else {
            if (this.prevBaseScale != currScale) {
                this.prevBaseScale = currScale;
                this.cachedPrevScale = Float.NaN;
            }
            if (this.initialScale != targetScale) {
                this.initialScale = targetScale;
            }
            if (this.scaleTicks != 0) {
                this.scaleTicks = 0;
            }
        }
    }

    public ScaleType getScaleType() {
        return this.scaleType;
    }

    @Nullable
    public class_1297 getEntity() {
        return this.entity;
    }

    public SortedSet<ScaleModifier> getBaseValueModifiers() {
        return this.baseValueModifiers;
    }

    public float getBaseScale() {
        return this.getBaseScale(1.0f);
    }

    public float getBaseScale(float delta) {
        return delta == 1.0f ? this.baseScale : this.calculateScaleForTick(this.scaleTicks, delta);
    }

    public void setBaseScale(float scale) {
        scale = (float)this.getScaleType().clampBaseScale(this, scale);
        this.prevBaseScale = this.getBaseScale();
        this.baseScale = scale;
        this.onUpdate();
    }

    public float getScale() {
        return this.getScale(1.0f);
    }

    public float getScale(float delta) {
        boolean canCache;
        class_1297 e = this.getEntity();
        boolean bl = canCache = delta == 1.0f && e != null && e.method_5770() != null && !e.method_5770().field_9236 && (e.method_5864() != class_1299.field_6097 || !this.getScaleType().getAffectsDimensions()) && !((PehkuiEntityExtensions)e).pehkui_isFirstUpdate();
        if (canCache && !Float.isNaN(this.cachedScale)) {
            return this.cachedScale;
        }
        float value = this.getBaseScale(delta);
        for (ScaleModifier m : this.getBaseValueModifiers()) {
            value = m.modifyScale(this, value, delta);
        }
        if (canCache) {
            this.cachedScale = value;
        }
        return value;
    }

    public void setScale(float scale) {
        this.setBaseScale(scale);
        this.setTargetScale(scale);
    }

    public float getInitialScale() {
        return this.initialScale;
    }

    public float getTargetScale() {
        return this.targetScale;
    }

    public void setTargetScale(float targetScale) {
        targetScale = (float)this.getScaleType().clampTargetScale(this, targetScale);
        this.scaleTicks = this.calculateRemainingScaleTicks();
        this.initialScale = this.getTargetScale();
        this.targetScale = targetScale;
        this.markForSync(true);
    }

    @ApiStatus.Internal
    @ApiStatus.NonExtendable
    protected float calculateScaleForTick(int ticks, float delta) {
        Float2FloatFunction easing = Optional.ofNullable(this.getEasing()).orElseGet(this.getScaleType()::getDefaultEasing);
        float progress = (float)ticks + delta;
        int total = this.getScaleTickDelay();
        float range = this.getTargetScale() - this.initialScale;
        float perTick = total == 0 ? 1.0f : ((Float)easing.apply((Object)Float.valueOf(Math.min(progress / (float)total, 1.0f)))).floatValue();
        float next = this.initialScale + perTick * range;
        return next;
    }

    @ApiStatus.Internal
    @ApiStatus.NonExtendable
    protected int calculateRemainingScaleTicks() {
        float initial;
        float lastTarget = this.getTargetScale();
        int remaining = lastTarget == (initial = this.getInitialScale()) ? 0 : Math.round((float)this.getScaleTickDelay() * ((lastTarget - this.getBaseScale()) / (lastTarget - initial)));
        return remaining;
    }

    public int getScaleTickDelay() {
        return this.totalScaleTicks;
    }

    public void setScaleTickDelay(int ticks) {
        this.totalScaleTicks = ticks;
        this.markForSync(true);
    }

    public float getPrevScale() {
        if (!Float.isNaN(this.cachedPrevScale)) {
            return this.cachedPrevScale;
        }
        float value = this.getPrevBaseScale();
        for (ScaleModifier m : this.getBaseValueModifiers()) {
            value = m.modifyPrevScale(this, value);
        }
        this.cachedPrevScale = value;
        return value;
    }

    public float getPrevBaseScale() {
        return this.prevBaseScale;
    }

    public void setPersistence(@Nullable Boolean persistent) {
        this.persistent = persistent;
        this.markForSync(true);
    }

    @Nullable
    public Boolean getPersistence() {
        return this.persistent;
    }

    public boolean shouldPersist() {
        Boolean persist = this.getPersistence();
        return persist == null ? this.getScaleType().getDefaultPersistence() : persist.booleanValue();
    }

    @Nullable
    public Float2FloatFunction getEasing() {
        return this.easing;
    }

    public void setEasing(@Nullable Float2FloatFunction easing) {
        this.easing = easing;
        this.markForSync(true);
    }

    public void markForSync(boolean sync) {
        class_1297 e = this.getEntity();
        if (e != null && e.method_5770() != null && !e.method_5770().field_9236) {
            this.shouldSync = sync;
            if (this.shouldSync) {
                ((PehkuiEntityExtensions)e).pehkui_setShouldSyncScales(true);
            }
        }
    }

    public boolean shouldSync() {
        return this.shouldSync;
    }

    public void onUpdate() {
        this.invalidateCachedScales();
        this.markForSync(true);
        ((ScaleEventCallback)this.getScaleType().getScaleChangedEvent().invoker()).onEvent(this);
    }

    private void invalidateCachedModifiers() {
        this.differingModifierCache.clear();
        this.differingModifierCache.addAll(this.getBaseValueModifiers());
        this.differingModifierCache.removeAll(this.getScaleType().getDefaultBaseValueModifiers());
    }

    private void invalidateCachedScales() {
        this.cachedScale = Float.NaN;
        this.cachedPrevScale = Float.NaN;
    }

    public class_2540 toPacket(class_2540 buffer) {
        class_2540 buf = buffer;
        buf.writeFloat(this.baseScale).writeFloat(this.prevBaseScale).writeFloat(this.initialScale).writeFloat(this.targetScale).writeInt(this.scaleTicks).writeInt(this.totalScaleTicks).writeInt(this.differingModifierCache.size());
        for (ScaleModifier modifier : this.differingModifierCache) {
            buffer.method_10812(ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, modifier));
        }
        buf.writeByte(this.persistent == null ? -1 : (this.persistent != false ? 1 : 0));
        if (this.easing != null) {
            buf.writeBoolean(true);
            buffer.method_10812(ScaleRegistries.getId(ScaleRegistries.SCALE_EASINGS, this.easing));
        } else {
            buf.writeBoolean(false);
        }
        return buffer;
    }

    public void readNbt(class_2487 tag) {
        ScaleType type = this.getScaleType();
        this.baseScale = tag.method_10545("scale") ? tag.method_10583("scale") : type.getDefaultBaseScale();
        this.prevBaseScale = tag.method_10545("previous") ? tag.method_10583("previous") : this.baseScale;
        this.initialScale = tag.method_10545("initial") ? tag.method_10583("initial") : this.baseScale;
        this.targetScale = tag.method_10545("target") ? tag.method_10583("target") : this.baseScale;
        this.scaleTicks = tag.method_10545("ticks") ? tag.method_10550("ticks") : 0;
        this.totalScaleTicks = tag.method_10545("total_ticks") ? tag.method_10550("total_ticks") : type.getDefaultTickDelay();
        this.persistent = tag.method_10545("persistent") ? Boolean.valueOf(tag.method_10577("persistent")) : null;
        this.easing = tag.method_10545("easing") ? ScaleRegistries.getEntry(ScaleRegistries.SCALE_EASINGS, class_2960.method_12829((String)tag.method_10558("easing"))) : null;
        this.trackModifierChanges = false;
        SortedSet<ScaleModifier> baseValueModifiers = this.getBaseValueModifiers();
        baseValueModifiers.clear();
        baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
        if (tag.method_10573("baseValueModifiers", 9)) {
            class_2499 modifiers = (class_2499)tag.method_10580("baseValueModifiers");
            byte elementType = modifiers.method_10601();
            for (int i = 0; i < modifiers.size(); ++i) {
                ScaleModifier modifier;
                class_2960 id;
                if (elementType == 8) {
                    id = class_2960.method_12829((String)modifiers.method_10608(i));
                    modifier = ScaleRegistries.getEntry(ScaleRegistries.SCALE_MODIFIERS, id);
                } else if (elementType == 10) {
                    class_2487 compound = modifiers.method_10602(i);
                    id = class_2960.method_12829((String)compound.method_10558("id"));
                    modifier = ScaleRegistries.getEntry(ScaleRegistries.SCALE_MODIFIERS, id);
                } else {
                    modifier = null;
                }
                if (modifier == null) continue;
                baseValueModifiers.add(modifier);
            }
            this.invalidateCachedModifiers();
        } else {
            this.differingModifierCache.clear();
        }
        this.trackModifierChanges = true;
        this.onUpdate();
    }

    public class_2487 writeNbt(class_2487 tag) {
        Float2FloatFunction easing;
        Boolean persistent;
        float target;
        float initial;
        ScaleType type = this.getScaleType();
        float defaultBaseScale = type.getDefaultBaseScale();
        float scale = this.getBaseScale();
        if (scale != defaultBaseScale) {
            tag.method_10548("scale", scale);
        }
        if ((initial = this.getInitialScale()) != defaultBaseScale) {
            tag.method_10548("initial", initial);
        }
        if ((target = this.getTargetScale()) != defaultBaseScale) {
            tag.method_10548("target", target);
        }
        if (this.scaleTicks != 0) {
            tag.method_10569("ticks", this.scaleTicks);
        }
        if (this.totalScaleTicks != type.getDefaultTickDelay()) {
            tag.method_10569("total_ticks", this.totalScaleTicks);
        }
        if ((persistent = this.getPersistence()) != null) {
            tag.method_10556("persistent", persistent.booleanValue());
        }
        if ((easing = this.getEasing()) != null) {
            tag.method_10566("easing", class_2509.field_11560.method_10639(ScaleRegistries.getId(ScaleRegistries.SCALE_EASINGS, easing).toString()));
        }
        if (!this.differingModifierCache.isEmpty()) {
            class_2499 modifiers = new class_2499();
            for (ScaleModifier modifier : this.differingModifierCache) {
                modifiers.add((Object)class_2509.field_11560.method_10639(ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, modifier).toString()));
            }
            tag.method_10566("baseValueModifiers", (class_2520)modifiers);
        }
        return tag;
    }

    public ScaleData resetScale() {
        return this.resetScale(true);
    }

    public ScaleData resetScale(boolean notifyListener) {
        float defaultBaseScale;
        ScaleType type = this.getScaleType();
        this.baseScale = defaultBaseScale = type.getDefaultBaseScale();
        this.prevBaseScale = defaultBaseScale;
        this.initialScale = defaultBaseScale;
        this.targetScale = defaultBaseScale;
        this.scaleTicks = 0;
        this.totalScaleTicks = type.getDefaultTickDelay();
        this.persistent = null;
        this.easing = null;
        this.invalidateCachedScales();
        this.trackModifierChanges = false;
        SortedSet<ScaleModifier> baseValueModifiers = this.getBaseValueModifiers();
        baseValueModifiers.clear();
        baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
        this.differingModifierCache.clear();
        this.trackModifierChanges = true;
        if (notifyListener) {
            this.onUpdate();
        }
        return this;
    }

    public boolean isReset() {
        return this.hasDefaultValues();
    }

    @ApiStatus.Internal
    public boolean hasDefaultValues() {
        ScaleType type = this.getScaleType();
        float defaultBaseScale = type.getDefaultBaseScale();
        if (this.getBaseScale() != defaultBaseScale) {
            return false;
        }
        if (this.prevBaseScale != defaultBaseScale) {
            return false;
        }
        if (this.getInitialScale() != defaultBaseScale) {
            return false;
        }
        if (this.getTargetScale() != defaultBaseScale) {
            return false;
        }
        if (this.scaleTicks != 0) {
            return false;
        }
        if (this.getScaleTickDelay() != type.getDefaultTickDelay()) {
            return false;
        }
        if (!this.differingModifierCache.isEmpty()) {
            return false;
        }
        if (this.getPersistence() != null) {
            return false;
        }
        return this.getEasing() == null;
    }

    public ScaleData fromScale(ScaleData scaleData) {
        return this.fromScale(scaleData, true);
    }

    public ScaleData fromScale(ScaleData scaleData, boolean notifyListener) {
        boolean changed = false;
        if (scaleData != this) {
            float lastScale = this.baseScale;
            this.baseScale = scaleData.getBaseScale();
            if (this.baseScale != lastScale) {
                changed = true;
            }
            lastScale = this.prevBaseScale;
            this.prevBaseScale = scaleData.getPrevBaseScale();
            if (this.prevBaseScale != lastScale) {
                changed = true;
            }
            lastScale = this.initialScale;
            this.initialScale = scaleData.getInitialScale();
            if (this.initialScale != lastScale) {
                changed = true;
            }
            lastScale = this.targetScale;
            this.targetScale = scaleData.getTargetScale();
            if (this.targetScale != lastScale) {
                changed = true;
            }
            int lastTicks = this.scaleTicks;
            this.scaleTicks = scaleData.scaleTicks;
            if (this.scaleTicks != lastTicks) {
                changed = true;
            }
            lastTicks = this.totalScaleTicks;
            this.totalScaleTicks = scaleData.totalScaleTicks;
            if (this.totalScaleTicks != lastTicks) {
                changed = true;
            }
            Boolean lastPersistence = this.persistent;
            this.persistent = scaleData.getPersistence();
            if (this.persistent != lastPersistence) {
                changed = true;
            }
            Float2FloatFunction lastEasing = this.easing;
            this.easing = scaleData.getEasing();
            if (this.easing != lastEasing) {
                changed = true;
            }
            this.invalidateCachedScales();
        }
        if (notifyListener && changed) {
            this.onUpdate();
        }
        return this;
    }

    public ScaleData averagedFromScales(ScaleData scaleData, ScaleData ... scales) {
        float scale = scaleData.getBaseScale();
        float prevScale = scaleData.prevBaseScale;
        float fromScale = scaleData.getInitialScale();
        float toScale = scaleData.getTargetScale();
        int scaleTicks = scaleData.scaleTicks;
        int totalScaleTicks = scaleData.totalScaleTicks;
        for (ScaleData data : scales) {
            scale += data.getBaseScale();
            prevScale += data.prevBaseScale;
            fromScale += data.getInitialScale();
            toScale += data.getTargetScale();
            scaleTicks += data.scaleTicks;
            totalScaleTicks += data.totalScaleTicks;
        }
        float count = scales.length + 1;
        this.baseScale = scale / count;
        this.prevBaseScale = prevScale / count;
        this.initialScale = fromScale / count;
        this.targetScale = toScale / count;
        this.scaleTicks = Math.round((float)scaleTicks / count);
        this.totalScaleTicks = Math.round((float)totalScaleTicks / count);
        this.onUpdate();
        return this;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.initialScale), Float.valueOf(this.prevBaseScale), Float.valueOf(this.baseScale), this.scaleTicks, Float.valueOf(this.targetScale), this.totalScaleTicks);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScaleData)) {
            return false;
        }
        return this.equals((ScaleData)obj);
    }

    public boolean equals(ScaleData other) {
        if (this == other) {
            return true;
        }
        return Float.floatToIntBits(this.baseScale) == Float.floatToIntBits(other.baseScale) && Float.floatToIntBits(this.prevBaseScale) == Float.floatToIntBits(other.prevBaseScale) && Float.floatToIntBits(this.initialScale) == Float.floatToIntBits(other.initialScale) && Float.floatToIntBits(this.targetScale) == Float.floatToIntBits(other.targetScale) && this.scaleTicks == other.scaleTicks && this.totalScaleTicks == other.totalScaleTicks && Float.floatToIntBits(this.getScale()) == Float.floatToIntBits(other.getScale());
    }

    public static class Builder {
        private class_1297 entity = null;
        private ScaleType type = ScaleTypes.INVALID;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder type(ScaleType type) {
            this.type = type == null ? ScaleTypes.INVALID : type;
            return this;
        }

        public Builder entity(@Nullable class_1297 entity) {
            this.entity = entity;
            return this;
        }

        public ScaleData build() {
            ScaleData existing = this.entity == null ? null : this.type.getScaleData(this.entity);
            return existing != null ? existing : new ScaleData(this.type, this.entity);
        }
    }
}

