/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.enchants.EnchantmentArea;
import com.mowmaster.pedestals.enchants.EnchantmentCapacity;
import com.mowmaster.pedestals.enchants.EnchantmentOperationSpeed;
import com.mowmaster.pedestals.enchants.EnchantmentRange;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TippedArrowItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeTurret
extends ItemUpgradeBase {
    public static final Item TURRET = (Item)new ItemUpgradeTurret(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/turret"));

    public ItemUpgradeTurret(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 1;
        return areaWidth;
    }

    public int getRangeHeight(ItemStack stack) {
        return this.getHeight(stack);
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeTiny(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getRangeHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        BlockPos pedestalPos;
        if (!world.field_72995_K && !pedestal.isPedestalBlockPowered(world, pedestalPos = pedestal.func_174877_v())) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (itemInPedestal.func_77973_b() instanceof TippedArrowItem) {
                speed = 20;
            }
            if (world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(pedestal);
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal) {
        World world = pedestal.func_145831_w();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        ItemStack toolInPedestal = pedestal.getToolOnPedestal();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        int width = this.getAreaWidth(coinInPedestal);
        int height = this.getRangeHeight(coinInPedestal);
        BlockPos negBlockPos = this.getNegRangePosEntity(world, posOfPedestal, width, height);
        BlockPos posBlockPos = this.getPosRangePosEntity(world, posOfPedestal, width, height);
        AxisAlignedBB getBox = new AxisAlignedBB(negBlockPos, posBlockPos);
        if (!this.hasFilterBlock(coinInPedestal)) {
            this.writeFilterBlockToNBT(pedestal);
        }
        Block filterBlock = this.readFilterBlockFromNBT(coinInPedestal);
        List itemList = world.func_217357_a(LivingEntity.class, getBox);
        for (LivingEntity getEntityFromList : itemList) {
            FakePlayer fakePlayer;
            LivingEntity selectedEntity = this.getTargetEntity(filterBlock, getEntityFromList);
            if (selectedEntity == null || (fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal).get()) == null) continue;
            fakePlayer.func_174810_b(true);
            if (!fakePlayer.func_233580_cy_().equals((Object)new BlockPos(posOfPedestal.func_177958_n(), posOfPedestal.func_177956_o(), posOfPedestal.func_177952_p()))) {
                fakePlayer.func_70107_b((double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p());
            }
            if (pedestal.hasTool() && !fakePlayer.func_184614_ca().equals(toolInPedestal)) {
                fakePlayer.func_184201_a(EquipmentSlotType.MAINHAND, toolInPedestal);
            }
            if (toolInPedestal.func_190926_b() && !fakePlayer.func_184614_ca().equals(toolInPedestal)) {
                fakePlayer.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            }
            this.attackEntityWithRangedAttack(pedestal, fakePlayer, selectedEntity, 10.0f);
        }
    }

    public void attackEntityWithRangedAttack(PedestalTileEntity pedestal, FakePlayer fakePlayer, LivingEntity target, float distanceFactor) {
        int k;
        World world = pedestal.func_145831_w();
        ItemStack tool = pedestal.getToolOnPedestal();
        BlockPos pedestalPos = pedestal.func_174877_v();
        double[] doubleBlockAdd = this.getPedTopPos(pedestal, 1.0);
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        Block filterBlock = this.readFilterBlockFromNBT(coinInPedestal);
        ArrowEntity arrowEntity = new ArrowEntity(world, (double)pedestalPos.func_177958_n() + doubleBlockAdd[0], (double)pedestalPos.func_177956_o() + doubleBlockAdd[1], (double)pedestalPos.func_177952_p() + doubleBlockAdd[2]);
        if (itemInPedestal.func_77973_b() instanceof TippedArrowItem) {
            arrowEntity.func_184555_a(itemInPedestal);
            arrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
        }
        double d0 = target.func_226280_cw_() - (double)1.1f;
        double d1 = target.func_226277_ct_() - (double)pedestalPos.func_177958_n();
        double d2 = d0 - arrowEntity.func_226278_cu_();
        double d3 = target.func_226281_cx_() - (double)pedestalPos.func_177952_p();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        arrowEntity.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)tool);
        if (j > 0) {
            arrowEntity.func_70239_b(arrowEntity.func_70242_d() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)tool)) > 0) {
            arrowEntity.func_70240_a(k);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)tool) > 0) {
            arrowEntity.func_70015_d(100);
        }
        if (filterBlock.equals(Blocks.field_235397_ng_)) {
            arrowEntity.func_70239_b(arrowEntity.func_70242_d() * 2.0);
        }
        if (itemInPedestal.func_77973_b() instanceof TippedArrowItem) {
            Potion potion = PotionUtils.func_185191_c((ItemStack)itemInPedestal);
            List customPotionEffects = potion.func_185170_a();
            int count = 0;
            for (EffectInstance effectinstance : customPotionEffects) {
                if (target.func_70660_b(effectinstance.func_188419_a()) == null) continue;
                ++count;
            }
            if (count != customPotionEffects.size() && world.func_217376_c((Entity)arrowEntity)) {
                if (!pedestal.hasMuffler()) {
                    world.func_184148_a((PlayerEntity)null, (double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p(), SoundEvents.field_187797_fA, SoundCategory.HOSTILE, 0.25f, 1.0f);
                }
                pedestal.removeItem(1);
            }
        } else if (world.func_217376_c((Entity)arrowEntity) && !pedestal.hasMuffler()) {
            world.func_184148_a((PlayerEntity)null, (double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p(), SoundEvents.field_187797_fA, SoundCategory.HOSTILE, 0.25f, 1.0f);
        }
    }

    @Override
    public void onPedestalBelowNeighborChanged(PedestalTileEntity pedestal, BlockState blockChanged, BlockPos blockChangedPos) {
        BlockPos blockBelow = this.getPosOfBlockBelow(pedestal.func_145831_w(), pedestal.func_174877_v(), 1);
        if (blockBelow.equals((Object)blockChangedPos)) {
            this.writeFilterBlockToNBT(pedestal);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        Map map;
        ItemStack toolStack;
        ItemStack stack = pedestal.getCoinOnPedestal();
        Block filterBlock = this.hasFilterBlock(stack) ? this.readFilterBlockFromNBT(stack) : Blocks.field_150350_a;
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getRangeHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        ItemStack itemStack = toolStack = pedestal.hasTool() ? pedestal.getToolOnPedestal() : ItemStack.field_190927_a;
        if (!toolStack.func_190926_b()) {
            TranslationTextComponent tool = new TranslationTextComponent(this.func_77658_a() + ".chat_tool");
            tool.func_230529_a_(toolStack.func_200301_q());
            tool.func_240699_a_(TextFormatting.BLUE);
            player.func_145747_a((ITextComponent)tool, Util.field_240973_b_);
        }
        if ((map = EnchantmentHelper.func_82781_a((ItemStack)(pedestal.hasTool() ? pedestal.getToolOnPedestal() : stack))).size() > 0 && this.getNumNonPedestalEnchants(map) > 0) {
            TranslationTextComponent enchant = new TranslationTextComponent(this.func_77658_a() + ".chat_enchants");
            enchant.func_240699_a_(TextFormatting.LIGHT_PURPLE);
            player.func_145747_a((ITextComponent)enchant, Util.field_240973_b_);
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                Integer integer = (Integer)entry.getValue();
                if (enchantment instanceof EnchantmentCapacity || enchantment instanceof EnchantmentRange || enchantment instanceof EnchantmentOperationSpeed || enchantment instanceof EnchantmentArea) continue;
                TranslationTextComponent enchants = new TranslationTextComponent(" - " + enchantment.func_200305_d(integer.intValue()).getString());
                enchants.func_240699_a_(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)enchants, Util.field_240973_b_);
            }
        }
        TranslationTextComponent entityType = new TranslationTextComponent(this.func_77658_a() + ".chat_entity");
        entityType.func_240702_b_(this.getTargetEntity(filterBlock));
        entityType.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)entityType, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getRangeHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + (int)((float)this.getCapacityModifier(stack) + 2.0f) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        area.func_240699_a_(TextFormatting.WHITE);
        rate.func_240699_a_(TextFormatting.GRAY);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)area);
        tooltip.add((ITextComponent)rate);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)TURRET);
    }
}

