/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.blocks.PedestalBlock;
import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseMachine;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeTeleporter
extends ItemUpgradeBaseMachine {
    public static final Item TELEPORTER = (Item)new ItemUpgradeTeleporter(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/teleporter"));

    public ItemUpgradeTeleporter(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        BlockPos posOfBlock = pos;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof PedestalTileEntity && ((PedestalTileEntity)tile).getNumberOfStoredLocations() > 0) {
            BlockPos posBlock = ((PedestalTileEntity)tile).getStoredPositionAt(0);
            posOfBlock = this.getPosOfBlockBelow(world, posBlock, range);
        }
        return posOfBlock.func_177958_n();
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        BlockPos posOfBlock = pos;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof PedestalTileEntity && ((PedestalTileEntity)tile).getNumberOfStoredLocations() > 0) {
            BlockPos posBlock = ((PedestalTileEntity)tile).getStoredPositionAt(0);
            posOfBlock = this.getPosOfBlockBelow(world, posBlock, range);
        }
        return new int[]{posOfBlock.func_177956_o(), 1};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        int range = this.getRangeSmall(coin);
        BlockPos posOfBlock = pos;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof PedestalTileEntity && ((PedestalTileEntity)tile).getNumberOfStoredLocations() > 0) {
            BlockPos posBlock = ((PedestalTileEntity)tile).getStoredPositionAt(0);
            posOfBlock = this.getPosOfBlockBelow(world, posBlock, range);
        }
        return posOfBlock.func_177952_p();
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxFuelValue = this.getFuelBuffer(coinInPedestal);
            if (!this.hasMaxFuelSet(coinInPedestal) || this.readMaxFuelFromNBT(coinInPedestal) != getMaxFuelValue) {
                this.setMaxFuel(coinInPedestal, getMaxFuelValue);
            }
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(world, itemInPedestal, coinInPedestal, pedestalPos);
            }
        }
    }

    public void upgradeAction(World world, ItemStack itemInPedestal, ItemStack coinInPedestal, BlockPos posOfPedestal) {
        int width = 0;
        int height = 1;
        BlockPos negBlockPos = this.getNegRangePosEntity(world, posOfPedestal, width, height);
        BlockPos posBlockPos = this.getPosRangePosEntity(world, posOfPedestal, width, height);
        BlockState state = world.func_180495_p(posOfPedestal);
        if (state.func_177230_c() instanceof PedestalBlock) {
            PedestalTileEntity pedestal = (PedestalTileEntity)world.func_175625_s(posOfPedestal);
            AxisAlignedBB getBox = new AxisAlignedBB(negBlockPos, posBlockPos);
            List entityList = world.func_217357_a(Entity.class, getBox);
            for (Entity getFromList : entityList) {
                if (getFromList instanceof ItemEntity) continue;
                this.doTeleport(world, pedestal, posOfPedestal, state, getFromList, false);
            }
        }
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        if (entityIn instanceof ItemEntity) {
            ItemStack getItemStack = ((ItemEntity)entityIn).func_92059_d();
            if (getItemStack.func_77973_b().equals(Items.field_151079_bi)) {
                int getBurnTimeForStack = 16 * getItemStack.func_190916_E();
                if (this.addFuel(tilePedestal, getBurnTimeForStack, true)) {
                    this.addFuel(tilePedestal, getBurnTimeForStack, false);
                    entityIn.func_70106_y();
                }
            } else if (getItemStack.func_77973_b().equals(Items.field_185161_cS)) {
                int getBurnTimeForStack = 4 * getItemStack.func_190916_E();
                if (this.addFuel(tilePedestal, getBurnTimeForStack, true)) {
                    this.addFuel(tilePedestal, getBurnTimeForStack, false);
                    entityIn.func_70106_y();
                }
            } else {
                this.doTeleport(world, tilePedestal, posPedestal, state, entityIn, true);
            }
        }
    }

    public int getTeleportDistance(BlockPos pedestalOrigin, BlockPos pedestalDestination) {
        int x = pedestalDestination.func_177958_n();
        int y = pedestalDestination.func_177956_o();
        int z = pedestalDestination.func_177952_p();
        int x1 = pedestalOrigin.func_177958_n();
        int y1 = pedestalOrigin.func_177956_o();
        int z1 = pedestalOrigin.func_177952_p();
        int xF = Math.abs(Math.subtractExact(x, x1));
        int yF = Math.abs(Math.subtractExact(y, y1));
        int zF = Math.abs(Math.subtractExact(z, z1));
        return xF + yF + zF;
    }

    public boolean doTeleport(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn, boolean isItemEntity) {
        if (!world.func_175640_z(posPedestal) && tilePedestal.getNumberOfStoredLocations() > 0) {
            for (int i = 0; i < tilePedestal.getNumberOfStoredLocations(); ++i) {
                if (tilePedestal.getStoredPositionAt(i) == posPedestal) continue;
                if (this.canTeleportTo(world, tilePedestal, posPedestal, tilePedestal.getStoredPositionAt(i), isItemEntity) == 1) {
                    if (!this.teleportEntity(world, tilePedestal, tilePedestal.getStoredPositionAt(i), entityIn)) break;
                    if (!tilePedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)posPedestal.func_177958_n(), (double)posPedestal.func_177956_o(), (double)posPedestal.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.25f, 1.0f);
                    }
                    this.removeFuel(tilePedestal, this.getTeleportDistance(posPedestal, tilePedestal.getStoredPositionAt(i)), false);
                    break;
                }
                if (this.canTeleportTo(world, tilePedestal, posPedestal, tilePedestal.getStoredPositionAt(i), isItemEntity) != 2 || !this.hasFuel(tilePedestal.getCoinOnPedestal())) continue;
                int range = this.getRangeSmall(tilePedestal.getCoinOnPedestal());
                int remainingFuel = this.getFuelStored(tilePedestal.getCoinOnPedestal());
                BlockPos randomPos = world.func_217383_a((int)entityIn.func_226277_ct_(), (int)entityIn.func_226278_cu_(), (int)entityIn.func_226281_cx_(), range * remainingFuel);
                if (!this.teleportEntityRandom(tilePedestal, world, randomPos, entityIn)) break;
                if (!tilePedestal.hasMuffler()) {
                    world.func_184148_a((PlayerEntity)null, (double)posPedestal.func_177958_n(), (double)posPedestal.func_177956_o(), (double)posPedestal.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.25f, 1.0f);
                }
                this.removeFuel(tilePedestal, remainingFuel, false);
                break;
            }
        }
        return false;
    }

    public int canTeleportTo(World world, PedestalTileEntity tilePedestal, BlockPos posOrigPedestal, BlockPos posDestPedestal, boolean isItemEntity) {
        if (world.isAreaLoaded(posDestPedestal, 1) && !world.func_175640_z(posDestPedestal) && world.func_180495_p(posDestPedestal).func_177230_c() instanceof PedestalBlock && world.func_175625_s(posDestPedestal) instanceof PedestalTileEntity) {
            if (this.getTeleportDistance(posOrigPedestal, posDestPedestal) <= this.getFuelStored(tilePedestal.getCoinOnPedestal())) {
                int range = this.getRangeSmall(tilePedestal.getCoinOnPedestal());
                BlockPos posDestBlock = this.getPosOfBlockBelow(world, posDestPedestal, range);
                BlockState blocktoTPto = world.func_180495_p(posDestBlock);
                if (isItemEntity ? world.func_175623_d(posDestBlock) || blocktoTPto.func_177230_c() instanceof IFluidBlock || blocktoTPto.func_177230_c() instanceof FlowingFluidBlock : world.func_175623_d(posDestBlock) || (blocktoTPto.func_177230_c() instanceof IFluidBlock || blocktoTPto.func_177230_c() instanceof FlowingFluidBlock) && world.func_175623_d(posDestBlock.func_177982_a(0, 1, 0)) || blocktoTPto.func_177230_c() instanceof IFluidBlock || blocktoTPto.func_177230_c() instanceof FlowingFluidBlock) {
                    return 1;
                }
            } else {
                return 2;
            }
        }
        return 0;
    }

    public boolean teleportEntity(World world, PedestalTileEntity tilePedestal, BlockPos posPedestalDest, Entity entityIn) {
        int range = this.getRangeSmall(tilePedestal.getCoinOnPedestal());
        BlockPos pos = this.getPosOfBlockBelow(world, posPedestalDest, range);
        if (entityIn instanceof PlayerEntity) {
            ((PlayerEntity)entityIn).func_184210_p();
            ((ServerPlayerEntity)entityIn).field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, entityIn.field_70177_z, entityIn.field_70125_A);
            if (!tilePedestal.hasMuffler()) {
                world.func_184148_a(null, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return true;
        }
        if (entityIn instanceof CreatureEntity) {
            ((CreatureEntity)entityIn).func_184210_p();
            ((CreatureEntity)entityIn).func_223102_j((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            if (!tilePedestal.hasMuffler()) {
                world.func_184148_a(null, (double)posPedestalDest.func_177958_n(), (double)posPedestalDest.func_177956_o(), (double)posPedestalDest.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return true;
        }
        if (entityIn instanceof ItemEntity) {
            ((ItemEntity)entityIn).func_184210_p();
            ((ItemEntity)entityIn).func_223102_j((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            if (!tilePedestal.hasMuffler()) {
                world.func_184148_a(null, (double)posPedestalDest.func_177958_n(), (double)posPedestalDest.func_177956_o(), (double)posPedestalDest.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public boolean teleportEntityRandom(PedestalTileEntity pedestal, World world, BlockPos posPedestalDest, Entity entityIn) {
        if (entityIn instanceof PlayerEntity) {
            ((PlayerEntity)entityIn).func_184210_p();
            ((ServerPlayerEntity)entityIn).field_71135_a.func_147364_a((double)posPedestalDest.func_177958_n(), (double)posPedestalDest.func_177956_o(), (double)posPedestalDest.func_177952_p(), entityIn.field_70177_z, entityIn.field_70125_A);
            if (!pedestal.hasMuffler()) {
                world.func_184148_a(null, entityIn.func_226277_ct_() + 0.5, entityIn.func_226278_cu_(), entityIn.func_226281_cx_() + 0.5, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return true;
        }
        if (entityIn instanceof CreatureEntity) {
            ((CreatureEntity)entityIn).func_184210_p();
            if (((CreatureEntity)entityIn).func_213373_a((double)posPedestalDest.func_177958_n(), (double)posPedestalDest.func_177956_o(), (double)posPedestalDest.func_177952_p(), true)) {
                if (!pedestal.hasMuffler()) {
                    world.func_184148_a(null, (double)posPedestalDest.func_177958_n() + 0.5, (double)posPedestalDest.func_177956_o(), (double)posPedestalDest.func_177952_p() + 0.5, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                return true;
            }
        } else if (entityIn instanceof ItemEntity) {
            ((ItemEntity)entityIn).func_184210_p();
            ((ItemEntity)entityIn).func_223102_j((double)posPedestalDest.func_177958_n() + 0.5, (double)posPedestalDest.func_177956_o(), (double)posPedestalDest.func_177952_p() + 0.5);
            if (!pedestal.hasMuffler()) {
                world.func_184148_a(null, (double)posPedestalDest.func_177958_n(), (double)posPedestalDest.func_177956_o(), (double)posPedestalDest.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getOperationSpeedString(ItemStack stack) {
        TranslationTextComponent normal = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_0");
        TranslationTextComponent twox = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_1");
        TranslationTextComponent fourx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_2");
        TranslationTextComponent sixx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_3");
        TranslationTextComponent tenx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_4");
        TranslationTextComponent twentyx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_5");
        String str = normal.getString();
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                str = normal.getString();
                break;
            }
            case 1: {
                str = twox.getString();
                break;
            }
            case 2: {
                str = fourx.getString();
                break;
            }
            case 3: {
                str = sixx.getString();
                break;
            }
            case 4: {
                str = tenx.getString();
                break;
            }
            case 5: {
                str = twentyx.getString();
                break;
            }
            default: {
                str = normal.getString();
            }
        }
        return str;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRandomDisplayTick(PedestalTileEntity pedestal, int tick, BlockState stateIn, World world, BlockPos pos, Random rand) {
        int fuelValue;
        if (!pedestal.hasParticleDiffuser() && !world.func_175640_z(pos) && (fuelValue = this.getFuelStored(pedestal.getCoinOnPedestal())) > 0) {
            this.spawnParticleAroundPedestalBase(world, tick, pos, ParticleTypes.field_197599_J);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent range = new TranslationTextComponent(this.func_77658_a() + ".chat_range");
        range.func_240702_b_("" + this.getRangeSmall(stack) + "");
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        range.func_240699_a_(TextFormatting.WHITE);
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)range, Util.field_240973_b_);
        int fuelLeft = this.getFuelStored(pedestal.getCoinOnPedestal());
        TranslationTextComponent fuel = new TranslationTextComponent(this.func_77658_a() + ".chat_fuel");
        fuel.func_240702_b_("" + fuelLeft + "");
        fuel.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)fuel, Util.field_240973_b_);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        TranslationTextComponent range = new TranslationTextComponent(this.func_77658_a() + ".tooltip_range");
        range.func_240702_b_("" + this.getRangeSmall(stack) + "");
        range.func_240699_a_(TextFormatting.WHITE);
        tooltip.add((ITextComponent)range);
        TranslationTextComponent fuelStored = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fuelstored");
        fuelStored.func_240702_b_("" + this.getFuelStored(stack) + "");
        fuelStored.func_240699_a_(TextFormatting.GREEN);
        tooltip.add((ITextComponent)fuelStored);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)TELEPORTER);
    }
}

