/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseFluid;
import com.mowmaster.pedestals.network.PacketHandler;
import com.mowmaster.pedestals.network.PacketParticles;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeMilker
extends ItemUpgradeBaseFluid {
    public int rangeHeight = 1;
    public static final Item MILKER = (Item)new ItemUpgradeMilker(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/milker"));

    public ItemUpgradeMilker(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 1;
        return areaWidth;
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeTiny(stack);
    }

    public FluidStack getFluidInItem(ItemStack itemInPedestal) {
        if (FluidUtil.getFluidHandler((ItemStack)itemInPedestal).isPresent()) {
            FluidStack fluidInItem = FluidUtil.getFluidContained((ItemStack)itemInPedestal).orElse(FluidStack.EMPTY);
            return fluidInItem;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxFluidValue = this.getFluidbuffer(coinInPedestal);
            if (!this.hasMaxFluidSet(coinInPedestal) || this.readMaxFluidFromNBT(coinInPedestal) != getMaxFluidValue) {
                this.setMaxFluid(coinInPedestal, getMaxFluidValue);
            }
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                if (this.hasFluidInCoin(coinInPedestal)) {
                    this.upgradeActionSendFluid(pedestal);
                }
                if (world.func_82737_E() % (long)speed == 0L) {
                    this.upgradeAction(pedestal, world, itemInPedestal, coinInPedestal, pedestalPos);
                }
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, ItemStack itemInPedestal, ItemStack coinInPedestal, BlockPos posOfPedestal) {
        block10: {
            ItemStack itemMilkBucket;
            ItemStack itemForHand;
            AxisAlignedBB getBox;
            block11: {
                int i;
                IItemHandler handler;
                LazyOptional<IItemHandler> cap;
                ItemStack itemFromInv;
                block12: {
                    int width = this.getAreaWidth(coinInPedestal);
                    int height = this.getHeight(coinInPedestal);
                    BlockPos negBlockPos = this.getNegRangePosEntity(world, posOfPedestal, width, height);
                    BlockPos posBlockPos = this.getPosRangePosEntity(world, posOfPedestal, width, height);
                    getBox = new AxisAlignedBB(negBlockPos, posBlockPos);
                    BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
                    itemFromInv = ItemStack.field_190927_a;
                    itemForHand = new ItemStack((IItemProvider)Items.field_151133_ar);
                    itemMilkBucket = new ItemStack((IItemProvider)Items.field_151117_aB);
                    cap = ItemUpgradeMilker.findItemHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
                    if (!cap.isPresent()) break block11;
                    if (this.isInventoryEmpty(cap)) break block10;
                    handler = (IItemHandler)cap.orElse(null);
                    TileEntity invToPullFrom = world.func_175625_s(posInventory);
                    if (this.hasAdvancedInventoryTargeting(coinInPedestal) && invToPullFrom instanceof PedestalTileEntity || !(invToPullFrom instanceof PedestalTileEntity)) break block12;
                    itemFromInv = ItemStack.field_190927_a;
                    break block10;
                }
                if (handler == null || (i = this.getNextSlotWithItemsCap(cap, this.getStackInPedestal(world, posOfPedestal))) < 0 || !(itemFromInv = handler.getStackInSlot(i)).func_77973_b().equals(Items.field_151133_ar)) break block10;
                ItemStack milkBucket = new ItemStack((IItemProvider)Items.field_151117_aB, 1);
                List moo = world.func_217357_a(CowEntity.class, getBox);
                if (moo.size() <= 0) break block10;
                for (CowEntity moomoo : moo) {
                    if (moomoo.func_70631_g_() || !itemInPedestal.equals(ItemStack.field_190927_a)) continue;
                    BlockPos mooie = moomoo.func_233580_cy_();
                    if (!pedestal.hasParticleDiffuser()) {
                        PacketHandler.sendToNearby(world, posOfPedestal, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR, mooie.func_177958_n(), (double)mooie.func_177956_o() + 0.5, (double)mooie.func_177952_p(), 255, 255, 255));
                    }
                    if (!pedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187564_an, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    }
                    if (handler.extractItem(i, 1, true).func_190926_b()) continue;
                    handler.extractItem(i, 1, false);
                    pedestal.addItem(milkBucket);
                    break block10;
                }
                break block10;
            }
            if (this.availableFluidSpaceInCoin(coinInPedestal) >= 1000) {
                List moo;
                ITag MILK = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("forge", "milk"));
                FluidStack fluid = this.getFluidInItem(new ItemStack((IItemProvider)Items.field_151117_aB));
                if ((MILK != null && MILK.func_230235_a_((Object)itemMilkBucket.func_77973_b()) || !fluid.isEmpty()) && (moo = world.func_217357_a(CowEntity.class, getBox)).size() > 0) {
                    for (CowEntity moomoo : moo) {
                        FakePlayer fakePlayer = (FakePlayer)this.fakePedestalPlayer(pedestal, itemForHand).get();
                        if (fakePlayer == null) continue;
                        fakePlayer.func_174810_b(true);
                        if (!fakePlayer.func_233580_cy_().equals((Object)posOfPedestal)) {
                            fakePlayer.func_70107_b((double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p());
                        }
                        if (!fakePlayer.func_184614_ca().equals(itemForHand)) {
                            fakePlayer.func_184611_a(Hand.MAIN_HAND, itemForHand);
                        }
                        ActionResultType result = moomoo.func_230254_b_((PlayerEntity)fakePlayer, Hand.MAIN_HAND);
                        fluid = this.getFluidInItem(fakePlayer.func_184614_ca());
                        if (!result.func_226246_a_() || fluid.isEmpty() || !this.addFluid(pedestal, coinInPedestal, fluid, true)) continue;
                        BlockPos mooie = moomoo.func_233580_cy_();
                        if (!pedestal.hasParticleDiffuser()) {
                            PacketHandler.sendToNearby(world, posOfPedestal, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR, mooie.func_177958_n(), (double)mooie.func_177956_o() + 0.5, (double)mooie.func_177952_p(), 255, 255, 255));
                        }
                        if (!pedestal.hasMuffler()) {
                            world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187564_an, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        }
                        this.addFluid(pedestal, coinInPedestal, fluid, false);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            player.func_145747_a((ITextComponent)fluid, Util.field_240973_b_);
        }
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".chat_rate");
        rate.func_240702_b_("" + this.getFluidTransferRate(stack) + "");
        rate.func_240702_b_(fluidLabel.getString());
        rate.func_240699_a_(TextFormatting.GRAY);
        player.func_145747_a((ITextComponent)rate, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        tooltip.add((ITextComponent)area);
        FluidStack fluidStored = this.getFluidStored(stack);
        TranslationTextComponent fluidLabel = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidlabel");
        if (!fluidStored.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent(this.func_77658_a() + ".chat_fluid");
            TranslationTextComponent fluidSplit = new TranslationTextComponent(this.func_77658_a() + ".chat_fluidseperator");
            fluid.func_240702_b_("" + fluidStored.getDisplayName().getString() + "");
            fluid.func_240702_b_(fluidSplit.getString());
            fluid.func_240702_b_("" + fluidStored.getAmount() + "");
            fluid.func_240702_b_(fluidLabel.getString());
            fluid.func_240699_a_(TextFormatting.BLUE);
            tooltip.add((ITextComponent)fluid);
        }
        TranslationTextComponent fluidcapacity = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fluidcapacity");
        fluidcapacity.func_240702_b_("" + this.getFluidbuffer(stack) + "");
        fluidcapacity.func_240702_b_(fluidLabel.getString());
        fluidcapacity.func_240699_a_(TextFormatting.AQUA);
        tooltip.add((ITextComponent)fluidcapacity);
        TranslationTextComponent rate = new TranslationTextComponent(this.func_77658_a() + ".tooltip_rate");
        rate.func_240702_b_("" + this.getFluidTransferRate(stack) + "");
        rate.func_240702_b_(fluidLabel.getString());
        rate.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)rate);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)MILKER);
    }
}

