/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseEnergy;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEnergyImport
extends ItemUpgradeBaseEnergy {
    public static final Item RFIMPORT = (Item)new ItemUpgradeEnergyImport(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/rfimport"));

    public ItemUpgradeEnergyImport(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return true;
    }

    @Override
    public boolean canSendItem(PedestalTileEntity tile) {
        return this.getStoredInt(tile.getCoinOnPedestal()) > 0;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                this.upgradeActionSendEnergy(pedestal);
                if (world.func_82737_E() % (long)speed == 0L) {
                    this.upgradeItemAction(world, pedestalPos, itemInPedestal, coinInPedestal);
                    this.upgradeAction(world, pedestalPos, itemInPedestal, coinInPedestal);
                }
            }
        }
    }

    public void upgradeAction(World world, BlockPos posOfPedestal, ItemStack itemInPedestal, ItemStack coinInPedestal) {
        IEnergyStorage handler;
        int getMaxEnergyValue = this.getEnergyBuffer(coinInPedestal);
        if (!this.hasMaxEnergySet(coinInPedestal) || this.readMaxEnergyFromNBT(coinInPedestal) != getMaxEnergyValue) {
            this.setMaxEnergy(coinInPedestal, getMaxEnergyValue);
        }
        BlockPos posInventory = this.getPosOfBlockBelow(world, posOfPedestal, 1);
        ItemStack itemFromPedestal = ItemStack.field_190927_a;
        LazyOptional<IEnergyStorage> cap = ItemUpgradeEnergyImport.findEnergyHandlerAtPos(world, posInventory, this.getPedestalFacing(world, posOfPedestal), true);
        TileEntity invToPushTo = world.func_175625_s(posInventory);
        if (invToPushTo instanceof PedestalTileEntity) {
            itemFromPedestal = ItemStack.field_190927_a;
        } else if (cap.isPresent() && (handler = (IEnergyStorage)cap.orElse(null)) != null && handler.canExtract()) {
            int transferRate;
            int containerCurrentEnergy = handler.getEnergyStored();
            int getMaxEnergy = getMaxEnergyValue;
            int getCurrentEnergy = this.getEnergyStored(coinInPedestal);
            int getSpaceForEnergy = getMaxEnergy - getCurrentEnergy;
            int n = transferRate = getSpaceForEnergy >= this.getEnergyTransferRate(coinInPedestal) ? this.getEnergyTransferRate(coinInPedestal) : getSpaceForEnergy;
            if (containerCurrentEnergy < transferRate) {
                transferRate = containerCurrentEnergy;
            }
            if (handler.extractEnergy(transferRate, true) > 0) {
                int energyRemainingInUpgrade = getCurrentEnergy + transferRate;
                this.setEnergyStored(coinInPedestal, energyRemainingInUpgrade);
                handler.extractEnergy(transferRate, false);
            }
        }
    }

    public void upgradeItemAction(World world, BlockPos posOfPedestal, ItemStack itemInPedestal, ItemStack coinInPedestal) {
        TileEntity tile = world.func_175625_s(posOfPedestal);
        if (tile instanceof PedestalTileEntity) {
            PedestalTileEntity ped = (PedestalTileEntity)tile;
            int getMaxEnergyValue = this.getEnergyBuffer(coinInPedestal);
            if (ped.hasItem()) {
                if (ItemUpgradeEnergyImport.isEnergyItemExtract(itemInPedestal)) {
                    int transferRate;
                    int itemCurrentEnergy = ItemUpgradeEnergyImport.getEnergyInStack(itemInPedestal);
                    int getMaxEnergy = getMaxEnergyValue;
                    int getCurrentEnergy = this.getEnergyStored(coinInPedestal);
                    int getSpaceForEnergy = getMaxEnergy - getCurrentEnergy;
                    int n = transferRate = getSpaceForEnergy >= this.getEnergyTransferRate(coinInPedestal) ? this.getEnergyTransferRate(coinInPedestal) : getSpaceForEnergy;
                    if (itemCurrentEnergy < transferRate) {
                        transferRate = itemCurrentEnergy;
                    }
                    if (ItemUpgradeEnergyImport.extractEnergyFromStack(itemInPedestal, transferRate, true) > 0) {
                        int energyRemainingInUpgrade = getCurrentEnergy + transferRate;
                        this.setEnergyStored(coinInPedestal, energyRemainingInUpgrade);
                        ItemUpgradeEnergyImport.extractEnergyFromStack(itemInPedestal, transferRate, false);
                        this.writeStoredIntToNBT(coinInPedestal, 0);
                        ped.update();
                    }
                } else {
                    this.writeStoredIntToNBT(coinInPedestal, 1);
                    ped.update();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)RFIMPORT);
    }
}

