/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseEnergy;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEnergyGeneratorMob
extends ItemUpgradeBaseEnergy {
    public static final Item RFMOBGEN = (Item)new ItemUpgradeEnergyGeneratorMob(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/rfmobgen"));

    public ItemUpgradeEnergyGeneratorMob(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canSendItem(PedestalTileEntity tile) {
        return this.getStoredInt(tile.getCoinOnPedestal()) > 0;
    }

    @Override
    public int getEnergyBuffer(ItemStack stack) {
        return 40000;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxFuelValue = 2000000000;
            if (!this.hasMaxFuelSet(coinInPedestal) || this.readMaxFuelFromNBT(coinInPedestal) != getMaxFuelValue) {
                this.setMaxFuel(coinInPedestal, getMaxFuelValue);
            }
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                this.upgradeActionSendEnergy(pedestal);
                if (world.func_82737_E() % 20L == 0L) {
                    this.upgradeAction(world, pedestalPos, itemInPedestal, coinInPedestal);
                }
            }
        }
    }

    public void upgradeAction(World world, BlockPos posOfPedestal, ItemStack itemInPedestal, ItemStack coinInPedestal) {
    }

    public void setFuelStored(ItemStack stack, int fuel) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("fuel", fuel);
        stack.func_77982_d(compound);
    }

    public boolean hasFuel(ItemStack stack) {
        return this.getFuelStored(stack) > 0;
    }

    public int getFuelStored(ItemStack stack) {
        int storedFuel = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            storedFuel = getCompound.func_74762_e("fuel");
        }
        return storedFuel;
    }

    public void setMaxFuel(ItemStack stack, int amountMax) {
        this.writeMaxFuelToNBT(stack, amountMax);
    }

    public boolean hasMaxFuelSet(ItemStack stack) {
        boolean returner = false;
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("maxfuel")) {
            returner = true;
        }
        return returner;
    }

    public void writeMaxFuelToNBT(ItemStack stack, int value) {
        CompoundNBT compound = new CompoundNBT();
        if (stack.func_77942_o()) {
            compound = stack.func_77978_p();
        }
        compound.func_74768_a("maxfuel", value);
        stack.func_77982_d(compound);
    }

    public int readMaxFuelFromNBT(ItemStack stack) {
        int maxfuel = 0;
        if (stack.func_77942_o()) {
            CompoundNBT getCompound = stack.func_77978_p();
            maxfuel = getCompound.func_74762_e("maxfuel");
        }
        return maxfuel;
    }

    public boolean addFuel(PedestalTileEntity pedestal, int amountToAdd, boolean simulate) {
        int currentFuel;
        int addAmount;
        int maxFuel;
        ItemStack coin = pedestal.getCoinOnPedestal();
        if (this.hasMaxFuelSet(coin) && (maxFuel = this.readMaxFuelFromNBT(coin)) > (addAmount = (currentFuel = this.getFuelStored(coin)) + amountToAdd)) {
            if (!simulate) {
                this.setFuelStored(coin, addAmount);
                pedestal.update();
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean removeFuel(World world, BlockPos posPedestal, int amountToRemove, boolean simulate) {
        TileEntity entity = world.func_175625_s(posPedestal);
        if (entity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)entity;
            return this.removeFuel(pedestal, amountToRemove, simulate);
        }
        return false;
    }

    public boolean removeFuel(PedestalTileEntity pedestal, int amountToRemove, boolean simulate) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        if (this.hasFuel(coin)) {
            int fuelLeft = this.getFuelStored(coin);
            int amountToSet = fuelLeft - amountToRemove;
            if (fuelLeft >= amountToRemove) {
                if (!simulate) {
                    if (amountToSet == -1) {
                        amountToSet = 0;
                    }
                    this.setFuelStored(coin, amountToSet);
                    pedestal.update();
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static int getItemFuelBurnTime(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        return 1600;
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        if (!world.field_72995_K && !world.func_175640_z(posPedestal) && entityIn instanceof ItemEntity) {
            ItemStack itemStack = ((ItemEntity)entityIn).func_92059_d();
        }
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)RFMOBGEN);
    }
}

