/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBase;
import com.mowmaster.pedestals.network.PacketHandler;
import com.mowmaster.pedestals.network.PacketParticles;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEffectGrower
extends ItemUpgradeBase {
    public static final Item GROWER = (Item)new ItemUpgradeEffectGrower(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/grower"));

    public ItemUpgradeEffectGrower(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    @Override
    public boolean canAcceptAdvanced() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 1;
        return areaWidth;
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeTiny(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int getComparatorRedstoneLevel(World worldIn, BlockPos pos) {
        int intItem = 0;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tileEntity;
            ItemStack coin = pedestal.getCoinOnPedestal();
            int amount = this.workQueueSize(coin);
            int area = this.workQueueTwoSize(coin);
            if (amount > 0) {
                float f = (float)amount / (float)area;
                intItem = MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
            }
        }
        return intItem;
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        BlockPos posNums;
        if (world.field_72995_K) {
            return;
        }
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockPos pedestalPos = pedestal.func_174877_v();
        int rangeWidth = this.getAreaWidth(coinInPedestal);
        int rangeHeight = this.getHeight(coinInPedestal);
        BlockState pedestalState = world.func_180495_p(pedestalPos);
        Direction enumfacing = pedestalState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)pedestalState.func_177229_b((Property)BlockStateProperties.field_208155_H) : Direction.UP;
        BlockPos negNums = this.getNegRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight);
        if (!world.func_175707_a(negNums, posNums = this.getPosRangePosEntity(world, pedestalPos, rangeWidth, enumfacing == Direction.NORTH || enumfacing == Direction.EAST || enumfacing == Direction.SOUTH || enumfacing == Direction.WEST ? rangeHeight - 1 : rangeHeight))) {
            return;
        }
        int val = this.readStoredIntTwoFromNBT(coinInPedestal);
        if (val > 0) {
            this.writeStoredIntTwoToNBT(coinInPedestal, val - 1);
        } else {
            List<BlockPos> workQueue;
            if (pedestal.isPedestalBlockPowered(world, pedestalPos)) {
                return;
            }
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            if (this.workQueueSize(coinInPedestal) <= 0) {
                this.buildWorkQueue(pedestal, rangeWidth, rangeHeight);
                this.buildWorkQueueTwo(pedestal, rangeWidth, rangeHeight);
                if (itemInPedestal.func_190926_b()) {
                    pedestal.update();
                }
            }
            if (!(workQueue = this.readWorkQueueFromNBT(coinInPedestal)).isEmpty()) {
                int speed = this.getOperationSpeed(coinInPedestal);
                if (world.func_82737_E() % (long)speed == 0L) {
                    for (int i = 0; i < workQueue.size(); ++i) {
                        BlockPos targetPos = workQueue.get(i);
                        BlockPos blockToMinePos = new BlockPos(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
                        BlockState targetBlock = world.func_180495_p(blockToMinePos);
                        workQueue.remove(0);
                        if (!this.canMineBlock(pedestal, blockToMinePos)) continue;
                        this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                        this.upgradeAction(pedestal, world, itemInPedestal, coinInPedestal, pedestalPos, targetPos, targetBlock);
                        if (!this.hasAdvancedInventoryTargetingTwo(coinInPedestal)) break;
                    }
                    this.writeWorkQueueToNBT(coinInPedestal, workQueue);
                }
            } else {
                this.writeStoredIntTwoToNBT(coinInPedestal, 100);
            }
        }
    }

    public void upgradeAction(PedestalTileEntity pedestal, World world, ItemStack itemInPedestal, ItemStack coinInPedestal, BlockPos posOfPedestal, BlockPos posTarget, BlockState target) {
        ServerWorld sworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
        ItemStack bonemeal = new ItemStack((IItemProvider)Items.field_196106_bc);
        Random rand = new Random();
        if (target.func_177230_c() instanceof IGrowable || target.func_177230_c() instanceof IPlantable) {
            if (target.func_177230_c() instanceof IGrowable) {
                if (((IGrowable)target.func_177230_c()).func_176473_a((IBlockReader)world, posTarget, target, false)) {
                    if (this.doItemsMatch(itemInPedestal, bonemeal)) {
                        ((IGrowable)target.func_177230_c()).func_225535_a_(sworld, rand, posTarget, target);
                        TileEntity pedestalInv = world.func_175625_s(posOfPedestal);
                        if (pedestalInv instanceof PedestalTileEntity) {
                            ((PedestalTileEntity)pedestalInv).removeItem(1);
                            if (!pedestal.hasParticleDiffuser()) {
                                PacketHandler.sendToNearby(world, posOfPedestal, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR, posTarget.func_177958_n(), (double)posTarget.func_177956_o(), (double)posTarget.func_177952_p(), 0, 255, 0));
                            }
                        }
                    } else {
                        if (!pedestal.hasParticleDiffuser()) {
                            PacketHandler.sendToNearby(world, posOfPedestal, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR, posTarget.func_177958_n(), (double)posTarget.func_177956_o(), (double)posTarget.func_177952_p(), 255, 255, 255));
                        }
                        target.func_227034_b_(sworld, posTarget, rand);
                        world.func_184138_a(posTarget, target, target, 2);
                    }
                }
            } else {
                if (!pedestal.hasParticleDiffuser()) {
                    PacketHandler.sendToNearby(world, posOfPedestal, (Object)new PacketParticles(PacketParticles.EffectType.ANY_COLOR, posTarget.func_177958_n(), (double)posTarget.func_177956_o(), (double)posTarget.func_177952_p(), 255, 255, 255));
                }
                target.func_227034_b_(sworld, posTarget, rand);
                world.func_184138_a(posTarget, target, target, 2);
            }
        }
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos, PlayerEntity player) {
        BlockPos targetPos;
        BlockPos blockToGrowPos;
        World world = pedestal.func_145831_w();
        BlockState blockToGrowState = world.func_180495_p(blockToGrowPos = new BlockPos((targetPos = blockToMinePos).func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()));
        Block blockToGrow = blockToGrowState.func_177230_c();
        return (blockToGrow instanceof IGrowable || blockToGrow instanceof IPlantable) && blockToGrow instanceof IGrowable && ((IGrowable)blockToGrow).func_176473_a((IBlockReader)world, targetPos, blockToGrowState, false);
    }

    @Override
    public boolean canMineBlock(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        BlockPos targetPos;
        BlockPos blockToGrowPos;
        World world = pedestal.func_145831_w();
        BlockState blockToGrowState = world.func_180495_p(blockToGrowPos = new BlockPos((targetPos = blockToMinePos).func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()));
        Block blockToGrow = blockToGrowState.func_177230_c();
        return (blockToGrow instanceof IGrowable || blockToGrow instanceof IPlantable) && blockToGrow instanceof IGrowable && ((IGrowable)blockToGrow).func_176473_a((IBlockReader)world, targetPos, blockToGrowState, false);
    }

    @Override
    public boolean canMineBlockTwo(PedestalTileEntity pedestal, BlockPos blockToMinePos) {
        BlockPos targetPos;
        BlockPos blockToGrowPos;
        World world = pedestal.func_145831_w();
        BlockState blockToGrowState = world.func_180495_p(blockToGrowPos = new BlockPos((targetPos = blockToMinePos).func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()));
        Block blockToGrow = blockToGrowState.func_177230_c();
        return blockToGrow instanceof IGrowable || blockToGrow instanceof IPlantable;
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        TranslationTextComponent btm = new TranslationTextComponent(this.func_77658_a() + ".chat_btm");
        btm.func_240702_b_("" + this.workQueueSize(stack) + "");
        btm.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)btm, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        area.func_240699_a_(TextFormatting.WHITE);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)area);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)GROWER);
    }
}

