/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.item.pedestalUpgrades;

import com.mowmaster.pedestals.item.pedestalUpgrades.ItemUpgradeBaseMachine;
import com.mowmaster.pedestals.pedestals;
import com.mowmaster.pedestals.tiles.PedestalTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemUpgradeEffect
extends ItemUpgradeBaseMachine {
    public static final Item EFFECT = (Item)new ItemUpgradeEffect(new Item.Properties().func_200917_a(64).func_200916_a(pedestals.PEDESTALS_TAB)).setRegistryName(new ResourceLocation("pedestals", "coin/effect"));

    public ItemUpgradeEffect(Item.Properties builder) {
        super(builder.func_200916_a(pedestals.PEDESTALS_TAB));
    }

    @Override
    public boolean canAcceptCapacity() {
        return false;
    }

    @Override
    public boolean canAcceptArea() {
        return true;
    }

    @Override
    public boolean canAcceptRange() {
        return true;
    }

    public int getAreaWidth(ItemStack stack) {
        int areaWidth = 0;
        int aW = this.getAreaModifier(stack);
        areaWidth = aW + 1;
        return areaWidth;
    }

    public int getHeight(ItemStack stack) {
        return this.getRangeTiny(stack);
    }

    @Override
    public int getWorkAreaX(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public int[] getWorkAreaY(World world, BlockPos pos, ItemStack coin) {
        return new int[]{this.getHeight(coin), 0};
    }

    @Override
    public int getWorkAreaZ(World world, BlockPos pos, ItemStack coin) {
        return this.getAreaWidth(coin);
    }

    @Override
    public void updateAction(World world, PedestalTileEntity pedestal) {
        if (!world.field_72995_K) {
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            ItemStack itemInPedestal = pedestal.getItemInPedestal();
            BlockPos pedestalPos = pedestal.func_174877_v();
            int getMaxFuelValue = this.getFuelBuffer(coinInPedestal);
            if (!this.hasMaxFuelSet(coinInPedestal) || this.readMaxFuelFromNBT(coinInPedestal) != getMaxFuelValue) {
                this.setMaxFuel(coinInPedestal, getMaxFuelValue);
            }
            int speed = this.getOperationSpeed(coinInPedestal);
            if (!pedestal.isPedestalBlockPowered(world, pedestalPos) && world.func_82737_E() % (long)speed == 0L) {
                this.upgradeAction(pedestal);
            }
        }
    }

    public List<EffectInstance> getEffectFromPedestal(ItemStack itemInPedestal, int modifier) {
        List effectInstance = PotionUtils.func_185189_a((ItemStack)itemInPedestal);
        ArrayList<EffectInstance> effectInstanceReturner = new ArrayList<EffectInstance>();
        if (!itemInPedestal.func_190926_b() && effectInstance.size() > 0) {
            for (int i = 0; i < effectInstance.size(); ++i) {
                if (((EffectInstance)effectInstance.get(i)).func_188419_a().func_76403_b()) continue;
                Effect getEffect = ((EffectInstance)PotionUtils.func_185189_a((ItemStack)itemInPedestal).get(i)).func_188419_a();
                int getAmp = ((EffectInstance)PotionUtils.func_185189_a((ItemStack)itemInPedestal).get(i)).func_76458_c() + modifier;
                int getDuration = ((EffectInstance)PotionUtils.func_185189_a((ItemStack)itemInPedestal).get(i)).func_76459_b() * (modifier == 0 ? 1 : modifier + 1);
                effectInstanceReturner.add(new EffectInstance(getEffect, getDuration, getAmp, true, true));
            }
        }
        return effectInstanceReturner;
    }

    public boolean hasPotionEffect(LivingEntity entityIn, List<EffectInstance> effectIn) {
        if (entityIn instanceof LivingEntity && effectIn.size() > 0) {
            for (int i = 0; i < effectIn.size(); ++i) {
                if (entityIn.func_70660_b(effectIn.get(i).func_188419_a()) == null || entityIn.func_70660_b(effectIn.get(i).func_188419_a()).func_76458_c() < effectIn.get(i).func_76458_c() || entityIn.func_70660_b(effectIn.get(i).func_188419_a()).func_76459_b() < 100) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeFuel(World world, BlockPos posPedestal, int amountToRemove, boolean simulate) {
        PedestalTileEntity pedestal;
        ItemStack coin;
        int fuelLeft;
        TileEntity entity = world.func_175625_s(posPedestal);
        if (entity instanceof PedestalTileEntity && amountToRemove <= (fuelLeft = this.getFuelStored(coin = (pedestal = (PedestalTileEntity)entity).getCoinOnPedestal()))) {
            if (!simulate) {
                this.removeFuel(pedestal, amountToRemove, simulate);
                return true;
            }
            return true;
        }
        return false;
    }

    public void upgradeAction(PedestalTileEntity pedestal) {
        List entityList;
        World world = pedestal.func_145831_w();
        ItemStack itemInPedestal = pedestal.getItemInPedestal();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        BlockPos posOfPedestal = pedestal.func_174877_v();
        int width = this.getAreaWidth(coinInPedestal);
        int height = this.getHeight(coinInPedestal);
        BlockPos negBlockPos = this.getNegRangePosEntity(world, posOfPedestal, width, height);
        BlockPos posBlockPos = this.getPosRangePosEntity(world, posOfPedestal, width, height);
        AxisAlignedBB getBox = new AxisAlignedBB(negBlockPos, posBlockPos);
        if (!this.hasFilterBlock(coinInPedestal)) {
            this.writeFilterBlockToNBT(pedestal);
        }
        Block filterBlock = this.readFilterBlockFromNBT(coinInPedestal);
        List<EffectInstance> instance = this.getEffectFromPedestal(itemInPedestal, 0);
        if (instance.size() > 0 && (entityList = world.func_217357_a(LivingEntity.class, getBox)).size() > 0) {
            for (LivingEntity getEntityFromList : entityList) {
                if (filterBlock.equals(Blocks.field_235397_ng_)) {
                    instance = this.getEffectFromPedestal(itemInPedestal, 1);
                }
                if (this.getTargetEntity(filterBlock, getEntityFromList) == null || this.hasPotionEffect(this.getTargetEntity(filterBlock, getEntityFromList), instance)) continue;
                for (int i = 0; i < instance.size(); ++i) {
                    if (!this.removeFuel(world, posOfPedestal, instance.get(i).func_76458_c() + 1, true) || !this.getTargetEntity(filterBlock, getEntityFromList).func_195064_c(instance.get(i))) continue;
                    if (!pedestal.hasMuffler()) {
                        world.func_184148_a((PlayerEntity)null, (double)posOfPedestal.func_177958_n(), (double)posOfPedestal.func_177956_o(), (double)posOfPedestal.func_177952_p(), SoundEvents.field_187621_J, SoundCategory.BLOCKS, 0.25f, 1.0f);
                    }
                    this.removeFuel(world, posOfPedestal, instance.get(i).func_76458_c() + 1, false);
                }
            }
        }
    }

    @Override
    public void onPedestalBelowNeighborChanged(PedestalTileEntity pedestal, BlockState blockChanged, BlockPos blockChangedPos) {
        BlockPos blockBelow = this.getPosOfBlockBelow(pedestal.func_145831_w(), pedestal.func_174877_v(), 1);
        if (blockBelow.equals((Object)blockChangedPos)) {
            this.writeFilterBlockToNBT(pedestal);
        }
    }

    @Override
    public String getOperationSpeedString(ItemStack stack) {
        TranslationTextComponent normal = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_0");
        TranslationTextComponent twox = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_1");
        TranslationTextComponent fourx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_2");
        TranslationTextComponent sixx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_3");
        TranslationTextComponent tenx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_4");
        TranslationTextComponent twentyx = new TranslationTextComponent("pedestals.upgrade_tooltips.speed_5");
        String str = normal.getString();
        switch (this.intOperationalSpeedModifier(stack)) {
            case 0: {
                str = normal.getString();
                break;
            }
            case 1: {
                str = twox.getString();
                break;
            }
            case 2: {
                str = fourx.getString();
                break;
            }
            case 3: {
                str = sixx.getString();
                break;
            }
            case 4: {
                str = tenx.getString();
                break;
            }
            case 5: {
                str = twentyx.getString();
                break;
            }
            default: {
                str = normal.getString();
            }
        }
        return str;
    }

    @Override
    public void actionOnCollideWithBlock(World world, PedestalTileEntity tilePedestal, BlockPos posPedestal, BlockState state, Entity entityIn) {
        int getBurnTimeForStack;
        ItemStack getItemStack;
        if (entityIn instanceof ItemEntity && (getItemStack = ((ItemEntity)entityIn).func_92059_d()).func_77973_b().equals(Items.field_151065_br) && this.addFuel(tilePedestal, getBurnTimeForStack = 4 * getItemStack.func_190916_E(), true)) {
            this.addFuel(tilePedestal, getBurnTimeForStack, false);
            entityIn.func_70106_y();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRandomDisplayTick(PedestalTileEntity pedestal, int tick, BlockState stateIn, World world, BlockPos pos, Random rand) {
        int fuelValue;
        if (!pedestal.hasParticleDiffuser() && !world.func_175640_z(pos) && (fuelValue = this.getFuelStored(pedestal.getCoinOnPedestal())) > 0) {
            this.spawnParticleAroundPedestalBase(world, tick, pos, ParticleTypes.field_197620_m);
        }
    }

    @Override
    public void chatDetails(PlayerEntity player, PedestalTileEntity pedestal) {
        ItemStack stack = pedestal.getCoinOnPedestal();
        Block filterBlock = this.hasFilterBlock(stack) ? this.readFilterBlockFromNBT(stack) : Blocks.field_150350_a;
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent name = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        name.func_240699_a_(TextFormatting.GOLD);
        player.func_145747_a((ITextComponent)name, Util.field_240973_b_);
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".chat_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".chat_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        area.func_240699_a_(TextFormatting.WHITE);
        player.func_145747_a((ITextComponent)area, Util.field_240973_b_);
        int fuelLeft = this.getFuelStored(pedestal.getCoinOnPedestal());
        TranslationTextComponent fuel = new TranslationTextComponent(this.func_77658_a() + ".chat_fuel");
        fuel.func_240702_b_("" + fuelLeft + "");
        fuel.func_240699_a_(TextFormatting.GREEN);
        player.func_145747_a((ITextComponent)fuel, Util.field_240973_b_);
        List<EffectInstance> instance = this.getEffectFromPedestal(pedestal.getItemInPedestal(), 1);
        TranslationTextComponent effect = new TranslationTextComponent(this.func_77658_a() + ".chat_effect");
        effect.func_240699_a_(TextFormatting.AQUA);
        player.func_145747_a((ITextComponent)effect, Util.field_240973_b_);
        for (int i = 0; i < instance.size(); ++i) {
            TranslationTextComponent effects = new TranslationTextComponent(instance.get(i).func_188419_a().func_199286_c().getString());
            effects.func_240699_a_(TextFormatting.GRAY);
            player.func_145747_a((ITextComponent)effects, Util.field_240973_b_);
        }
        TranslationTextComponent entityType = new TranslationTextComponent(this.func_77658_a() + ".chat_entity");
        entityType.func_240702_b_(this.getTargetEntity(filterBlock));
        entityType.func_240699_a_(TextFormatting.YELLOW);
        player.func_145747_a((ITextComponent)entityType, Util.field_240973_b_);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".chat_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        speed.func_240699_a_(TextFormatting.RED);
        player.func_145747_a((ITextComponent)speed, Util.field_240973_b_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip_name");
        t.func_240699_a_(TextFormatting.GOLD);
        tooltip.add((ITextComponent)t);
        ResourceLocation disabled = new ResourceLocation("pedestals", "enchant_limits/advanced_blacklist");
        ITag BLACKLISTED = ItemTags.func_199903_a().func_199910_a(disabled);
        if (BLACKLISTED != null) {
            if (!BLACKLISTED.func_230235_a_((Object)stack.func_77973_b())) {
                if ((this.intOperationalSpeedOver(stack) > 5 || this.getCapacityModifierOver(stack) > 5 || this.getAreaModifierUnRestricted(stack) > 5 || this.getRangeModifier(stack) > 5) && this.getAdvancedModifier(stack) <= 0) {
                    TranslationTextComponent warning = new TranslationTextComponent("pedestals.advanced_warning");
                    warning.func_240699_a_(TextFormatting.RED);
                    tooltip.add((ITextComponent)warning);
                }
            } else if (this.getAdvancedModifier(stack) > 0) {
                TranslationTextComponent disabled_warning = new TranslationTextComponent("pedestals.advanced_disabled_warning");
                disabled_warning.func_240699_a_(TextFormatting.DARK_RED);
                tooltip.add((ITextComponent)disabled_warning);
            }
        }
        int s3 = this.getAreaWidth(stack);
        String tr = "" + (s3 + s3 + 1) + "";
        TranslationTextComponent area = new TranslationTextComponent(this.func_77658_a() + ".tooltip_area");
        TranslationTextComponent areax = new TranslationTextComponent(this.func_77658_a() + ".tooltip_areax");
        area.func_240702_b_(tr);
        area.func_240702_b_(areax.getString());
        area.func_240702_b_("" + this.getHeight(stack) + "");
        area.func_240702_b_(areax.getString());
        area.func_240702_b_(tr);
        TranslationTextComponent speed = new TranslationTextComponent(this.func_77658_a() + ".tooltip_speed");
        speed.func_240702_b_(this.getOperationSpeedString(stack));
        area.func_240699_a_(TextFormatting.WHITE);
        speed.func_240699_a_(TextFormatting.RED);
        tooltip.add((ITextComponent)area);
        TranslationTextComponent fuelStored = new TranslationTextComponent(this.func_77658_a() + ".tooltip_fuelstored");
        fuelStored.func_240702_b_("" + this.getFuelStored(stack) + "");
        fuelStored.func_240699_a_(TextFormatting.GREEN);
        tooltip.add((ITextComponent)fuelStored);
        tooltip.add((ITextComponent)speed);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)EFFECT);
    }
}

